/* R2 AIX machine/system dependent defines
   Copyright (C) 1988 Free Software Foundation, Inc.

This file is part of XEmacs.

XEmacs is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs.  If not, see <http://www.gnu.org/licenses/>. */

/* Synched up with: FSF 19.31. */

/* The following line tells the configuration script what sort of
   operating system this machine is likely to run.
   USUAL-OPSYS="aix3-1"  */

/* Now define a symbol for the cpu type, if your compiler
   does not define it automatically.  */

#define IBMR2AIX

#ifdef USG5_4
/* Just use PDUMP. */
#define CANNOT_DUMP
#endif

#ifndef UNEXEC
#define UNEXEC "unexaix.o"
#endif

/* Define addresses, macros, change some setup for dump */

#define NO_REMAP

#ifndef USG5_4
#define TEXT_START 0x10000000
#ifdef __64BIT__
#define DATA_START 0x110000000 /* empirically determined */
#else
#define DATA_START 0x20000000
#endif
#endif

#define N_BADMAG(x) BADMAG(x)
#define N_TXTOFF(x) A_TEXTPOS(x)
#define N_SYMOFF(x) A_SYMPOS(x)
#define A_TEXT_OFFSET(HDR) sizeof(HDR)
/* #define ADJUST_EXEC_HEADER \
    unexec_text_start += sizeof(hdr); \
    unexec_data_start = ohdr.a_dbase
*/
#undef ADDR_CORRECT
#define ADDR_CORRECT(x) ((int)(x))

/* Specify the font for X to use.
   This used to be Rom14.500; that's nice on the X server shipped with
   the RS/6000, but it's not available on other servers.  */
#define X_DEFAULT_FONT "fixed"

/* Here override various assumptions in ymakefile */

#ifndef USG5_4
/* XEmacs change -- commented out: dkeller@vnet.ibm.com */
/* #define C_SWITCH_MACHINE -D_BSD */
#endif

#ifdef AIX3_2
/* -lpthreads seems to be necessary for Xlib in X11R6, and should be harmless
   on older versions of X where it happens to exist.  */
#ifdef HAVE_LIBPTHREADS
#define LIBS_MACHINE "-lrts -lIM -liconv -lpthreads"
#else
/* IBM's X11R5 use -lIM and -liconv in AIX 3.2.2.  */
#define LIBS_MACHINE "-lrts -lIM -liconv"
#endif
#else
#ifdef USG5_4
#define LIBS_MACHINE
#else
#define LIBS_MACHINE "-lIM"
#endif
#endif

#define START_FILES

/* Don't try to include sioctl.h or ptem.h.  */
#undef NEED_SIOCTL
#undef NEED_PTEM_H

#define ORDINARY_LINK
