/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public final class UriUtil {
    private static Pattern PATTERN_EXCLAMATION_MARK = Pattern.compile("!/");
    private static Pattern PATTERN_CARET = Pattern.compile("\\^/");
    private static Pattern PATTERN_ASTERISK = Pattern.compile("\\*/");

    private UriUtil() {
    }

    private static boolean isSchemeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.';
    }

    public static boolean hasScheme(CharSequence uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (UriUtil.isSchemeChar(c)) continue;
            return false;
        }
        return false;
    }

    public static URL buildJarUrl(File jarFile) throws MalformedURLException {
        return UriUtil.buildJarUrl(jarFile, null);
    }

    public static URL buildJarUrl(File jarFile, String entryPath) throws MalformedURLException {
        return UriUtil.buildJarUrl(jarFile.toURI().toString(), entryPath);
    }

    public static URL buildJarUrl(String fileUrlString) throws MalformedURLException {
        return UriUtil.buildJarUrl(fileUrlString, null);
    }

    public static URL buildJarUrl(String fileUrlString, String entryPath) throws MalformedURLException {
        String safeString = UriUtil.makeSafeForJarUrl(fileUrlString);
        StringBuilder sb = new StringBuilder();
        sb.append(safeString);
        sb.append("!/");
        if (entryPath != null) {
            sb.append(UriUtil.makeSafeForJarUrl(entryPath));
        }
        return new URL("jar", "", -1, sb.toString());
    }

    public static URL buildJarSafeUrl(File file) throws MalformedURLException {
        String safe = UriUtil.makeSafeForJarUrl(file.toURI().toString());
        return new URL(safe);
    }

    private static String makeSafeForJarUrl(String input) {
        String tmp = PATTERN_EXCLAMATION_MARK.matcher(input).replaceAll("%21/");
        tmp = PATTERN_CARET.matcher(tmp).replaceAll("%5e/");
        return PATTERN_ASTERISK.matcher(tmp).replaceAll("%2a/");
    }
}

