/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.align;

import edu.umd.marbl.mhap.align.AlignElement;
import java.util.Iterator;
import java.util.List;

public final class Alignment<S extends AlignElement<S>> {
    private final double score;
    private final List<Operation> operations;
    private final S a;
    private final S b;
    private int a1;
    private int a2;
    private int b1;
    private int b2;

    protected Alignment(S a, S b, int a1, int a2, int b1, int b2, double score, double gapOpen, List<Operation> operations) {
        this.score = score;
        this.operations = operations;
        this.a = a;
        this.b = b;
        this.a1 = a1;
        this.a2 = a2;
        this.b1 = b1;
        this.b2 = b2;
    }

    public double getOverlapScore(int minMatches) {
        int i = 0;
        int j = 0;
        Iterator<Operation> iter = this.operations.iterator();
        if (!iter.hasNext()) {
            return 0.0;
        }
        Operation o = iter.next();
        while (o == Operation.DELETE) {
            ++i;
            if (iter.hasNext()) {
                o = iter.next();
                continue;
            }
            return 0.0;
        }
        if (i == 0) {
            while (o == Operation.INSERT) {
                if (iter.hasNext()) {
                    o = iter.next();
                    continue;
                }
                return 0.0;
            }
        }
        double score = 0.0;
        int count = 0;
        while (true) {
            if (o == Operation.DELETE) {
                ++i;
            } else if (o == Operation.INSERT) {
                ++j;
            } else {
                score += this.a.similarityScore(this.b, i, j);
                ++count;
                ++i;
                ++j;
            }
            if (!iter.hasNext()) break;
            o = iter.next();
        }
        if (count < minMatches) {
            return 0.0;
        }
        if (score <= 0.0) {
            return 0.0;
        }
        return score / (double)count;
    }

    protected List<Operation> getOperations() {
        return this.operations;
    }

    public double getScore() {
        return this.score;
    }

    public int getA1() {
        return this.a1;
    }

    public int getA2() {
        return this.a2;
    }

    public int getB1() {
        return this.b1;
    }

    public int getB2() {
        return this.b2;
    }

    public String outputAlignmentSelf() {
        StringBuilder str = new StringBuilder();
        int i = 0;
        int j = 0;
        int count = 0;
        while (i < this.a.length() || j < this.b.length()) {
            Operation o = count < this.operations.size() ? this.operations.get(count) : (i < this.a.length() ? Operation.DELETE : Operation.INSERT);
            if (o == Operation.DELETE) {
                String aStr = j >= this.b.length() ? this.a.toString(i) : this.a.toString(this.b, i, j);
                str.append(aStr);
                ++i;
            } else if (o == Operation.INSERT) {
                String bStr = i >= this.a.length() ? this.b.toString(j) : this.b.toString(this.a, j, i);
                for (int space = 0; space < bStr.length(); ++space) {
                    str.append("-");
                }
                ++j;
            } else {
                str.append(this.a.toString(this.b, i, j));
                ++i;
                ++j;
            }
            ++count;
        }
        return str.toString();
    }

    public String outputAlignmentOther() {
        StringBuilder str = new StringBuilder();
        int i = 0;
        int j = 0;
        int count = 0;
        while (i < this.a.length() || j < this.b.length()) {
            Operation o = count < this.operations.size() ? this.operations.get(count) : (i < this.a.length() ? Operation.DELETE : Operation.INSERT);
            if (o == Operation.INSERT) {
                String bStr = i >= this.a.length() ? this.b.toString(j) : this.b.toString(this.a, j, i);
                str.append(bStr);
                ++j;
            } else if (o == Operation.DELETE) {
                String aStr = j >= this.b.length() ? this.a.toString(i) : this.a.toString(this.b, i, j);
                for (int space = 0; space < aStr.length(); ++space) {
                    str.append("-");
                }
                ++i;
            } else {
                str.append(this.b.toString(this.a, j, i));
                ++i;
                ++j;
            }
            ++count;
        }
        return str.toString();
    }

    public String outputAlignment() {
        StringBuilder str = new StringBuilder();
        str.append("Sequence 1: ");
        str.append(this.outputAlignmentSelf() + "\n");
        str.append("Sequence 2: ");
        str.append(this.outputAlignmentOther() + "\n");
        return str.toString();
    }

    public static enum Operation {
        MATCH,
        INSERT,
        DELETE;

    }
}

