/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class CuckooHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K, V>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    final transient HashFunction<K> hash1;
    final transient HashFunction<K> hash2;
    static final Object NULL_KEY = new Object();

    public static void main(String[] args) {
        CuckooHashMap<Integer, String> map = new CuckooHashMap<Integer, String>();
        int itemCount = 25;
        for (int i = 0; i < itemCount; ++i) {
            Integer key = i;
            String val = "Value_" + i;
            map.put(key, val);
        }
        System.out.println((String)map.get(1));
        for (String v : map.values()) {
            System.out.println(v);
        }
    }

    static <T> T maskNull(T key) {
        return (T)(key == null ? NULL_KEY : key);
    }

    static <T> T unmaskNull(T key) {
        return key == NULL_KEY ? null : (T)key;
    }

    public CuckooHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.hash1 = new DefaultHashFunction<K>(2);
        this.hash2 = new DefaultHashFunction<K>(3);
        this.init();
    }

    public CuckooHashMap(HashFunction<K> h1, HashFunction<K> h2) {
        this(16, 0.75f, h1, h2);
    }

    public CuckooHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CuckooHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new DefaultHashFunction(2), new DefaultHashFunction(3));
    }

    public CuckooHashMap(int initialCapacity, float loadFactor, HashFunction<K> h1, HashFunction<K> h2) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.hash1 = h1;
        this.hash2 = h2;
        this.init();
    }

    public CuckooHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
    }

    int capacity() {
        return this.table.length;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> es = new HashSet<Map.Entry<K, V>>();
        for (Entry<K, V> e : this.table) {
            if (e == null) continue;
            es.add(e);
        }
        return es;
    }

    @Override
    public V get(Object key) {
        Object k2;
        Object k = CuckooHashMap.maskNull(key);
        int hash = this.hash(this.hash1, k);
        Entry<K, V> e = this.table[hash];
        if (e != null && ((k2 = e.key) == k || k.equals(k2))) {
            return e.value;
        }
        hash = this.hash(this.hash2, k);
        e = this.table[hash];
        if (e != null && ((k2 = e.key) == k || k.equals(k2))) {
            return e.value;
        }
        return null;
    }

    private int hash(HashFunction<K> func, Object key) {
        return func.hash(key, this.table.length);
    }

    private void init() {
    }

    private boolean insertEntry(Entry<K, V> e) {
        Entry<K, V> current = e;
        int index = this.hash(this.hash1, current.key);
        for (int count = 0; current != e || count < this.table.length; ++count) {
            Entry<K, V> temp = this.table[index];
            if (temp == null) {
                this.table[index] = current;
                return true;
            }
            this.table[index] = current;
            current = temp;
            index = index == this.hash(this.hash1, current.key) ? this.hash(this.hash2, current.key) : this.hash(this.hash1, current.key);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    private V put(K key, V value, boolean isRehash) {
        K k = CuckooHashMap.maskNull(key);
        if (this.containsKey(k)) {
            return null;
        }
        if (this.insertEntry(new Entry<K, V>(k, value))) {
            if (!isRehash) {
                ++this.size;
            }
            return null;
        }
        this.rehash(2 * this.table.length);
        return this.put(k, value);
    }

    private void rehash(int newCapacity) {
        Entry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.table = newTable;
        for (Entry<K, V> e : oldTable) {
            if (e == null) continue;
            this.put(e.key, e.value, true);
        }
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    @Override
    public int size() {
        return this.size;
    }

    static interface HashFunction<T> {
        public int hash(Object var1, int var2);
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;

        Entry(K k, V v) {
            this.value = v;
            this.key = k;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final K getKey() {
            return CuckooHashMap.unmaskNull(this.key);
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public final String toString() {
            return this.getKey() + "=>" + this.getValue();
        }
    }

    static class DefaultHashFunction<T>
    implements HashFunction<T> {
        private static final Random ENGINE = new Random();
        private int rounds;

        public DefaultHashFunction() {
            this(1);
        }

        public DefaultHashFunction(int rounds) {
            this.rounds = rounds;
        }

        @Override
        public int hash(Object key, int limit) {
            ENGINE.setSeed(key.hashCode());
            int h = ENGINE.nextInt(limit);
            for (int i = 1; i < this.rounds; ++i) {
                h = ENGINE.nextInt(limit);
            }
            return h;
        }
    }
}

