/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader;

import java.util.HashMap;
import java.util.List;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.functors.NonaryFunction;

public class BugCheck {
    public static NonaryFunction<Void> checkKnownJreBugs() {
        final List<String> bugs = ListFactory.newList();
        BugCheck.checkNPE(bugs);
        if (bugs.isEmpty()) {
            return new NonaryFunction<Void>(){

                @Override
                public Void invoke() {
                    return null;
                }
            };
        }
        return new NonaryFunction<Void>(){

            @Override
            public Void invoke() {
                System.err.println("//*********** [[ WARNING ]] ***************");
                for (String err : bugs) {
                    System.err.println("// " + err);
                }
                System.err.println("//*********** [[ WARNING ]] ***************");
                return null;
            }
        };
    }

    private static void checkNPE(List<String> errs) {
        HashMap<Integer, Integer> test = new HashMap<Integer, Integer>();
        for (int idx = 0; idx < 9000; idx += 32) {
            test.put(idx, idx);
        }
        try {
            test.put(null, null);
        }
        catch (NullPointerException e) {
            errs.add("The JRE you are using has a buggy implementation of HashMap.  CFR may not work correctly.");
        }
    }
}

