/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;

public interface ThreadWatchdog {
    public void register();

    public long maxExecutionTimeInMillis();

    public void unregister();

    public static ThreadWatchdog newInstance(long interval, long maxExecutionTime, LongSupplier relativeTimeSupplier, BiFunction<Long, Runnable, ScheduledFuture<?>> scheduler) {
        return new Default(interval, maxExecutionTime, relativeTimeSupplier, scheduler);
    }

    public static ThreadWatchdog noop() {
        return Noop.INSTANCE;
    }

    public static class Default
    implements ThreadWatchdog {
        private final long interval;
        private final long maxExecutionTime;
        private final LongSupplier relativeTimeSupplier;
        private final BiFunction<Long, Runnable, ScheduledFuture<?>> scheduler;
        private final AtomicInteger registered = new AtomicInteger(0);
        private final AtomicBoolean running = new AtomicBoolean(false);
        final ConcurrentHashMap<Thread, Long> registry = new ConcurrentHashMap();

        private Default(long interval, long maxExecutionTime, LongSupplier relativeTimeSupplier, BiFunction<Long, Runnable, ScheduledFuture<?>> scheduler) {
            this.interval = interval;
            this.maxExecutionTime = maxExecutionTime;
            this.relativeTimeSupplier = relativeTimeSupplier;
            this.scheduler = scheduler;
        }

        @Override
        public void register() {
            this.registered.getAndIncrement();
            Long previousValue = this.registry.put(Thread.currentThread(), this.relativeTimeSupplier.getAsLong());
            if (this.running.compareAndSet(false, true)) {
                this.scheduler.apply(this.interval, this::interruptLongRunningExecutions);
            }
            assert (previousValue == null);
        }

        @Override
        public long maxExecutionTimeInMillis() {
            return this.maxExecutionTime;
        }

        @Override
        public void unregister() {
            Long previousValue = this.registry.remove(Thread.currentThread());
            this.registered.decrementAndGet();
            assert (previousValue != null);
        }

        private void interruptLongRunningExecutions() {
            long currentRelativeTime = this.relativeTimeSupplier.getAsLong();
            for (Map.Entry<Thread, Long> entry : this.registry.entrySet()) {
                if (currentRelativeTime - entry.getValue() <= this.maxExecutionTime) continue;
                entry.getKey().interrupt();
            }
            if (this.registered.get() > 0) {
                this.scheduler.apply(this.interval, this::interruptLongRunningExecutions);
            } else {
                this.running.set(false);
            }
        }
    }

    public static class Noop
    implements ThreadWatchdog {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public void register() {
        }

        @Override
        public long maxExecutionTimeInMillis() {
            return Long.MAX_VALUE;
        }

        @Override
        public void unregister() {
        }
    }
}

