/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.shards;

import java.io.IOException;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;

public class ClusterSearchShardsGroup
implements Streamable,
ToXContentObject {
    private ShardId shardId;
    private ShardRouting[] shards;

    private ClusterSearchShardsGroup() {
    }

    public ClusterSearchShardsGroup(ShardId shardId, ShardRouting[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    static ClusterSearchShardsGroup readSearchShardsGroupResponse(StreamInput in) throws IOException {
        ClusterSearchShardsGroup response = new ClusterSearchShardsGroup();
        response.readFrom(in);
        return response;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardRouting[] getShards() {
        return this.shards;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = ShardId.readShardId(in);
        this.shards = new ShardRouting[in.readVInt()];
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = new ShardRouting(this.shardId, in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeVInt(this.shards.length);
        for (ShardRouting shardRouting : this.shards) {
            shardRouting.writeToThin(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (ShardRouting shard : this.getShards()) {
            shard.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

