/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.intervals.DisiPriorityQueue;
import org.apache.lucene.search.intervals.DisiWrapper;

class DisjunctionDISIApproximation
extends DocIdSetIterator {
    final DisiPriorityQueue subIterators;
    final long cost;

    public DisjunctionDISIApproximation(DisiPriorityQueue subIterators) {
        this.subIterators = subIterators;
        long cost = 0L;
        for (DisiWrapper w : subIterators) {
            cost += w.cost;
        }
        this.cost = cost;
    }

    public long cost() {
        return this.cost;
    }

    public int docID() {
        return this.subIterators.top().doc;
    }

    public int nextDoc() throws IOException {
        DisiWrapper top = this.subIterators.top();
        int doc = top.doc;
        do {
            top.doc = top.approximation.nextDoc();
            top = this.subIterators.updateTop();
        } while (top.doc == doc);
        return top.doc;
    }

    public int advance(int target) throws IOException {
        DisiWrapper top = this.subIterators.top();
        do {
            top.doc = top.approximation.advance(target);
            top = this.subIterators.updateTop();
        } while (top.doc < target);
        return top.doc;
    }
}

