/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.persist.DefaultOIDAllocator;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.OIDAllocator;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class ObjectEncoder
implements Serializable {
    private static final long serialVersionUID = -5139516629886911696L;

    public abstract boolean supportsType(Type var1);

    public final AttributeTypeDefinition constructAttributeType(Field f) throws LDAPPersistException {
        return this.constructAttributeType(f, (OIDAllocator)DefaultOIDAllocator.getInstance());
    }

    public abstract AttributeTypeDefinition constructAttributeType(Field var1, OIDAllocator var2) throws LDAPPersistException;

    public final AttributeTypeDefinition constructAttributeType(Method m) throws LDAPPersistException {
        return this.constructAttributeType(m, (OIDAllocator)DefaultOIDAllocator.getInstance());
    }

    public abstract AttributeTypeDefinition constructAttributeType(Method var1, OIDAllocator var2) throws LDAPPersistException;

    public abstract boolean supportsMultipleValues(Field var1);

    public abstract boolean supportsMultipleValues(Method var1);

    public abstract Attribute encodeFieldValue(Field var1, Object var2, String var3) throws LDAPPersistException;

    public abstract Attribute encodeMethodValue(Method var1, Object var2, String var3) throws LDAPPersistException;

    public abstract void decodeField(Field var1, Object var2, Attribute var3) throws LDAPPersistException;

    public void setNull(Field f, Object o) throws LDAPPersistException {
        try {
            f.setAccessible(true);
            Class<?> type = f.getType();
            if (type.equals(Boolean.TYPE)) {
                f.set(o, Boolean.FALSE);
            } else if (type.equals(Byte.TYPE)) {
                f.set(o, (byte)0);
            } else if (type.equals(Character.TYPE)) {
                f.set(o, Character.valueOf('\u0000'));
            } else if (type.equals(Double.TYPE)) {
                f.set(o, 0.0);
            } else if (type.equals(Float.TYPE)) {
                f.set(o, Float.valueOf(0.0f));
            } else if (type.equals(Integer.TYPE)) {
                f.set(o, 0);
            } else if (type.equals(Long.TYPE)) {
                f.set(o, 0L);
            } else if (type.equals(Short.TYPE)) {
                f.set(o, (short)0);
            } else {
                f.set(o, null);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPPersistException(PersistMessages.ERR_ENCODER_CANNOT_SET_NULL_FIELD_VALUE.get(f.getName(), o.getClass().getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
        }
    }

    public void setNull(Method m, Object o) throws LDAPPersistException {
        try {
            m.setAccessible(true);
            Class<?> type = m.getParameterTypes()[0];
            if (type.equals(Boolean.TYPE)) {
                m.invoke(o, Boolean.FALSE);
            } else if (type.equals(Byte.TYPE)) {
                m.invoke(o, (byte)0);
            } else if (type.equals(Character.TYPE)) {
                m.invoke(o, Character.valueOf('\u0000'));
            } else if (type.equals(Double.TYPE)) {
                m.invoke(o, 0.0);
            } else if (type.equals(Float.TYPE)) {
                m.invoke(o, Float.valueOf(0.0f));
            } else if (type.equals(Integer.TYPE)) {
                m.invoke(o, 0);
            } else if (type.equals(Long.TYPE)) {
                m.invoke(o, 0L);
            } else if (type.equals(Short.TYPE)) {
                m.invoke(o, (short)0);
            } else {
                m.invoke(o, type.cast(null));
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPPersistException(PersistMessages.ERR_ENCODER_CANNOT_SET_NULL_METHOD_VALUE.get(m.getName(), o.getClass().getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
        }
    }

    public abstract void invokeSetter(Method var1, Object var2, Attribute var3) throws LDAPPersistException;
}

