/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.Params;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.predicate.logical.BinaryLogicPipe;
import org.elasticsearch.xpack.sql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparisonPipe;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Range
extends ScalarFunction {
    private final Expression value;
    private final Expression lower;
    private final Expression upper;
    private final boolean includeLower;
    private final boolean includeUpper;

    public Range(Source source, Expression value, Expression lower, boolean includeLower, Expression upper, boolean includeUpper) {
        super(source, Arrays.asList(value, lower, upper));
        this.value = value;
        this.lower = lower;
        this.upper = upper;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @Override
    protected NodeInfo<Range> info() {
        return NodeInfo.create(this, Range::new, this.value, this.lower, this.includeLower, this.upper, this.includeUpper);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new Range(this.source(), newChildren.get(0), newChildren.get(1), this.includeLower, newChildren.get(2), this.includeUpper);
    }

    public Expression value() {
        return this.value;
    }

    public Expression lower() {
        return this.lower;
    }

    public Expression upper() {
        return this.upper;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    @Override
    public boolean foldable() {
        if (this.lower.foldable() && this.upper.foldable()) {
            return this.areBoundariesInvalid() || this.value.foldable();
        }
        return false;
    }

    @Override
    public Object fold() {
        boolean lowerComparsion;
        if (this.areBoundariesInvalid()) {
            return Boolean.FALSE;
        }
        Object val = this.value.fold();
        Integer lowerCompare = BinaryComparison.compare(this.lower.fold(), val);
        Integer upperCompare = BinaryComparison.compare(val, this.upper().fold());
        boolean bl = lowerCompare == null ? false : (this.includeLower ? lowerCompare <= 0 : (lowerComparsion = lowerCompare < 0));
        boolean upperComparsion = upperCompare == null ? false : (this.includeUpper ? upperCompare <= 0 : upperCompare < 0);
        return lowerComparsion && upperComparsion;
    }

    private boolean areBoundariesInvalid() {
        Integer compare = BinaryComparison.compare(this.lower.fold(), this.upper.fold());
        return compare != null && (compare > 0 || compare == 0 && (!this.includeLower || !this.includeUpper));
    }

    @Override
    public Nullability nullable() {
        return Nullability.and(this.value.nullable(), this.lower.nullable(), this.upper.nullable());
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate valueScript = this.asScript(this.value);
        ScriptTemplate lowerScript = this.asScript(this.lower);
        ScriptTemplate upperScript = this.asScript(this.upper);
        String template = this.formatTemplate(String.format(Locale.ROOT, "{sql}.and({sql}.%s(%s, %s), {sql}.%s(%s, %s))", this.includeLower() ? "gte" : "gt", valueScript.template(), lowerScript.template(), this.includeUpper() ? "lte" : "lt", valueScript.template(), upperScript.template()));
        Params params = ParamsBuilder.paramsBuilder().script(valueScript.params()).script(lowerScript.params()).script(valueScript.params()).script(upperScript.params()).build();
        return new ScriptTemplate(template, params, DataType.BOOLEAN);
    }

    @Override
    protected Pipe makePipe() {
        BinaryComparisonPipe lowerPipe = new BinaryComparisonPipe(this.source(), this, Expressions.pipe(this.value()), Expressions.pipe(this.lower()), this.includeLower() ? BinaryComparisonProcessor.BinaryComparisonOperation.GTE : BinaryComparisonProcessor.BinaryComparisonOperation.GT);
        BinaryComparisonPipe upperPipe = new BinaryComparisonPipe(this.source(), this, Expressions.pipe(this.value()), Expressions.pipe(this.upper()), this.includeUpper() ? BinaryComparisonProcessor.BinaryComparisonOperation.LTE : BinaryComparisonProcessor.BinaryComparisonOperation.LT);
        BinaryLogicPipe and = new BinaryLogicPipe(this.source(), this, lowerPipe, upperPipe, BinaryLogicProcessor.BinaryLogicOperation.AND);
        return and;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.includeLower, this.includeUpper, this.value, this.lower, this.upper);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.value, other.value) && Objects.equals(this.lower, other.lower) && Objects.equals(this.upper, other.upper);
    }

    private static String name(Expression value, Expression lower, Expression upper, boolean includeLower, boolean includeUpper) {
        StringBuilder sb = new StringBuilder();
        sb.append(Expressions.name(lower));
        if (!(lower instanceof Literal)) {
            sb.insert(0, "(");
            sb.append(")");
        }
        sb.append(includeLower ? " <= " : " < ");
        int pos = sb.length();
        sb.append(Expressions.name(value));
        if (!(value instanceof Literal)) {
            sb.insert(pos, "(");
            sb.append(")");
        }
        sb.append(includeUpper ? " <= " : " < ");
        pos = sb.length();
        sb.append(Expressions.name(upper));
        if (!(upper instanceof Literal)) {
            sb.insert(pos, "(");
            sb.append(")");
        }
        return sb.toString();
    }
}

