/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;

public class GroupByDateHistogram
extends GroupByKey {
    private final long interval;
    private final ZoneId zoneId;

    public GroupByDateHistogram(String id, String fieldName, long interval, ZoneId zoneId) {
        this(id, fieldName, null, null, interval, zoneId);
    }

    public GroupByDateHistogram(String id, ScriptTemplate script, long interval, ZoneId zoneId) {
        this(id, null, script, null, interval, zoneId);
    }

    private GroupByDateHistogram(String id, String fieldName, ScriptTemplate script, Sort.Direction direction, long interval, ZoneId zoneId) {
        super(id, fieldName, script, direction);
        this.interval = interval;
        this.zoneId = zoneId;
    }

    public long interval() {
        return this.interval;
    }

    @Override
    protected CompositeValuesSourceBuilder<?> createSourceBuilder() {
        return new DateHistogramValuesSourceBuilder(this.id()).interval(this.interval).timeZone(DateUtils.zoneIdToDateTimeZone((ZoneId)this.zoneId));
    }

    @Override
    protected GroupByKey copy(String id, String fieldName, ScriptTemplate script, Sort.Direction direction) {
        return new GroupByDateHistogram(id, fieldName, script, direction, this.interval, this.zoneId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval, this.zoneId);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GroupByDateHistogram other = (GroupByDateHistogram)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.zoneId, other.zoneId);
        }
        return false;
    }
}

