/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.Agg;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class GroupByKey
extends Agg {
    protected final Sort.Direction direction;
    private final ScriptTemplate script;

    protected GroupByKey(String id, String fieldName, ScriptTemplate script, Sort.Direction direction) {
        super(id, fieldName);
        this.direction = direction == null ? Sort.Direction.ASC : direction;
        this.script = script;
    }

    public final CompositeValuesSourceBuilder<?> asValueSource() {
        CompositeValuesSourceBuilder<?> builder = this.createSourceBuilder();
        if (this.script != null) {
            builder.script(this.script.toPainless());
            if (this.script.outputType().isInteger()) {
                builder.valueType(ValueType.LONG);
            } else if (this.script.outputType().isRational()) {
                builder.valueType(ValueType.DOUBLE);
            } else if (this.script.outputType().isString()) {
                builder.valueType(ValueType.STRING);
            } else if (this.script.outputType() == DataType.DATE) {
                builder.valueType(ValueType.LONG);
            } else if (this.script.outputType() == DataType.DATETIME) {
                builder.valueType(ValueType.LONG);
            } else if (this.script.outputType() == DataType.BOOLEAN) {
                builder.valueType(ValueType.BOOLEAN);
            } else if (this.script.outputType() == DataType.IP) {
                builder.valueType(ValueType.IP);
            }
        } else {
            builder.field(this.fieldName());
        }
        return builder.order(this.direction.asOrder()).missingBucket(true);
    }

    protected abstract CompositeValuesSourceBuilder<?> createSourceBuilder();

    protected abstract GroupByKey copy(String var1, String var2, ScriptTemplate var3, Sort.Direction var4);

    public GroupByKey with(Sort.Direction direction) {
        return this.direction == direction ? this : this.copy(this.id(), this.fieldName(), this.script, direction);
    }

    public ScriptTemplate script() {
        return this.script;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id(), this.fieldName(), this.script, this.direction});
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.script, ((GroupByKey)obj).script) && Objects.equals((Object)this.direction, (Object)((GroupByKey)obj).direction);
    }
}

