/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gui.GuiUtils;

public class FindDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private JComboBox m_comboBox;
    private JTextField m_textField;
    private final String m_initialValue;
    private String m_pattern;

    public FindDialog(Frame frame, String string) {
        super(frame, "Find", true);
        this.m_initialValue = string;
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.add((Component)this.createPanel(), "Center");
        container.add((Component)this.createButtons(), "South");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("cancel")) {
            this.dispose();
        } else if (string.equals("comboBoxEdited") || string.equals("find")) {
            this.m_pattern = this.m_comboBox.getSelectedItem().toString();
            this.m_comboBox.insertItemAt(this.m_pattern, 0);
            FindDialog.saveHistory(this.getHistory());
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && !this.m_comboBox.isPopupVisible()) {
            this.dispose();
        }
    }

    public static Pattern run(Frame frame, String string) {
        FindDialog findDialog = new FindDialog(frame, string);
        findDialog.setLocationRelativeTo(frame);
        findDialog.setVisible(true);
        String string2 = findDialog.m_pattern;
        if (string2 == null || string2.trim().equals("")) {
            return null;
        }
        int n = 10;
        return Pattern.compile(string2, n);
    }

    private JPanel createButtons() {
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        jPanel.setBorder(GuiUtils.createEmptyBorder());
        JButton jButton = new JButton("Find");
        jButton.setActionCommand("find");
        jButton.addActionListener(this);
        jButton.setMnemonic(70);
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this);
        jButton2.setMnemonic(67);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(GuiUtils.createEmptyBorder());
        JLabel jLabel = new JLabel("Search Pattern");
        jLabel.setHorizontalAlignment(2);
        jPanel.add(jLabel);
        jPanel.add(this.createInputPanel());
        return jPanel;
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.m_comboBox = new JComboBox<Object>(this.loadHistory().toArray());
        StringBuffer stringBuffer = new StringBuffer(70);
        for (int i = 0; i < 40; ++i) {
            stringBuffer.append('-');
        }
        this.m_comboBox.setPrototypeDisplayValue(stringBuffer.toString());
        this.m_comboBox.setEditable(true);
        ComboBoxEditor comboBoxEditor = this.m_comboBox.getEditor();
        this.m_comboBox.addActionListener(this);
        this.m_textField = (JTextField)comboBoxEditor.getEditorComponent();
        this.m_textField.selectAll();
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27 && !FindDialog.this.m_comboBox.isPopupVisible()) {
                    FindDialog.this.dispose();
                }
            }
        };
        this.m_textField.addKeyListener(keyAdapter);
        GuiUtils.setMonospacedFont(this.m_comboBox);
        jPanel2.add((Component)this.m_comboBox, "Center");
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private ArrayList getHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        int n = 20;
        int n2 = this.m_comboBox.getItemCount();
        int n3 = n2;
        if (n3 > n) {
            n3 = n;
        }
        for (int i = 0; i < n3; ++i) {
            arrayList.add(this.m_comboBox.getItemAt(i).toString().trim());
        }
        return arrayList;
    }

    private static File getHistoryFile() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".gogui");
        if (!file.exists()) {
            file.mkdir();
        }
        return new File(file, "find-history");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList loadHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        if (this.m_initialValue != null) {
            arrayList.add(this.m_initialValue);
        }
        File file = FindDialog.getHistoryFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (!arrayList.contains(string = string.trim())) {
                        arrayList.add(string);
                    }
                    string = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    private static void saveHistory(ArrayList arrayList) {
        File file = FindDialog.getHistoryFile();
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                if (string.equals("")) continue;
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

