/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.vcf;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import org.campagnelab.goby.readers.vcf.ColumnField;
import org.campagnelab.goby.readers.vcf.ColumnFields;

public class ColumnInfo
implements Cloneable {
    protected String columnName;
    public ColumnFields fields = new ColumnFields();
    public int columnIndex = -1;
    public boolean useFormat = false;
    public int formatIndex = 0;
    private ObjectArraySet<String> columnGroups = new ObjectArraySet();

    public String getColumnName() {
        return this.columnName;
    }

    public ColumnInfo(String columnName, ColumnField ... fields) {
        this(columnName, false, fields);
    }

    public ColumnInfo(String columnName, boolean transferGroups, ColumnField ... fields) {
        this.columnName = columnName;
        this.fields.addAll(Arrays.asList(fields));
        for (ColumnField field : fields) {
            field.column = this;
            if (!transferGroups) continue;
            this.columnGroups.addAll(field.getGroups());
        }
    }

    public ColumnInfo() {
    }

    public void addField(ColumnField field) {
        this.fields.add(field);
        field.column = this;
        for (String columnGroup : this.columnGroups) {
            field.addGroup(columnGroup);
        }
    }

    public boolean hasField(String fieldName) {
        return this.fields.hasFieldName(fieldName);
    }

    public ColumnField getField(String fieldName) {
        if ("VALUE".equals(fieldName) && this.fields.size() == 1) {
            return (ColumnField)this.fields.list.get(0);
        }
        return this.fields.find(fieldName);
    }

    public ColumnInfo copy() {
        ColumnField[] fieldCopy = new ColumnField[this.fields.size()];
        int i = 0;
        ObjectIterator<ColumnField> objectIterator = this.fields.iterator();
        while (objectIterator.hasNext()) {
            ColumnField f = (ColumnField)objectIterator.next();
            fieldCopy[i++] = new ColumnField(f.id, f.numberOfValues, f.type, f.description, f.getGroups().toArray(new String[f.getGroups().size()]));
        }
        ColumnInfo copy = new ColumnInfo(this.columnName, fieldCopy);
        copy.addGroup((String[])this.columnGroups.toArray((Object[])new String[this.columnGroups.size()]));
        return copy;
    }

    private void addGroup(String ... columnGroups) {
        this.columnGroups.addAll((Collection)ObjectArrayList.wrap((Object[])columnGroups));
    }

    public String[] getGroups() {
        return (String[])this.columnGroups.toArray((Object[])new String[this.columnGroups.size()]);
    }
}

