/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import java.util.zip.Adler32;
import org.apache.commons.lang.StringUtils;

public final class SimpleChecksum {
    private static final char[] CHECKSUM_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private SimpleChecksum() {
    }

    public static String simpleChecksum(String valToChecksum) {
        if (StringUtils.isEmpty((String)valToChecksum)) {
            return valToChecksum;
        }
        Adler32 adler = new Adler32();
        adler.update(valToChecksum.getBytes());
        long[] result = SimpleChecksum.splitLong(adler.getValue());
        return String.format("%s%c%c", valToChecksum, Character.valueOf(CHECKSUM_CHARS[(int)result[0]]), Character.valueOf(CHECKSUM_CHARS[(int)result[1]]));
    }

    public static boolean validate(String checksumString) {
        if (checksumString == null || checksumString.length() < 3) {
            return false;
        }
        String baseString = checksumString.substring(0, checksumString.length() - 2);
        String newVal = SimpleChecksum.simpleChecksum(baseString);
        return checksumString.equals(newVal);
    }

    private static long[] splitLong(long inval) {
        String checksumString = Long.toHexString(inval);
        String[] maskStrings = SimpleChecksum.makeHexMaskStrings(checksumString);
        long[] maskLongs = new long[]{Long.parseLong(maskStrings[0], 16), Long.parseLong(maskStrings[1], 16)};
        long[] result = new long[]{(inval & maskLongs[0]) % (long)CHECKSUM_CHARS.length, (inval & maskLongs[1]) % (long)CHECKSUM_CHARS.length};
        return result;
    }

    static String[] makeHexMaskStrings(String hexString) {
        int i;
        int rightSize;
        int leftSize;
        if (StringUtils.isEmpty((String)hexString) || hexString.length() > 16) {
            throw new IllegalArgumentException("Hex string '" + hexString + "' must be 1 to 16 characters long and not null.");
        }
        for (int i2 = 0; i2 < hexString.length(); ++i2) {
            char c = hexString.charAt(i2);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException("Hex string '" + hexString + "' must contain only hex digits, 0-9A-F");
        }
        if (hexString.length() == 1) {
            leftSize = 0;
            rightSize = 1;
        } else {
            leftSize = hexString.length() / 2;
            rightSize = hexString.length() - leftSize;
        }
        StringBuilder leftMask = new StringBuilder();
        StringBuilder rightMask = new StringBuilder();
        for (i = 0; i < leftSize; ++i) {
            leftMask.append('F');
            rightMask.append('0');
        }
        for (i = 0; i < rightSize; ++i) {
            leftMask.append('0');
            rightMask.append('F');
        }
        String[] masks = new String[]{leftMask.toString(), rightMask.toString()};
        return masks;
    }
}

