/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.BoardPainter;
import free.chess.Move;
import free.chess.Piece;
import free.chess.PieceChooser;
import free.chess.PiecePainter;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;
import free.chess.WildVariant;
import free.chess.event.MoveProgressEvent;
import free.chess.event.MoveProgressListener;
import free.util.AppKiller;
import free.util.PaintHook;
import free.util.PlatformUtils;
import free.util.Utilities;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JBoard
extends JComponent {
    private static final Color DEFAULT_MOVE_HIGHLIGHT_COLOR = Color.cyan.darker();
    private static final Color DEFAULT_COORDS_DISPLAY_COLOR = Color.blue.darker();
    private static final Color DEFAULT_MADE_MOVE_SQUARES_HIGHLIGHT_COLOR = Color.blue;
    public static final int DRAG_N_DROP = 1;
    public static final int CLICK_N_CLICK = 2;
    public static final int NO_PIECES_MOVE = 0;
    public static final int WHITE_PIECES_MOVE = 1;
    public static final int BLACK_PIECES_MOVE = 2;
    public static final int ALL_PIECES_MOVE = 3;
    public static final int CURRENT_PLAYER_MOVES = 4;
    public static final int NO_MOVE_HIGHLIGHTING = 0;
    public static final int TARGET_SQUARE_MOVE_HIGHLIGHTING = 1;
    public static final int BOTH_SQUARES_MOVE_HIGHLIGHTING = 2;
    public static final int ARROW_MOVE_HIGHLIGHTING = 3;
    public static final int NO_COORDS = 0;
    public static final int RIM_COORDS = 1;
    public static final int OUTSIDE_COORDS = 2;
    public static final int EVERY_SQUARE_COORDS = 3;
    private Position position;
    private Position positionCopy;
    private ChangeListener positionChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = JBoard.this.movedPieceSquare != null;
            Rectangle rectangle = new Rectangle();
            if (bl) {
                rectangle = JBoard.this.getMoveAreaRect(rectangle);
                JBoard.this.repaint(rectangle);
            }
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    Piece piece = JBoard.this.positionCopy.getPieceAt(i, j);
                    Piece piece2 = JBoard.this.position.getPieceAt(i, j);
                    if (bl && i == JBoard.this.movedPieceSquare.getFile() && j == JBoard.this.movedPieceSquare.getRank()) {
                        bl = false;
                        continue;
                    }
                    if (Utilities.areEqual((Object)piece, (Object)piece2)) continue;
                    rectangle = JBoard.this.squareToRect(i, j, rectangle);
                    JBoard.this.repaint(rectangle);
                }
            }
            if (JBoard.this.isHighlightMadeMoveSquares() && JBoard.this.movedPieceSquare != null) {
                rectangle = JBoard.this.squareToRect(JBoard.this.movedPieceSquare, rectangle);
                JBoard.this.repaint(rectangle);
            }
            if (JBoard.this.movedPieceSquare != null && JBoard.this.position.getPieceAt(JBoard.this.movedPieceSquare) == null) {
                JBoard.this.cancelMovingPiece();
            }
            JBoard.this.positionCopy.copyFrom(JBoard.this.position);
        }
    };
    private BoardPainter boardPainter;
    private PiecePainter piecePainter;
    private Vector paintHooks = null;
    private int moveInputStyle = 1;
    private int moveInputMode = 3;
    private boolean isPieceFollowsCursor = true;
    private boolean isHighlightMadeMoveSquares = false;
    private int moveHighlightingStyle = 0;
    private int coordsDisplayStyle = 0;
    private boolean isEditable = true;
    private boolean isFlipped = false;
    private boolean isManualPromote = true;
    private Color moveHighlightingColor = DEFAULT_MOVE_HIGHLIGHT_COLOR;
    private Color coordsDisplayColor = DEFAULT_COORDS_DISPLAY_COLOR;
    private Color madeMoveSquaresHighlightColor = DEFAULT_MADE_MOVE_SQUARES_HIGHLIGHT_COLOR;
    private Move highlightedMove = null;
    private boolean[][] isShaded = new boolean[8][8];
    private Square movedPieceSquare = null;
    private Point movedPieceLoc = null;
    private boolean isShowingModalDialog = false;
    private static final Font COORDS_FONT = new Font("Monospaced", 1, 10);

    public JBoard(Position position, BoardPainter boardPainter, PiecePainter piecePainter) {
        if (position == null) {
            throw new IllegalArgumentException("The Position may not be null");
        }
        if (boardPainter == null) {
            throw new IllegalArgumentException("The BoardPainter may not be null");
        }
        if (piecePainter == null) {
            throw new IllegalArgumentException("The PiecePainter may not be null");
        }
        this.setPosition(position);
        this.boardPainter = boardPainter;
        this.piecePainter = piecePainter;
        this.setOpaque(true);
        this.enableEvents(48L);
    }

    public JBoard(Position position) {
        this(position, position.getVariant().createDefaultBoardPainter(), position.getVariant().createDefaultPiecePainter());
    }

    public JBoard() {
        this(new Position());
    }

    public void addMoveProgressListener(MoveProgressListener moveProgressListener) {
        this.listenerList.add(MoveProgressListener.class, moveProgressListener);
    }

    public void removeMoveProgressListener(MoveProgressListener moveProgressListener) {
        this.listenerList.remove(MoveProgressListener.class, moveProgressListener);
    }

    protected void fireMoveProgressEvent(MoveProgressEvent moveProgressEvent) {
        int n = moveProgressEvent.getId();
        Object[] objectArray = this.listenerList.getListenerList();
        block4: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$free$chess$event$MoveProgressListener == null ? JBoard.class$("free.chess.event.MoveProgressListener") : class$free$chess$event$MoveProgressListener)) continue;
            MoveProgressListener moveProgressListener = (MoveProgressListener)objectArray[i + 1];
            switch (n) {
                case 1: {
                    moveProgressListener.moveMakingStarted(moveProgressEvent);
                    continue block4;
                }
                case 2: {
                    moveProgressListener.moveMakingEnded(moveProgressEvent);
                }
            }
        }
    }

    public void addPaintHook(PaintHook paintHook) {
        if (this.paintHooks == null) {
            this.paintHooks = new Vector(2);
        }
        this.paintHooks.addElement(paintHook);
    }

    public void removePaintHook(PaintHook paintHook) {
        this.paintHooks.removeElement(paintHook);
        if (this.paintHooks.size() == 0) {
            this.paintHooks = null;
        }
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        if (position == null) {
            throw new IllegalArgumentException("Null position");
        }
        Position position2 = this.position;
        if (this.position != null) {
            this.position.removeChangeListener(this.positionChangeListener);
        }
        this.position = position;
        this.position.addChangeListener(this.positionChangeListener);
        if (this.positionCopy == null) {
            this.positionCopy = new Position(this.position);
        } else {
            this.positionCopy.copyFrom(this.position);
        }
        this.repaint();
        this.firePropertyChange("position", position2, position);
    }

    public void setMoveInputStyle(int n) {
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal move input style value: " + n);
            }
        }
        int n2 = this.moveInputStyle;
        this.moveInputStyle = n;
        this.firePropertyChange("moveInputStyle", n2, n);
    }

    public int getMoveInputStyle() {
        return this.moveInputStyle;
    }

    public void setMoveInputMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal move input mode value: " + n);
            }
        }
        int n2 = this.moveInputMode;
        this.moveInputMode = n;
        this.firePropertyChange("moveInputMode", n2, n);
    }

    public int getMoveInputMode() {
        return this.moveInputMode;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable;
        this.isEditable = bl;
        this.firePropertyChange("editable", bl2, bl);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setPieceFollowsCursor(boolean bl) {
        boolean bl2 = this.isPieceFollowsCursor;
        this.isPieceFollowsCursor = bl;
        this.firePropertyChange("pieceFollowsCursor", bl2, bl);
    }

    public boolean isPieceFollowsCursor() {
        return this.isPieceFollowsCursor;
    }

    public void setHighlightMadeMoveSquares(boolean bl) {
        boolean bl2 = this.isHighlightMadeMoveSquares;
        this.isHighlightMadeMoveSquares = bl;
        this.firePropertyChange("highlightMadeMoveSquares", bl2, bl);
    }

    public boolean isHighlightMadeMoveSquares() {
        return this.isHighlightMadeMoveSquares;
    }

    public void setMoveHighlightingStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal move highlighting style value: " + n);
            }
        }
        int n2 = this.moveHighlightingStyle;
        this.moveHighlightingStyle = n;
        if (this.highlightedMove != null) {
            this.repaint();
        }
        this.firePropertyChange("moveHighlightingStyle", n2, n);
    }

    public int getMoveHighlightingStyle() {
        return this.moveHighlightingStyle;
    }

    public void setHighlightedMove(Move move) {
        this.repaintHighlighting();
        this.highlightedMove = move;
        this.repaintHighlighting();
    }

    private void repaintHighlighting() {
        int n = this.getMoveHighlightingStyle();
        if (n == 0 || this.highlightedMove == null) {
            return;
        }
        Square square = this.highlightedMove.getStartingSquare();
        Square square2 = this.highlightedMove.getEndingSquare();
        if (square == null || square2 == null) {
            return;
        }
        if (n == 1) {
            this.repaint(this.squareToRect(square2, null));
        }
        if (n == 2) {
            this.repaint(this.squareToRect(square, null));
            this.repaint(this.squareToRect(square2, null));
        } else if (n == 3) {
            this.repaint(this.squareToRect(square, null).union(this.squareToRect(square2, null)));
        }
    }

    public void setCoordsDisplayStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal coordinates display style value: " + n);
            }
        }
        int n2 = this.coordsDisplayStyle;
        this.coordsDisplayStyle = n;
        this.repaint();
        this.firePropertyChange("coordsDisplayStyle", n2, n);
    }

    public int getCoordsDisplayStyle() {
        return this.coordsDisplayStyle;
    }

    public void setFlipped(boolean bl) {
        boolean bl2 = this.isFlipped;
        this.isFlipped = bl;
        this.repaint();
        this.firePropertyChange("flipped", bl2, bl);
    }

    public boolean isFlipped() {
        return this.isFlipped;
    }

    public void setManualPromote(boolean bl) {
        boolean bl2 = this.isManualPromote;
        this.isManualPromote = bl;
        this.firePropertyChange("manualPromote", bl2, bl);
    }

    public boolean isManualPromote() {
        return this.isManualPromote;
    }

    public BoardPainter getBoardPainter() {
        return this.boardPainter;
    }

    public PiecePainter getPiecePainter() {
        return this.piecePainter;
    }

    public void setBoardPainter(BoardPainter boardPainter) {
        if (boardPainter == null) {
            boardPainter = this.position.getVariant().createDefaultBoardPainter();
        }
        BoardPainter boardPainter2 = this.boardPainter;
        this.boardPainter = boardPainter;
        this.repaint();
        this.firePropertyChange("boardPainter", boardPainter2, boardPainter);
    }

    public void setPiecePainter(PiecePainter piecePainter) {
        if (piecePainter == null) {
            piecePainter = this.position.getVariant().createDefaultPiecePainter();
        }
        PiecePainter piecePainter2 = this.piecePainter;
        this.piecePainter = piecePainter;
        this.repaint();
        this.firePropertyChange("piecePainter", piecePainter2, piecePainter);
    }

    public void setMoveHighlightingColor(Color color) {
        if (color == null) {
            color = DEFAULT_MOVE_HIGHLIGHT_COLOR;
        }
        Color color2 = this.moveHighlightingColor;
        this.moveHighlightingColor = color;
        this.repaint();
        this.firePropertyChange("moveHighlightingColor", color2, color);
    }

    public Color getMoveHighlightingColor() {
        return this.moveHighlightingColor;
    }

    public void setCoordsDisplayColor(Color color) {
        if (color == null) {
            color = DEFAULT_COORDS_DISPLAY_COLOR;
        }
        Color color2 = this.coordsDisplayColor;
        this.coordsDisplayColor = color;
        this.repaint();
        this.firePropertyChange("coordsDisplayColor", color2, color);
    }

    public Color getCoordsDisplayColor() {
        return this.coordsDisplayColor;
    }

    public void setMadeMoveSquaresHighlightColor(Color color) {
        if (color == null) {
            color = DEFAULT_MADE_MOVE_SQUARES_HIGHLIGHT_COLOR;
        }
        Color color2 = this.madeMoveSquaresHighlightColor;
        this.madeMoveSquaresHighlightColor = color;
        this.repaint();
        this.firePropertyChange("madeMoveSquaresHighlightColor", color2, color);
    }

    public Color getMadeMoveSquaresHighlightColor() {
        return this.madeMoveSquaresHighlightColor;
    }

    public void setShaded(Square square, boolean bl) {
        boolean bl2 = this.isShaded[square.getFile()][square.getRank()];
        this.isShaded[square.getFile()][square.getRank()] = bl;
        if (bl2 != bl) {
            this.repaint(this.squareToRect(square, null));
        }
    }

    public void clearShaded() {
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean bl = this.isShaded[i][j];
                this.isShaded[i][j] = false;
                if (!bl) continue;
                this.repaint(this.squareToRect(i, j, rectangle));
            }
        }
    }

    public boolean isShaded(Square square) {
        return this.isShaded[square.getFile()][square.getRank()];
    }

    public boolean isMovingPiece() {
        return this.movedPieceSquare != null;
    }

    public void cancelMovingPiece() {
        if (!this.isMovingPiece()) {
            throw new IllegalStateException();
        }
        this.repaint(this.getMoveAreaRect(null));
        this.repaint(this.squareToRect(this.movedPieceSquare, null));
        this.movedPieceSquare = null;
        this.movedPieceLoc = null;
        this.fireMoveProgressEvent(new MoveProgressEvent(this, 2));
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle2 = this.getBoardRect(null);
        graphics2D.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle3 = graphics2D.getClipBounds();
        Position position = this.getPosition();
        BoardPainter boardPainter = this.getBoardPainter();
        PiecePainter piecePainter = this.getPiecePainter();
        boolean bl = this.isPieceFollowsCursor();
        boolean bl2 = this.isHighlightMadeMoveSquares();
        int n2 = this.getMoveHighlightingStyle();
        boardPainter.paintBoard(graphics2D, this, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                Piece piece;
                Square square = Square.getInstance(n, i);
                if (bl && square.equals(this.movedPieceSquare) || (piece = position.getPieceAt(square)) == null) continue;
                this.squareToRect(square, rectangle2);
                if (!rectangle2.intersects(rectangle3)) continue;
                piecePainter.paintPiece(piece, graphics2D, this, rectangle2, this.isShaded(square));
            }
        }
        if (n2 != 0 && this.highlightedMove != null) {
            Square square = this.highlightedMove.getStartingSquare();
            Square square2 = this.highlightedMove.getEndingSquare();
            this.squareToRect(Square.getInstance(0, 0), rectangle2);
            int n3 = Math.max(2, Math.min(rectangle2.width, rectangle2.height) / 12);
            if (square != null && square2 != null) {
                if (n2 == 2) {
                    this.drawSquare(graphics2D, square, n3 - Math.max(1, n3 / 3), this.getMoveHighlightingColor());
                    this.drawSquare(graphics2D, square2, n3, this.getMoveHighlightingColor());
                } else if (n2 == 3) {
                    this.drawArrow(graphics2D, square, square2, n3 + 1, this.getMoveHighlightingColor());
                }
            }
            if (square2 != null && n2 == 1) {
                this.drawSquare(graphics2D, square2, n3, this.getMoveHighlightingColor());
            }
        }
        rectangle2 = graphics2D.getClipBounds();
        graphics2D.setClip(rectangle);
        this.drawCoords(graphics);
        graphics2D.setClip(rectangle2);
        this.callPaintHooks(graphics2D);
        if (this.movedPieceSquare != null) {
            if (bl2) {
                this.getTargetSquareRect(rectangle2);
                n = Math.max(2, Math.min(rectangle2.width, rectangle2.height) / 15);
                int n4 = Math.min(2 * n / 3, n - 1);
                Square square = this.locationToSquare(rectangle2.x, rectangle2.y);
                if (square != null) {
                    this.drawSquare(graphics2D, square, n, this.getMadeMoveSquaresHighlightColor());
                }
                this.drawSquare(graphics2D, this.movedPieceSquare, n4, this.getMadeMoveSquaresHighlightColor());
            }
            if (bl) {
                this.getMovedPieceGraphicRect(rectangle2);
                Piece piece = position.getPieceAt(this.movedPieceSquare);
                piecePainter.paintPiece(piece, graphics2D, this, rectangle2, false);
            }
        }
    }

    private void drawCoords(Graphics graphics) {
        graphics.setColor(this.getCoordsDisplayColor());
        switch (this.getCoordsDisplayStyle()) {
            case 0: {
                break;
            }
            case 1: {
                this.drawRimCoords(graphics);
                break;
            }
            case 2: {
                this.drawOutsideCoords(graphics);
                break;
            }
            case 3: {
                this.drawEverySquareCoords(graphics);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown coordinates display style value: " + this.getCoordsDisplayStyle());
            }
        }
    }

    private void drawRimCoords(Graphics graphics) {
        int n;
        char c;
        int n2;
        Rectangle rectangle = this.getBoardRect(null);
        int n3 = rectangle.width / 8;
        int n4 = rectangle.height / 8;
        Rectangle rectangle2 = graphics.getClipBounds();
        int n5 = Math.max(Math.min(n3, n4) / 4, 8);
        Font font = new Font(COORDS_FONT.getName(), 1, n5);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n6 = fontMetrics.stringWidth("a");
        int n7 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n8 = n2 = this.isFlipped() ? 1 : -1;
        if (rectangle2.intersects(new Rectangle(rectangle.x, rectangle.y, n3 / 2, rectangle.height))) {
            c = this.isFlipped() ? (char)'1' : '8';
            for (n = 0; n < 8; ++n) {
                graphics.drawString(String.valueOf(c), rectangle.x + 3, rectangle.y + n * n4 + n7);
                c = (char)(c + n2);
            }
        }
        if (rectangle2.intersects(new Rectangle(rectangle.x, rectangle.y + rectangle.height - n4 / 2, rectangle.width, n4 / 2))) {
            c = this.isFlipped() ? (char)'h' : 'a';
            for (n = 0; n < 8; ++n) {
                graphics.drawString(String.valueOf(c), rectangle.x + (n + 1) * n3 - n6 - 3, rectangle.y + rectangle.height - 3);
                c = (char)(c - n2);
            }
        }
    }

    private void drawOutsideCoords(Graphics graphics) {
        int n;
        char c;
        int n2;
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getBoardRect(null);
        int n3 = rectangle.width / 8;
        int n4 = rectangle.height / 8;
        Rectangle rectangle2 = graphics.getClipBounds();
        int n5 = n3 / 3;
        int n6 = n4 / 3;
        int n7 = Math.max(Math.min(n5, n6), 8);
        Font font = new Font(COORDS_FONT.getName(), COORDS_FONT.getStyle(), n7);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n8 = fontMetrics.stringWidth("a");
        int n9 = n2 = this.isFlipped() ? 1 : -1;
        if (rectangle2.intersects(new Rectangle(insets.left, insets.top, rectangle.x - insets.left, rectangle.height))) {
            c = this.isFlipped() ? (char)'1' : '8';
            for (n = 0; n < 8; ++n) {
                graphics.drawString(String.valueOf(c), insets.left + (rectangle.x - insets.left - n8 + 1) / 2, rectangle.y + n * n4 + (n4 + fontMetrics.getAscent()) / 2 - 1);
                c = (char)(c + n2);
            }
        }
        if (rectangle2.intersects(new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, c = this.getHeight() - rectangle.y - rectangle.height - insets.bottom))) {
            n = this.isFlipped() ? 104 : 97;
            for (int i = 0; i < 8; ++i) {
                graphics.drawString(String.valueOf((char)n), rectangle.x + i * n3 + (n3 - n8) / 2, rectangle.y + rectangle.height + (c + fontMetrics.getAscent()) / 2 - 1);
                n = (char)(n - n2);
            }
        }
    }

    private void drawEverySquareCoords(Graphics graphics) {
        Rectangle rectangle = this.getBoardRect(null);
        int n = rectangle.width / 8;
        int n2 = rectangle.height / 8;
        Rectangle rectangle2 = graphics.getClipBounds();
        int n3 = Math.max(Math.min(n, n2) / 5, 8);
        Font font = new Font(COORDS_FONT.getName(), COORDS_FONT.getStyle(), n3);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, n, n2);
        int n5 = this.isFlipped() ? 1 : -1;
        char c = this.isFlipped() ? (char)'1' : '8';
        for (int i = 0; i < 8; ++i) {
            char c2 = this.isFlipped() ? (char)'h' : 'a';
            for (int j = 0; j < 8; ++j) {
                rectangle3.x = rectangle.x + j * n;
                rectangle3.y = rectangle.y + i * n2;
                if (rectangle2.intersects(rectangle3)) {
                    graphics.drawString(String.valueOf(c2) + String.valueOf(c), rectangle3.x + 3, rectangle3.y + n4);
                }
                c2 = (char)(c2 - n5);
            }
            c = (char)(c + n5);
        }
    }

    protected void drawArrow(Graphics graphics, Square square, Square square2, float f, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.squareToRect(square, null);
        Rectangle rectangle2 = this.squareToRect(square2, null);
        float f2 = rectangle.x + rectangle.width / 2;
        float f3 = rectangle.y + rectangle.height / 2;
        float f4 = rectangle2.x + rectangle2.width / 2;
        float f5 = rectangle2.y + rectangle2.height / 2;
        double d = Math.atan2(f5 - f3, f4 - f2);
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        float f6 = (float)(d3 * (double)f);
        float f7 = (float)(d2 * (double)f);
        float f8 = f6 / 2.0f;
        float f9 = f7 / 2.0f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2 + f9, f3 - f8);
        generalPath.lineTo(f2 + f8 * 0.6f, f3 + f9 * 0.6f);
        generalPath.lineTo(f2 - f9, f3 + f8);
        generalPath.lineTo((f4 -= (float)((int)(d3 * (double)rectangle2.width / 2.0))) - f6 * 1.2f - f9, (f5 -= (float)((int)(d2 * (double)rectangle2.height / 2.0))) - f7 * 1.2f + f8);
        generalPath.lineTo((float)((double)f4 + Math.cos(d + 2.356194490192345) * (double)f * 3.0), (float)((double)f5 + Math.sin(d + 2.356194490192345) * (double)f * 3.0));
        generalPath.lineTo(f4 + f6, f5 + f7);
        generalPath.lineTo((float)((double)f4 + Math.cos(d - 2.356194490192345) * (double)f * 3.0), (float)((double)f5 + Math.sin(d - 2.356194490192345) * (double)f * 3.0));
        generalPath.lineTo(f4 - f6 * 1.2f + f9, f5 - f7 * 1.2f - f8);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
    }

    protected void drawSquare(Graphics graphics, Square square, int n, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.squareToRect(square, null);
        graphics2D.translate(rectangle.x, rectangle.y);
        float f = (float)n / 2.0f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f);
        generalPath.lineTo((float)rectangle.width - f, f);
        generalPath.lineTo((float)rectangle.width - f, (float)rectangle.height - f);
        generalPath.lineTo(f, (float)rectangle.height - f);
        generalPath.closePath();
        if (PlatformUtils.isMacOSX()) {
            generalPath.transform(AffineTransform.getTranslateInstance(-0.5, -0.5));
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(n, 1, 2));
        graphics2D.draw(generalPath);
        graphics2D.translate(-rectangle.x, -rectangle.y);
    }

    private void callPaintHooks(Graphics graphics) {
        int n = this.paintHooks == null ? 0 : this.paintHooks.size();
        for (int i = 0; i < n; ++i) {
            PaintHook paintHook = (PaintHook)this.paintHooks.elementAt(i);
            paintHook.paint((Component)this, graphics);
        }
    }

    public Rectangle getBoardRect(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = this.getWidth() - insets.left - insets.right;
        rectangle.height = this.getHeight() - insets.top - insets.bottom;
        if (this.getCoordsDisplayStyle() == 2) {
            int n = rectangle.width / 30;
            int n2 = rectangle.height / 30;
            rectangle.x += n;
            rectangle.width -= n;
            rectangle.height -= n2;
        }
        rectangle.width -= rectangle.width % 8;
        rectangle.height -= rectangle.height % 8;
        return rectangle;
    }

    public Rectangle squareToRect(Square square, Rectangle rectangle) {
        return this.squareToRect(square.getFile(), square.getRank(), rectangle);
    }

    public Rectangle squareToRect(int n, int n2, Rectangle rectangle) {
        rectangle = this.getBoardRect(rectangle);
        rectangle.width /= 8;
        rectangle.height /= 8;
        if (this.isFlipped()) {
            rectangle.x += (7 - n) * rectangle.width;
            rectangle.y += n2 * rectangle.height;
        } else {
            rectangle.x += n * rectangle.width;
            rectangle.y += (7 - n2) * rectangle.height;
        }
        return rectangle;
    }

    private Rectangle getMovedPieceGraphicRect(Rectangle rectangle) {
        if (!this.isPieceFollowsCursor()) {
            throw new IllegalStateException("Not in pieceFollowsCursor mode");
        }
        if (this.movedPieceLoc == null) {
            throw new IllegalStateException("No piece is being moved");
        }
        rectangle = this.getBoardRect(rectangle);
        int n = rectangle.width / 8;
        int n2 = rectangle.height / 8;
        rectangle.x = this.movedPieceLoc.x - n / 2;
        rectangle.y = this.movedPieceLoc.y - n2 / 2;
        rectangle.width = n;
        rectangle.height = n2;
        return rectangle;
    }

    private Rectangle getTargetSquareRect(Rectangle rectangle) {
        if (!this.isHighlightMadeMoveSquares()) {
            throw new IllegalStateException("Not in highlightMadeMoveSquares mode");
        }
        if (this.movedPieceLoc == null) {
            throw new IllegalStateException("No piece is being moved");
        }
        rectangle = this.getBoardRect(rectangle);
        int n = rectangle.width / 8;
        int n2 = rectangle.height / 8;
        rectangle.x = this.movedPieceLoc.x - (this.movedPieceLoc.x - rectangle.x) % n;
        rectangle.y = this.movedPieceLoc.y - (this.movedPieceLoc.y - rectangle.y) % n2;
        if (this.movedPieceLoc.x < 0) {
            rectangle.x -= n;
        }
        if (this.movedPieceLoc.y < 0) {
            rectangle.y -= n2;
        }
        rectangle.width = n;
        rectangle.height = n2;
        return rectangle;
    }

    private Rectangle getMoveAreaRect(Rectangle rectangle) {
        if (this.movedPieceLoc == null) {
            throw new IllegalStateException("No piece is being moved");
        }
        if (this.isPieceFollowsCursor()) {
            if (this.isHighlightMadeMoveSquares()) {
                if (rectangle == null) {
                    rectangle = new Rectangle();
                }
                Rectangle rectangle2 = this.getMovedPieceGraphicRect(null);
                Rectangle rectangle3 = this.getTargetSquareRect(null);
                rectangle.setBounds(rectangle2.union(rectangle3));
                return rectangle;
            }
            return this.getMovedPieceGraphicRect(rectangle);
        }
        if (this.isHighlightMadeMoveSquares()) {
            return this.getTargetSquareRect(rectangle);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        rectangle.setBounds(0, 0, 0, 0);
        return rectangle;
    }

    public Square locationToSquare(int n, int n2) {
        Rectangle rectangle = this.getBoardRect(null);
        if ((n -= rectangle.x) < 0 || (n2 -= rectangle.y) < 0) {
            return null;
        }
        int n3 = rectangle.width / 8;
        int n4 = rectangle.height / 8;
        int n5 = n / n3;
        int n6 = 7 - n2 / n4;
        if (n5 > 7 || n6 < 0) {
            return null;
        }
        if (this.isFlipped()) {
            return Square.getInstance(7 - n5, 7 - n6);
        }
        return Square.getInstance(n5, n6);
    }

    public Square locationToSquare(Point point) {
        return this.locationToSquare(point.x, point.y);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (!this.isShowingModalDialog) {
            super.processEvent(aWTEvent);
        }
    }

    private boolean canBeMoved(Piece piece) {
        switch (this.getMoveInputMode()) {
            case 0: {
                return false;
            }
            case 1: {
                return piece.isWhite();
            }
            case 2: {
                return piece.isBlack();
            }
            case 3: {
                return true;
            }
            case 4: {
                Player player = this.getPosition().getCurrentPlayer();
                return player.isWhite() && piece.isWhite() || player.isBlack() && piece.isBlack();
            }
        }
        throw new IllegalStateException();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Square square;
        super.processMouseEvent(mouseEvent);
        if (!this.isEnabled() || !this.isEditable()) {
            return;
        }
        boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
        int n = mouseEvent.getID();
        int n2 = this.getMoveInputStyle();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        Rectangle rectangle = null;
        if (n == 505 && n2 == 2 && this.movedPieceSquare != null) {
            rectangle = this.getMoveAreaRect(rectangle);
            this.repaint(rectangle);
            this.squareToRect(this.movedPieceSquare, rectangle);
            this.movedPieceLoc.x = rectangle.x + rectangle.width / 2;
            this.movedPieceLoc.y = rectangle.y + rectangle.height / 2;
            this.repaint(this.getMoveAreaRect(rectangle));
        }
        if ((square = this.locationToSquare(n3, n4)) == null) {
            if (n == 502 && this.isMovingPiece()) {
                this.cancelMovingPiece();
            }
            return;
        }
        if (bl && (n == 501 || n == 502 && n2 == 1)) {
            if (this.movedPieceSquare == null) {
                if (n == 502) {
                    return;
                }
                this.movedPieceSquare = square;
                Piece piece = this.position.getPieceAt(this.movedPieceSquare);
                if (piece == null || !this.canBeMoved(piece)) {
                    this.movedPieceSquare = null;
                    this.movedPieceLoc = null;
                    return;
                }
                this.movedPieceLoc = new Point(n3, n4);
                rectangle = this.squareToRect(square, rectangle);
                this.repaint(rectangle);
                if (this.isPieceFollowsCursor()) {
                    rectangle = this.getMovedPieceGraphicRect(rectangle);
                    this.repaint(rectangle);
                }
                this.fireMoveProgressEvent(new MoveProgressEvent(this, 1));
            } else {
                if (!square.equals(this.movedPieceSquare)) {
                    Move move;
                    WildVariant wildVariant = this.position.getVariant();
                    Piece[] pieceArray = wildVariant.getPromotionTargets(this.position, this.movedPieceSquare, square);
                    if (pieceArray != null) {
                        Piece piece;
                        if (this.isManualPromote()) {
                            this.isShowingModalDialog = true;
                            piece = PieceChooser.showPieceChooser(this, n3, n4, pieceArray, this.getPiecePainter(), pieceArray[0]);
                            this.isShowingModalDialog = false;
                        } else {
                            piece = pieceArray[0];
                        }
                        move = wildVariant.createMove(this.position, this.movedPieceSquare, square, piece, null);
                    } else {
                        move = wildVariant.createMove(this.position, this.movedPieceSquare, square, null, null);
                    }
                    this.position.makeMove(move);
                } else {
                    rectangle = this.getMoveAreaRect(rectangle);
                    this.repaint(rectangle);
                    rectangle = this.squareToRect(this.movedPieceSquare, rectangle);
                    this.repaint(rectangle);
                }
                this.movedPieceSquare = null;
                this.movedPieceLoc = null;
                this.fireMoveProgressEvent(new MoveProgressEvent(this, 2));
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!this.isEnabled() || !this.isEditable()) {
            return;
        }
        int n = mouseEvent.getID();
        if (n == 506 && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        int n2 = this.getMoveInputStyle();
        if (this.movedPieceSquare == null) {
            return;
        }
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        Rectangle rectangle = null;
        if (n == 506 || n == 503 && n2 == 2) {
            rectangle = this.getMoveAreaRect(rectangle);
            this.repaint(rectangle);
            if (this.locationToSquare(n3, n4) == null && n2 == 2) {
                this.squareToRect(this.movedPieceSquare, rectangle);
                this.movedPieceLoc.x = rectangle.x + rectangle.width / 2;
                this.movedPieceLoc.y = rectangle.y + rectangle.height / 2;
            } else {
                this.movedPieceLoc.x = n3;
                this.movedPieceLoc.y = n4;
            }
            rectangle = this.getMoveAreaRect(rectangle);
            this.repaint(rectangle);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JBoard Test");
        jFrame.addWindowListener((WindowListener)new AppKiller());
        jFrame.getContentPane().setLayout(new BorderLayout());
        JBoard jBoard = new JBoard();
        jBoard.setBorder(new MatteBorder(30, 40, 50, 60, Color.red));
        jBoard.setMoveInputStyle(2);
        jBoard.setFlipped(true);
        jBoard.setCoordsDisplayStyle(1);
        jFrame.getContentPane().add((Component)jBoard, "Center");
        jFrame.setBounds(50, 50, 400, 400);
        jFrame.setVisible(true);
    }
}

