/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;

public class KrbException
extends Exception {
    private static final long serialVersionUID = -4993302876451928596L;
    private int returnCode;
    private KRBError error;

    public KrbException(String string) {
        super(string);
    }

    public KrbException(Throwable throwable) {
        super(throwable);
    }

    public KrbException(int n) {
        this.returnCode = n;
    }

    public KrbException(int n, String string) {
        this(string);
        this.returnCode = n;
    }

    public KrbException(KRBError kRBError) {
        this.returnCode = kRBError.getErrorCode();
        this.error = kRBError;
    }

    public KrbException(KRBError kRBError, String string) {
        this(string);
        this.returnCode = kRBError.getErrorCode();
        this.error = kRBError;
    }

    public KRBError getError() {
        return this.error;
    }

    public int returnCode() {
        return this.returnCode;
    }

    public String returnCodeSymbol() {
        return KrbException.returnCodeSymbol(this.returnCode);
    }

    public static String returnCodeSymbol(int n) {
        return "not yet implemented";
    }

    public String returnCodeMessage() {
        return Krb5.getErrorMessage(this.returnCode);
    }

    public static String errorMessage(int n) {
        return Krb5.getErrorMessage(n);
    }

    public String krbErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer("krb_error " + this.returnCode);
        String string = this.getMessage();
        if (string != null) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getMessage() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.returnCode();
        if (n != 0) {
            stringBuffer.append(this.returnCodeMessage());
            stringBuffer.append(" (").append(this.returnCode()).append(')');
        }
        if ((string = super.getMessage()) != null && string.length() != 0) {
            if (n != 0) {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        return "KrbException: " + this.getMessage();
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.returnCode;
        if (this.error != null) {
            n = 37 * n + this.error.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KrbException)) {
            return false;
        }
        KrbException krbException = (KrbException)object;
        if (this.returnCode != krbException.returnCode) {
            return false;
        }
        return this.error == null ? krbException.error == null : this.error.equals(krbException.error);
    }
}

