/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.HttpClientResponseHandler;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.http.request.run.HttpRequestNotifications;
import com.intellij.ws.http.request.run.HttpResponseCompositeProcessor;
import com.intellij.ws.http.request.run.HttpResponseConsoleProcessor;
import com.intellij.ws.http.request.run.HttpResponseProcessor;
import com.intellij.ws.http.request.run.HttpRunRequestInfo;
import com.intellij.ws.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.ws.http.request.run.console.HttpResponseConsole;
import com.intellij.ws.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.ws.http.request.run.console.HttpResponsePresentation;
import com.intellij.ws.http.request.run.console.HttpSingleResponseConsole;
import com.intellij.ws.http.request.run.test.HttpMultiResponseConsole;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientControllerImpl;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponse;
import com.intellij.ws.rest.client.RestClientResponseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunHttpRequestProfileState
implements RunProfileState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.RunHttpRequestProfileState");
    private static final int MAX_INPLACE_SIZE = 0x100000;
    private final Project myProject;
    private final HttpRequestExecutionConfig myConfig;
    private final SMTRunnerConsoleProperties myProperties;
    private final HttpRequestVariableSubstitutor mySubstitutor;

    public RunHttpRequestProfileState(@NotNull Project project, @NotNull HttpRequestExecutionConfig config, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (config == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myConfig = config;
        this.myProperties = properties;
        this.mySubstitutor = substitutor;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        List<HttpRequest> requests = this.myConfig.getRequests();
        boolean hasResponseHandler = requests.stream().anyMatch(request -> request.getResponseHandler() != null);
        HttpClientRequestProcessHandler processHandler = new HttpClientRequestProcessHandler(hasResponseHandler);
        ArrayList<HttpRunRequestInfo> infos = new ArrayList<HttpRunRequestInfo>();
        for (HttpRequest psiRequest : requests) {
            infos.add(HttpRunRequestInfo.create(psiRequest, this.mySubstitutor));
        }
        final HttpResponseConsole console = this.createConsole(processHandler, infos);
        FileDocumentManager.getInstance().saveAllDocuments();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) != 0) {
                    String message = exitCode == 1 ? RestClientBundle.message("rest.client.request.execute.cancel", new Object[0]) : RestClientBundle.message("rest.client.request.execute.cancel.post.process", new Object[0]);
                    console.setErrorResponse(null, HttpResponsePresentation.createErrorResponse(message));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ws/http/request/run/RunHttpRequestProfileState$1", "processTerminated"));
            }
        });
        this.executeHttpRequest(this.myProject, infos.iterator(), processHandler, console, infos.size() == 1);
        return new DefaultExecutionResult((ExecutionConsole)console.getConsole(), (ProcessHandler)processHandler);
    }

    @NotNull
    private HttpResponseConsole createConsole(@NotNull HttpClientRequestProcessHandler processHandler, @NotNull List<HttpRunRequestInfo> requests) throws ExecutionException {
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        if (requests.isEmpty()) {
            throw new ExecutionException("No Requests to Execute");
        }
        if (requests.size() == 1) {
            HttpRunRequestInfo info = requests.get(0);
            RestClientRequest request = info.getRequest();
            String target = request.httpMethod + " " + request.toString() + "\n\n";
            boolean withPostProcessor = info.getResponseHandler() != null;
            HttpSingleResponseConsole httpSingleResponseConsole = new HttpSingleResponseConsole(this.myProject, target, this.myProperties, processHandler, withPostProcessor);
            if (httpSingleResponseConsole == null) {
                RunHttpRequestProfileState.$$$reportNull$$$0(7);
            }
            return httpSingleResponseConsole;
        }
        HttpMultiResponseConsole httpMultiResponseConsole = new HttpMultiResponseConsole(this.myProject, this.myProperties, processHandler);
        if (httpMultiResponseConsole == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(8);
        }
        return httpMultiResponseConsole;
    }

    private void executeHttpRequest(@NotNull Project project, @NotNull Iterator<HttpRunRequestInfo> requests, final @NotNull HttpClientRequestProcessHandler processHandler, final @NotNull HttpResponseConsole console, final boolean showResponseInplace) {
        HttpClientResponseHandler handler;
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(9);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(11);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(12);
        }
        if (!requests.hasNext()) {
            return;
        }
        final HttpRunRequestInfo info = requests.next();
        RestClientRequest request = info.getRequest();
        final String id = RunHttpRequestProfileState.toRequestId(request);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing: " + id);
        }
        int size = (handler = info.getResponseHandler()) != null ? 2 : 1;
        final Runnable onRequestFinished = this.createOnFinished(project, id, console, processHandler, requests, showResponseInplace);
        RestClientControllerImpl controller = new RestClientControllerImpl(project){

            @Override
            protected void addToHistory(final @NotNull Project project, @NotNull RestClientRequest request, final @Nullable RestClientResponse response) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (request == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (RunHttpRequestProfileState.isInterrupted(processHandler)) {
                    return;
                }
                HttpResponseProcessor processor = RunHttpRequestProfileState.createProcessor(id, console, info.getProcessor());
                HttpRequestHistoryManager.getInstance(project).addToHistory(request, response, processor);
                if (response != null && handler != null) {
                    EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
                    processHandler.setPostProcessorIndicator((ProgressIndicator)progressIndicator);
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project, RestClientBundle.message("rest.client.request.response.handler.execution", new Object[0]), false){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            try {
                                HttpResponseOutputAdapter handlerPrinter = console.getResponseHandlerPrinter();
                                HttpResponseOutputAdapter testPrinter = console.getResponseHandlerTestPrinter();
                                handler.handle(project, response, handlerPrinter, testPrinter, console instanceof HttpSingleResponseConsole);
                            }
                            catch (ExecutionException e) {
                                String title = RestClientBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]);
                                HttpRequestNotifications.showWarningBalloon(this.myProject, title, e.getMessage());
                            }
                            finally {
                                onRequestFinished.run();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/http/request/run/RunHttpRequestProfileState$2$1", "run"));
                        }
                    }, (ProgressIndicator)progressIndicator);
                } else {
                    onRequestFinished.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$2";
                objectArray[2] = "addToHistory";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        console.onRequestStart(id, size);
        controller.onGoButtonClick(request, false, new RestClientResponseListener(){

            @Override
            public void onResponse(@Nullable String header, @NotNull String response, @Nullable String mimeType, @NotNull String status) {
                if (response == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (status == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!RunHttpRequestProfileState.isInterrupted(processHandler)) {
                    FileType fileType = RestClientFileUtil.findFileType(mimeType);
                    boolean inplace = response.length() < 0x100000 && showResponseInplace;
                    console.setResponse(id, HttpResponsePresentation.createResponse(header, response, status, inplace), fileType);
                }
            }

            @Override
            public void onErrorResponse(String response) {
                if (!RunHttpRequestProfileState.isInterrupted(processHandler)) {
                    console.setErrorResponse(id, HttpResponsePresentation.createErrorResponse(StringUtil.notNullize((String)response)));
                }
            }

            @Override
            public void onSetCookies(Collection<Cookie> cookies) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "response";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "status";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState$3";
                objectArray[2] = "onResponse";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new RestClientRequestProcessor[0]);
    }

    private static boolean isInterrupted(@NotNull ProcessHandler handler) {
        Integer code;
        if (handler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(13);
        }
        return (code = handler.getExitCode()) != null && code != 0;
    }

    @NotNull
    private static String toRequestId(@NotNull RestClientRequest request) {
        if (request == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(14);
        }
        String string = request.getURL();
        if (string == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static HttpResponseProcessor createProcessor(@NotNull String requestId, @NotNull HttpResponseConsole console, @NotNull HttpResponseProcessor processor) {
        if (requestId == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(16);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(18);
        }
        HttpResponseCompositeProcessor httpResponseCompositeProcessor = new HttpResponseCompositeProcessor(processor, new HttpResponseConsoleProcessor(requestId, console));
        if (httpResponseCompositeProcessor == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(19);
        }
        return httpResponseCompositeProcessor;
    }

    @NotNull
    private Runnable createOnFinished(@NotNull Project project, @NotNull String url, @NotNull HttpResponseConsole console, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull Iterator<HttpRunRequestInfo> requests, boolean showResponseInplace) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(20);
        }
        if (url == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(21);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(22);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(23);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(24);
        }
        Runnable runnable = () -> {
            if (console == null) {
                RunHttpRequestProfileState.$$$reportNull$$$0(26);
            }
            if (url == null) {
                RunHttpRequestProfileState.$$$reportNull$$$0(27);
            }
            if (requests == null) {
                RunHttpRequestProfileState.$$$reportNull$$$0(28);
            }
            if (project == null) {
                RunHttpRequestProfileState.$$$reportNull$$$0(29);
            }
            if (processHandler == null) {
                RunHttpRequestProfileState.$$$reportNull$$$0(30);
            }
            console.onRequestEnd(url);
            if (requests.hasNext()) {
                this.executeHttpRequest(project, requests, processHandler, console, showResponseInplace);
            } else {
                processHandler.onRunFinished();
            }
        };
        if (runnable == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(25);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: 
            case 11: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 10: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
                break;
            }
            case 12: 
            case 17: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toRequestId";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createOnFinished";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 25: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeHttpRequest";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInterrupted";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toRequestId";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createOnFinished";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOnFinished$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

