/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipFile;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class OpenCloseFileTransformer
implements ClassFileTransformer {
    private final HashMap<String, ClassTransformation> myClassTransformations = new HashMap();

    public OpenCloseFileTransformer() {
        for (ClassTransformation ct : new ArrayList<ClassTransformation>(){
            {
                this.add(OpenCloseFileTransformer.create(FileOutputStream.class, "(Ljava/io/File;Z)V"));
                this.add(OpenCloseFileTransformer.create(FileInputStream.class, "(Ljava/io/File;)V"));
                this.add(OpenCloseFileTransformer.create(RandomAccessFile.class, "(Ljava/io/File;Ljava/lang/String;)V"));
                this.add(OpenCloseFileTransformer.create(ZipFile.class, "(Ljava/io/File;I)V"));
            }
        }) {
            this.myClassTransformations.put(ct.myClass.getName().replace('.', '/'), ct);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        final ClassTransformation ct = this.myClassTransformations.get(className);
        if (ct == null) {
            return classfileBuffer;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(1);
        cr.accept(new ClassVisitor(458752, cw){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor base = super.visitMethod(access, name, desc, signature, exceptions);
                MethodTransformer methodTransformer = (MethodTransformer)ct.methodTransformers.get(name + desc);
                if (methodTransformer == null) {
                    return base;
                }
                return methodTransformer.createVisitor(base);
            }
        }, 4);
        System.out.println("Injected open/close file listeners into " + className);
        return cw.toByteArray();
    }

    public Class<?>[] classesToTransform() {
        LinkedList<Class> classes = new LinkedList<Class>();
        for (ClassTransformation t : this.myClassTransformations.values()) {
            classes.add(t.myClass);
        }
        return classes.toArray(new Class[0]);
    }

    private static ClassTransformation create(Class<?> c, String ctor) {
        return new ClassTransformation((Class)c, new MethodTransformer[]{new MethodTransformer.CtorTransformer(ctor), new MethodTransformer.CloseTransformer("close", "()V")});
    }

    private static abstract class MethodTransformer {
        final String name;
        final String signature;

        MethodTransformer(String name, String signature) {
            this.name = name;
            this.signature = signature;
        }

        abstract void generate(Generator var1);

        MethodVisitor createVisitor(MethodVisitor base) {
            final Generator cg = new Generator(base);
            return new MethodVisitor(458752, base){

                @Override
                public void visitInsn(int opcode) {
                    switch (opcode) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            MethodTransformer.this.generate(cg);
                            break;
                        }
                    }
                    super.visitInsn(opcode);
                }
            };
        }

        private static class Generator
        extends MethodVisitor {
            Generator(MethodVisitor mv) {
                super(458752, mv);
            }

            private void createArray(String type, int size) {
                this.putConst(size);
                this.visitTypeInsn(189, type);
            }

            private void putConst(int i) {
                if (i <= 5) {
                    this.visitInsn(3 + i);
                } else {
                    this.visitLdcInsn(i);
                }
            }

            private void pushConst(Object o) {
                if (o.getClass() == Class.class) {
                    o = Type.getType((Class)o);
                }
                this.visitLdcInsn(o);
            }

            void call(String userClassName, String userMethodName, Class<?>[] argTypes) {
                int i;
                this.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
                this.pushConst(userClassName);
                this.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                this.pushConst(userMethodName);
                this.createArray("java/lang/Class", argTypes.length);
                for (i = 0; i < argTypes.length; ++i) {
                    this.visitInsn(89);
                    this.putConst(i);
                    this.pushConst(argTypes[i]);
                    this.visitInsn(83);
                }
                this.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
                this.visitInsn(1);
                this.createArray("java/lang/Object", argTypes.length);
                for (i = 0; i < argTypes.length; ++i) {
                    this.visitInsn(89);
                    this.putConst(i);
                    this.visitIntInsn(25, i);
                    this.visitInsn(83);
                }
                this.visitMethodInsn(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
            }
        }

        private static class CloseTransformer
        extends MethodTransformer {
            CloseTransformer(String methodName, String desc) {
                super(methodName, desc);
            }

            @Override
            protected void generate(Generator g) {
                g.call(TestDiscoveryProjectData.class.getName(), "closeFile", new Class[]{Object.class});
            }
        }

        private static class CtorTransformer
        extends MethodTransformer {
            CtorTransformer(String constructorDesc) {
                super("<init>", constructorDesc);
            }

            @Override
            protected void generate(Generator g) {
                g.call(TestDiscoveryProjectData.class.getName(), "openFile", new Class[]{Object.class, File.class});
            }
        }
    }

    private static final class ClassTransformation {
        private final Map<String, MethodTransformer> methodTransformers = new HashMap<String, MethodTransformer>();
        private final Class<?> myClass;

        private ClassTransformation(Class<?> c, MethodTransformer ... methodTransformers) {
            this.myClass = c;
            for (MethodTransformer s : methodTransformers) {
                this.methodTransformers.put(s.name + s.signature, s);
            }
        }
    }
}

