/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.netty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.NettyInvocationBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpConstants;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

class NettyWebTargetCopy
implements WebTarget {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    protected final ChannelProvider channelProvider;
    protected final String host;
    protected final ImmutableList<String> path;
    protected final ImmutableMap<String, String> queryParams;
    protected final ImmutableMap<String, Set<String>> queryParamsSet;
    protected static final String PATH_SEPARATOR = "/";

    NettyWebTargetCopy(ChannelProvider channelProvider, String host) {
        this(channelProvider, host, (ImmutableList<String>)ImmutableList.of(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, Set<String>>)ImmutableMap.of());
    }

    protected NettyWebTargetCopy(ChannelProvider channelProvider, String host, ImmutableList<String> path, ImmutableMap<String, String> queryParams, ImmutableMap<String, Set<String>> queryParamsSet) {
        this.channelProvider = channelProvider;
        this.host = host;
        this.path = path;
        this.queryParams = queryParams;
        this.queryParamsSet = queryParamsSet;
    }

    protected NettyWebTargetCopy createNewInstance(ChannelProvider channelProvider, String host, ImmutableList<String> path, ImmutableMap<String, String> queryParams, ImmutableMap<String, Set<String>> queryParamsSet) {
        return new NettyWebTargetCopy(channelProvider, host, path, queryParams, queryParamsSet);
    }

    protected InvocationBuilder createInvocationBuilder(String resource) {
        return new NettyInvocationBuilder(this.channelProvider, resource);
    }

    public NettyWebTargetCopy path(String ... components) {
        ImmutableList.Builder newPath = ImmutableList.builder().addAll(this.path);
        for (String component : components) {
            newPath.addAll(Arrays.asList(StringUtils.split((String)component, (String)PATH_SEPARATOR)));
        }
        return this.createNewInstance(this.channelProvider, this.host, (ImmutableList<String>)newPath.build(), this.queryParams, this.queryParamsSet);
    }

    public InvocationBuilder request() {
        String resource = PATH_SEPARATOR + StringUtils.join(this.path, (String)PATH_SEPARATOR);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry entry : this.queryParams.entrySet()) {
            params.add((String)entry.getKey() + "=" + NettyWebTargetCopy.encodeComponent((String)entry.getValue(), HttpConstants.DEFAULT_CHARSET));
        }
        for (Map.Entry entry : this.queryParamsSet.entrySet()) {
            for (String entryValueValue : (Set)entry.getValue()) {
                params.add((String)entry.getKey() + "=" + NettyWebTargetCopy.encodeComponent(entryValueValue, HttpConstants.DEFAULT_CHARSET));
            }
        }
        if (!params.isEmpty()) {
            resource = resource + "?" + StringUtils.join(params, (String)"&");
        }
        return this.createInvocationBuilder(resource).header("Host", this.host);
    }

    private static String encodeComponent(String s, Charset charset) {
        try {
            return URLEncoder.encode(s, charset.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }

    public NettyWebTargetCopy resolveTemplate(String name, Object value) {
        ImmutableList.Builder newPath = ImmutableList.builder();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add((Object)component);
        }
        return this.createNewInstance(this.channelProvider, this.host, (ImmutableList<String>)newPath.build(), this.queryParams, this.queryParamsSet);
    }

    public NettyWebTargetCopy queryParam(String name, Object value) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.queryParams);
        if (value != null) {
            builder.put((Object)name, (Object)value.toString());
        }
        return this.createNewInstance(this.channelProvider, this.host, this.path, (ImmutableMap<String, String>)builder.build(), this.queryParamsSet);
    }

    public NettyWebTargetCopy queryParamsSet(String name, Set<?> values) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.queryParamsSet);
        if (values != null) {
            ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
            for (Object value : values) {
                valueBuilder.add((Object)value.toString());
            }
            builder.put((Object)name, (Object)valueBuilder.build());
        }
        return this.createNewInstance(this.channelProvider, this.host, this.path, this.queryParams, (ImmutableMap<String, Set<String>>)builder.build());
    }

    public NettyWebTargetCopy queryParamsJsonMap(String name, Map<String, String> values) {
        if (values != null && !values.isEmpty()) {
            try {
                return this.queryParam(name, MAPPER.writeValueAsString(values));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyWebTargetCopy webTarget = (NettyWebTargetCopy)o;
        if (this.channelProvider != null ? !this.channelProvider.equals(webTarget.channelProvider) : webTarget.channelProvider != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(webTarget.path) : webTarget.path != null) {
            return false;
        }
        if (this.queryParams != null ? !this.queryParams.equals(webTarget.queryParams) : webTarget.queryParams != null) {
            return false;
        }
        return !(this.queryParamsSet != null ? !this.queryParamsSet.equals(webTarget.queryParamsSet) : webTarget.queryParamsSet != null);
    }

    public int hashCode() {
        int result = this.channelProvider != null ? this.channelProvider.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.queryParams != null ? this.queryParams.hashCode() : 0);
        result = 31 * result + (this.queryParamsSet != null ? this.queryParamsSet.hashCode() : 0);
        return result;
    }
}

