/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.util.containers.ComparatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterError
extends JSLinterErrorBase {
    private final int myLine;
    private final int myColumn;
    private final HighlightSeverity mySeverity;

    public JSLinterError(int oneBasedLineNumber, int oneBasedColumnNumber, @NotNull String description, @Nullable String code) {
        if (description == null) {
            JSLinterError.$$$reportNull$$$0(0);
        }
        this(oneBasedLineNumber, oneBasedColumnNumber, description, code, null);
    }

    public JSLinterError(int oneBasedLineNumber, int oneBasedColumnNumber, @NotNull String description, @Nullable String code, @Nullable HighlightSeverity severity) {
        if (description == null) {
            JSLinterError.$$$reportNull$$$0(1);
        }
        super(description, code);
        this.myLine = oneBasedLineNumber == 0 ? 0 : oneBasedLineNumber - 1;
        this.myColumn = oneBasedColumnNumber == 0 ? 0 : oneBasedColumnNumber - 1;
        this.mySeverity = severity;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    @Nullable
    public HighlightSeverity getLinterSeverity() {
        return this.mySeverity;
    }

    public int compareLogicalPositionTo(@NotNull JSLinterError other) {
        int rowDiff;
        if (other == null) {
            JSLinterError.$$$reportNull$$$0(2);
        }
        if ((rowDiff = this.getLine() - other.getLine()) != 0) {
            return rowDiff;
        }
        return this.getColumn() - other.getColumn();
    }

    public int compareFully(@NotNull JSLinterError other) {
        int logicalPositionCmp;
        if (other == null) {
            JSLinterError.$$$reportNull$$$0(3);
        }
        if ((logicalPositionCmp = this.compareLogicalPositionTo(other)) != 0) {
            return logicalPositionCmp;
        }
        return this.myDescription.compareTo(other.myDescription);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLinterError error = (JSLinterError)o;
        return this.myLine == error.myLine && this.myColumn == error.myColumn && ComparatorUtil.equalsNullable((Object)this.mySeverity, (Object)error.mySeverity) && ComparatorUtil.equalsNullable((Object)this.myCode, (Object)error.myCode) && this.myDescription.equals(error.myDescription);
    }

    public int hashCode() {
        int result2 = this.myLine;
        result2 = 31 * result2 + this.myColumn;
        result2 = 31 * result2 + (this.mySeverity != null ? this.mySeverity.hashCode() : 0);
        result2 = 31 * result2 + (this.myCode != null ? this.myCode.hashCode() : 0);
        result2 = 31 * result2 + this.myDescription.hashCode();
        return result2;
    }

    public String toString() {
        return String.format("({%s},{%s}){%s}: {%s}", this.myLine, this.myColumn, this.myCode != null ? this.myCode : "", this.myDescription);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterError";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareLogicalPositionTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareFully";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

