/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaScriptTypeHelper
extends JSTypeHelper {
    private static final JavaScriptTypeHelper ourTypeHelper = new JavaScriptTypeHelper();

    private JavaScriptTypeHelper() {
    }

    @NotNull
    public static JavaScriptTypeHelper getInstance() {
        JavaScriptTypeHelper javaScriptTypeHelper = ourTypeHelper;
        if (javaScriptTypeHelper == null) {
            JavaScriptTypeHelper.$$$reportNull$$$0(0);
        }
        return javaScriptTypeHelper;
    }

    @Override
    @Nullable
    public JSType getTypeForIndexing(@Nullable JSExpression expression, @NotNull PsiElement context) {
        if (context == null) {
            JavaScriptTypeHelper.$$$reportNull$$$0(1);
        }
        if (expression instanceof JSNewExpression) {
            JSAnyType innerType;
            JSExpression methodExpression = ((JSNewExpression)expression).getMethodExpression();
            JSAnyType jSAnyType = innerType = methodExpression != null ? this.getTypeForIndexing(methodExpression, context) : JSAnyType.get((PsiElement)expression, false);
            if (innerType != null && !(innerType instanceof JSAnyType)) {
                return new JSApplyNewType(innerType, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true, false));
            }
        } else if (expression instanceof JSCallExpression) {
            JSAnyType innerType;
            JSRequireCallExpressionType requireCallType = CommonJSUtil.getTypeIfRequireCall((JSCallExpression)expression);
            if (requireCallType != null) {
                return requireCallType;
            }
            JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
            JSAnyType jSAnyType = innerType = methodExpression != null ? this.getTypeForIndexing(methodExpression, context) : JSAnyType.get((PsiElement)expression, false);
            if (innerType != null && !(innerType instanceof JSAnyType)) {
                return new JSApplyCallType(innerType, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true, false));
            }
        } else if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null) {
            JSType predefinedType = JSSymbolUtil.getPredefinedType((JSReferenceExpression)expression);
            if (predefinedType != null) {
                return predefinedType;
            }
            String referenceName = ((JSReferenceExpression)expression).getReferenceName();
            if (referenceName != null) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true, false);
                return new JSReferenceType(referenceName, typeSource);
            }
        }
        return JSSymbolUtil.evaluateTypeLocally(expression, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JavaScriptTypeHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JavaScriptTypeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForIndexing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

