/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeIdCache;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypesAssignableError;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeBaseImpl
implements JSType {
    public static final Key<Boolean> CALL_ENV_KEY = Key.create((String)"js.type.is.call.env");
    private static final JSType.LocalTypeKey RECORD_TYPE_CACHE = JSType.createLocalTypeKey((String)"js.record.type.cache.base");
    private static boolean ASSERT_ON_RECORD_TYPE_USAGE = false;
    private static final Key<?>[] IDS = new Key[]{CALL_ENV_KEY, JSTypeComparingCache.SUBTYPING_CONTEXT, JSGenericTypesEvaluator.ourGenericArgumentsMapKey, JSGenericTypesEvaluator.ourHadContravariantGenerics, JSRecursiveTypeUtil.ASSIGNABLE_KEY, JSTypeComparingContextService.NULL_CHECKS};
    @Nullable
    private volatile JSResolvedTypeIdImpl myResolvedKey;
    @NotNull
    private final JSTypeSource mySource;

    @NotNull
    public static JSType getSelfNoTransformationType() {
        JSType jSType = Holder.SELF_NO_TRANSFORMATION;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(0);
        }
        return jSType;
    }

    public static void assertOnRecordTypeUsage(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(1);
        }
        ASSERT_ON_RECORD_TYPE_USAGE = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ASSERT_ON_RECORD_TYPE_USAGE = false;
            }
        });
    }

    @Contract(value="!null->!null")
    public static ProcessingContext copyProcessingContextWithoutComparingCache(@Nullable ProcessingContext context) {
        if (context == null) {
            return null;
        }
        ProcessingContext newContext = new ProcessingContext();
        for (Key<?> id : IDS) {
            Object value = context.get(id);
            if (value == null) continue;
            newContext.put(id, value);
        }
        return newContext;
    }

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(2);
        }
        this.mySource = source;
    }

    @NotNull
    public final JSType getLocalCachedType(@NotNull Supplier<? extends JSType> factory, @NotNull JSType.LocalTypeKey cacheKey) {
        JSResolvedTypeIdImpl id;
        JSType value;
        if (factory == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(3);
        }
        if (cacheKey == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(4);
        }
        JSTypeBaseImpl jSTypeBaseImpl = (value = (id = this.getResolvedTypeId()).getLocalCachedValue(cacheKey, factory)) == null ? this : value;
        if (jSTypeBaseImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(5);
        }
        return jSTypeBaseImpl;
    }

    @NotNull
    public final String getTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getResolvedTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public final JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(8);
        }
        return jSTypeSource;
    }

    public final boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        boolean result2 = this.isDirectlyAssignableTypeWithCache(elementType, processingContext);
        if (processingContext != null) {
            JSTypesAssignableError.updateAssignableChain(this, elementType, result2, processingContext);
        }
        return result2;
    }

    private boolean isDirectlyAssignableTypeWithCache(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            return true;
        }
        if (this.isDirectAssignableTypeSimple(elementType, processingContext)) {
            return true;
        }
        ProgressManager.checkCanceled();
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        JSType expandThis = TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(this));
        JSType expandRType = TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(elementType));
        if (this != expandThis || elementType != expandRType) {
            return expandThis.isDirectlyAssignableType(expandRType, processingContext);
        }
        JSResolvedTypeIdImpl thisId = this.getResolvedTypeId();
        JSResolvedTypeId rTypeId = elementType.getResolvedTypeId();
        ProcessingContext finalProcessingContext = processingContext;
        JSType finalElementType = elementType;
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(thisId, rTypeId, JSRecursiveTypeUtil.ASSIGNABLE_KEY, processingContext, (Getter<Boolean>)((Getter)() -> {
            JSTypeComparingCache cache = (JSTypeComparingCache)finalProcessingContext.get(JSTypeComparingContextService.TYPE_COMPARATOR);
            if (cache != null) {
                JSTypeCastUtil.AssignableResult assignableResult = cache.areAssignableTypes(this, finalElementType, finalProcessingContext);
                if (assignableResult.isStrict()) {
                    this.checkCachedValue(finalElementType, finalProcessingContext, assignableResult);
                    return assignableResult.isAssignable();
                }
                if (assignableResult != JSTypeCastUtil.AssignableResult.NO_CACHE) {
                    boolean result2 = this.calculateAssignabilityWithoutCache(finalElementType, finalProcessingContext);
                    cache.putAssignableTypes(this, finalElementType, finalProcessingContext, JSTypeCastUtil.toStrictAssignable(result2));
                    return result2;
                }
            }
            return this.calculateAssignabilityWithoutCache(finalElementType, finalProcessingContext);
        }));
    }

    private boolean isDirectAssignableTypeSimple(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(9);
        }
        if (this.isTypeScript() && elementType == JSUnknownType.TS_INSTANCE) {
            return this instanceof JSAnyType;
        }
        return this.isEquivalentTo(elementType, processingContext, !this.isEcma()) || this.checkAlwaysAssignableType(elementType, processingContext);
    }

    protected boolean checkAlwaysAssignableType(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(10);
        }
        return JSTypeCastUtil.isAlwaysAssignableType(elementType, this.isJavaScript() && elementType.isJavaScript(), processingContext, null);
    }

    private boolean calculateAssignabilityWithoutCache(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSFreshObjectLiteralType freshType;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(11);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(12);
        }
        JSFreshObjectLiteralType jSFreshObjectLiteralType = freshType = elementType instanceof JSFreshObjectLiteralType ? (JSFreshObjectLiteralType)elementType : null;
        if (freshType != null) {
            elementType = ((JSFreshObjectLiteralType)elementType).removeFreshness();
        }
        return this.isDirectlyAssignableTypeImpl(elementType, processingContext) && (!this.isTypeScript() || freshType == null || JSTypeCastUtil.compareByExcessProperties(this, freshType));
    }

    private void checkCachedValue(@NotNull JSType elementType, @NotNull ProcessingContext processingContext, @NotNull JSTypeCastUtil.AssignableResult fromCache) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(13);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(14);
        }
        if (fromCache == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(15);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        ProcessingContext newContext = JSTypeBaseImpl.copyProcessingContextWithoutComparingCache(processingContext);
        boolean isAssignable = this.isDirectlyAssignableTypeImpl(elementType, newContext);
        if (fromCache.isAssignable() != isAssignable) {
            String message = String.format("checkCachedValue failed. This: %s;\nElement: %s;\nFrom cache: %s;\nIsAssignable:%s", new Object[]{this.getTypeText(), elementType.getTypeText(), fromCache, isAssignable});
            Logger.getInstance(this.getClass()).error(message);
        }
    }

    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(16);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(17);
        }
        return this.isDirectlyAssignableTypeCommon(elementType, processingContext).isAssignable();
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(18);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(19);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext);
        if (assignableResult == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(20);
        }
        return assignableResult;
    }

    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeBaseImpl((JSType)this);
    }

    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
    }

    @Nullable
    public final PsiFile getScope() {
        return this.mySource.getScope();
    }

    @NotNull
    protected final JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = null;
        switch (this.getSource().getLanguage()) {
            case TS: {
                language = JavaScriptSupportLoader.TYPESCRIPT;
                break;
            }
            case AS: {
                language = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                break;
            }
            case JS: {
                language = JavascriptLanguage.INSTANCE;
            }
        }
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage(language).getTypeHelper();
        if (jSTypeHelper == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(21);
        }
        return jSTypeHelper;
    }

    @Deprecated
    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        if (transformation instanceof JSRecursiveTypeTransformer) {
            JSType jSType = this.transformTypeHierarchy((JSRecursiveTypeTransformer)transformation);
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(23);
            }
            return jSType;
        }
        JSType jSType = this.transformTypeOrCopyWithTransformation(transformation);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull JSRecursiveTypeTransformer transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(25);
        }
        JSType jSType = transformation.transformRecursive((JSType)this, () -> {
            if (transformation == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(55);
            }
            return this.transformTypeOrCopyWithTransformation((Function<JSType, JSType>)transformation);
        });
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(26);
        }
        return jSType;
    }

    @NotNull
    private JSType transformTypeOrCopyWithTransformation(@NotNull Function<JSType, JSType> transformation) {
        JSType transformedType;
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(27);
        }
        if (this != (transformedType = (JSType)transformation.fun((Object)this))) {
            if (transformedType == JSTypeBaseImpl.getSelfNoTransformationType()) {
                JSTypeBaseImpl jSTypeBaseImpl = this;
                if (jSTypeBaseImpl == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(28);
                }
                return jSTypeBaseImpl;
            }
            this.checkUselessCopy(transformation, transformedType);
            JSType jSType = transformedType;
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        JSType result2 = this.copyTypeHierarchy(transformation);
        this.checkUselessCopy(transformation, result2);
        JSType jSType = result2;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    private void checkUselessCopy(@NotNull Function<JSType, JSType> transformation, @NotNull JSType result2) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(32);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        if (transformation instanceof JSRecursiveTypeTransformer && result2.getSource() == this.getSource() && result2 != this && result2.getResolvedTypeId().equals(this.getResolvedTypeId())) {
            Logger.getInstance(this.getClass()).error("Useless type copy " + this.getTypeText() + ". \nTypes must be the same if there are no changes in nested types.");
        }
    }

    private void checkSymmetrical(@NotNull JSType rType, @Nullable ProcessingContext context, boolean allowResolve) {
        if (rType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(33);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        if (!((JSTypeBaseImpl)rType).isEquivalentToWithSameClass(this, context, allowResolve)) {
            Logger.getInstance(this.getClass()).error("isEquivalentTo must be symmetrical relation: " + this.getTypeText() + ", " + rType.getTypeText());
        }
    }

    @NotNull
    protected abstract JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

    @NotNull
    public JSType substitute() {
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(34);
        }
        return jSTypeBaseImpl;
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return this.isEquivalentTo(type, processingContext, true);
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        Class<?> typeClass;
        if (this == type) {
            return true;
        }
        if (type == null) {
            return false;
        }
        Class<?> thisClass = this.getClass();
        if (!thisClass.equals(typeClass = type.getClass())) {
            return false;
        }
        ProgressManager.checkCanceled();
        if (this.isEquivalentToWithSameClass(type, processingContext, allowResolve)) {
            this.checkSymmetrical(type, processingContext, allowResolve);
            return true;
        }
        return false;
    }

    @NotNull
    public final JSType copyWithStrict(boolean strict) {
        JSTypeSource source = this.getSource();
        if (source.isStrict() == strict) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(35);
            }
            return jSTypeBaseImpl;
        }
        JSType jSType = this.copyWithNewSource(JSTypeSourceFactory.copyTypeSource(source, strict));
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(36);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyWithNewSource(@NotNull JSTypeSource var1);

    protected abstract boolean isEquivalentToWithSameClass(@NotNull JSType var1, @Nullable ProcessingContext var2, boolean var3);

    @NotNull
    public final JSRecordType asRecordType() {
        if (ASSERT_ON_RECORD_TYPE_USAGE) {
            throw new AssertionError((Object)"Record type must be not used");
        }
        ProgressManager.checkCanceled();
        JSRecordType value = this.useCacheForRecordType() ? this.getLocalCachedType(this::asRecordTypeNoCache, RECORD_TYPE_CACHE) : this.asRecordTypeNoCache();
        JSRecordType jSRecordType = value instanceof JSRecordType ? value : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(37);
        }
        return jSRecordType;
    }

    protected boolean useCacheForRecordType() {
        return false;
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        if (this.isEcma()) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(38);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = JSTypeComparingContextService.buildRecordType(this);
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(39);
        }
        return jSRecordType;
    }

    @Contract(value="!null,_ -> !null", pure=true)
    public static JSType replaceEmptySourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(40);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, newSource, (Condition<? super JSTypeSource>)((Condition)oldSource -> oldSource == JSTypeSource.EMPTY));
    }

    @Deprecated
    public static JSType replaceSourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(41);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, newSource, (Condition<? super JSTypeSource>)((Condition)oldSource -> {
            if (newSource == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(54);
            }
            return oldSource != newSource;
        }));
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithLanguageRecursive(@Nullable JSType type, @NotNull JSTypeSource.SourceLanguage sourceLanguage) {
        if (sourceLanguage == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(42);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, (Function<? super JSTypeBaseImpl, ? extends JSType>)((Function)currentType -> {
            if (sourceLanguage == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(53);
            }
            if (currentType.getSource().getLanguage() == sourceLanguage) {
                return currentType;
            }
            return currentType.copyWithNewSource(JSTypeSourceFactory.copyTypeSource(currentType.getSource(), sourceLanguage));
        }));
    }

    private static JSType replaceSourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource, @NotNull Condition<? super JSTypeSource> replaceCondition) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(43);
        }
        if (replaceCondition == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(44);
        }
        if (type == null) {
            return null;
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, (Function<? super JSTypeBaseImpl, ? extends JSType>)((Function)currentType -> {
            if (replaceCondition == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(51);
            }
            if (newSource == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(52);
            }
            if (!replaceCondition.value((Object)currentType.getSource())) {
                return currentType;
            }
            return currentType.copyWithNewSource(newSource);
        }));
    }

    @Contract(value="!null, _ -> !null")
    public static JSType replaceSourceRecursive(@Nullable JSType type, final @NotNull Function<? super JSTypeBaseImpl, ? extends JSType> createNewSource) {
        if (createNewSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(45);
        }
        if (type == null) {
            return null;
        }
        Function<JSType, JSType> function = new Function<JSType, JSType>(){

            public JSType fun(JSType currentType) {
                if (currentType instanceof JSTypeBaseImpl) {
                    JSType elementResult = (JSType)createNewSource.fun((Object)((JSTypeBaseImpl)currentType));
                    if (elementResult == currentType) {
                        return elementResult;
                    }
                    return elementResult.transformTypeHierarchy((Function)this);
                }
                assert (false);
                return currentType;
            }
        };
        return type.transformTypeHierarchy((Function)function);
    }

    protected abstract int resolvedHashCodeImpl();

    protected boolean resolvedEquals(@Nullable JSType rType) {
        return this.isEquivalentTo(rType, null, true);
    }

    protected final int getSourceHashCode() {
        PsiElement element = this.getSource().getSourceElement();
        return element != null && element.isValid() ? element.hashCode() : this.hashCode();
    }

    public final int resolvedHashCode() {
        return this.getResolvedTypeId().hashCode();
    }

    @NotNull
    public final JSResolvedTypeIdImpl getResolvedTypeId() {
        long trackId;
        JSResolvedTypeIdImpl key = this.myResolvedKey;
        PsiElement element = this.getSource().getSourceElement();
        boolean isElementValid = element != null && element.isValid();
        Project project = isElementValid ? element.getProject() : null;
        long l = trackId = isElementValid ? PsiModificationTracker.SERVICE.getInstance((Project)project).getModificationCount() : -1L;
        if (key == null || key.myTrackId != trackId) {
            JSResolvedTypeIdCache cache = null;
            if (project != null) {
                cache = JSTypeComparingContextService.getService(project).getResolvedTypeIdCacheCache();
            }
            this.myResolvedKey = key = new JSResolvedTypeIdImpl(trackId, this.resolvedHashCodeImpl(), cache);
        }
        JSResolvedTypeIdImpl jSResolvedTypeIdImpl = key;
        if (jSResolvedTypeIdImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(46);
        }
        return jSResolvedTypeIdImpl;
    }

    @NotNull
    protected String getTypeSeparator() {
        String string = JSSymbolPresentationProvider.getDefaultTypeSeparator(this.getSource().getSourceElement());
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(47);
        }
        return string;
    }

    public <T> void setResolvedFlag(@NotNull Key<T> key, @Nullable T value) {
        JSResolvedTypeIdImpl id;
        if (key == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(48);
        }
        if (!(id = this.getResolvedTypeId()).isValid()) {
            return;
        }
        id.getLocalCachedValue(key, () -> value);
    }

    @Nullable
    public <T> T getResolvedFlag(@NotNull Key<T> key) {
        JSResolvedTypeIdImpl id;
        if (key == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(49);
        }
        if (!(id = this.getResolvedTypeId()).isValid()) {
            return null;
        }
        return (T)id.getLocalCachedValue(key, () -> null);
    }

    @NotNull
    protected final JSRecordType emptyRecordType() {
        JSRecordType jSRecordType = this.isTypeScript() ? new JSRecordTypeImpl(this.getSource(), Collections.emptyList()) : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(50);
        }
        return jSRecordType;
    }

    public String toString() {
        return this.getTypeText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromCache";
                break;
            }
            case 22: 
            case 25: 
            case 27: 
            case 31: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 40: 
            case 41: 
            case 43: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 42: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceLanguage";
                break;
            }
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceCondition";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createNewSource";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfNoTransformationType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalCachedType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeHierarchy";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeId";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecordTypeUsage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeSimple";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAlwaysAssignableType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateAssignabilityWithoutCache";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchy";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkUselessCopy";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkSymmetrical";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replaceEmptySourceRecursive";
                break;
            }
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceRecursive";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageRecursive";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setResolvedFlag";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedFlag";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceSourceRecursive$5";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyWithLanguageRecursive$4";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceSourceRecursive$3";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$transformTypeHierarchy$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected final class JSResolvedTypeIdImpl
    implements JSResolvedTypeId {
        private final long myTrackId;
        private final int myHashCode;
        @Nullable
        private final JSResolvedTypeIdCache myCache;

        public JSResolvedTypeIdImpl(long trackId, @Nullable int hashCode, JSResolvedTypeIdCache cache) {
            this.myTrackId = trackId;
            this.myHashCode = hashCode;
            this.myCache = cache;
        }

        public boolean isValid() {
            return this.myTrackId != -1L;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        @NotNull
        public JSType getOwnerType() {
            JSTypeBaseImpl jSTypeBaseImpl = JSTypeBaseImpl.this;
            if (jSTypeBaseImpl == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(0);
            }
            return jSTypeBaseImpl;
        }

        @Nullable
        public <T> T getLocalCachedValue(@NotNull Key<T> key, @NotNull Supplier<? extends T> supplier) {
            if (key == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(1);
            }
            if (supplier == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(2);
            }
            if (!this.isValid() || this.myCache == null) {
                return supplier.get();
            }
            return this.myCache.getLocalCachedValue(this, key, supplier);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof JSResolvedTypeId) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            return JSTypeBaseImpl.this.resolvedEquals(((JSResolvedTypeId)obj).getOwnerType());
        }

        public String toString() {
            return JSTypeBaseImpl.this.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$JSResolvedTypeIdImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$JSResolvedTypeIdImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalCachedValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Holder {
        private static final boolean TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
        private static final JSType SELF_NO_TRANSFORMATION = new JSAnyType(JSTypeSource.SourceLanguage.JS, true){

            @Override
            public String toString() {
                return "Self type";
            }
        };

        private Holder() {
        }
    }
}

