/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.blade.BladeLanguage;
import com.jetbrains.php.blade.parser.BladeDirectiveStack;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladePsiPhpBlock;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeVariableTypeProvider
implements PhpTypeProvider3 {
    public char getKey() {
        return '\u10d1';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof Variable) {
            BladePsiLanguageInjectionHost host = BladeVariableTypeProvider.getInjectionHost(element);
            if (host == null) {
                return null;
            }
            PhpFile phpFile = BladeVariableTypeProvider.getHostPhpFileForInjectedIfExists(host);
            if (phpFile == null) {
                return null;
            }
            String variableName = ((Variable)element).getName();
            PhpType type = new PhpType();
            BladeVariableTypeProvider.addVariableTypes((PsiFile)phpFile, variableName, type);
            BladeVariableTypeProvider.addTypesFromPhpBlocks((PsiFile)phpFile, variableName, type);
            BladeVariableTypeProvider.addTypesFromBladeDirectives(host, variableName, type);
            return type.isEmpty() ? null : type;
        }
        return null;
    }

    private static void addVariableTypes(PsiFile phpFile, String variableName, PhpType type) {
        Set elements = VariableImpl.collectDeclarations((PsiElement)phpFile, (boolean)false, (String)variableName);
        for (PhpNamedElement namedElement : elements) {
            type.add(namedElement.getType());
        }
    }

    private static void addTypesFromPhpBlocks(PsiFile phpFile, String variableName, PhpType type) {
        PsiFile bladeFile = phpFile.getViewProvider().getPsi(BladeLanguage.INSTANCE);
        BladeVariableTypeProvider.getTypesFromChildrenInjectionHosts(phpFile.getProject(), variableName, type, (PsiElement)bladeFile, BladePsiPhpBlock.class);
    }

    private static void getTypesFromChildrenInjectionHosts(@NotNull Project project, String variableName, PhpType type, PsiElement bladeElement, Class<? extends PsiElement> injectionHostsContainerClass) {
        Collection phpBlocks;
        if (project == null) {
            BladeVariableTypeProvider.$$$reportNull$$$0(0);
        }
        if ((phpBlocks = PsiTreeUtil.findChildrenOfType((PsiElement)bladeElement, injectionHostsContainerClass)).isEmpty()) {
            return;
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        for (PsiElement block : phpBlocks) {
            List files = injectedLanguageManager.getInjectedPsiFiles(block);
            if (files == null) continue;
            for (Pair file : files) {
                BladeVariableTypeProvider.addVariableTypes(((PsiElement)file.first).getContainingFile(), variableName, type);
            }
        }
    }

    private static void addTypesFromBladeDirectives(final @NotNull BladePsiLanguageInjectionHost injectionHost, final @NotNull String variableName, final @NotNull PhpType type) {
        if (injectionHost == null) {
            BladeVariableTypeProvider.$$$reportNull$$$0(1);
        }
        if (variableName == null) {
            BladeVariableTypeProvider.$$$reportNull$$$0(2);
        }
        if (type == null) {
            BladeVariableTypeProvider.$$$reportNull$$$0(3);
        }
        BladeDirectiveStack stack = new BladeDirectiveStack(){

            @Override
            protected void reportMissingOpeningProblem(BladePsiDirective directive) {
            }

            @Override
            protected void reportMissingClosingProblem(BladePsiDirective directive) {
                BladeVariableTypeProvider.getTypesFromChildrenInjectionHosts(injectionHost.getProject(), variableName, type, directive, BladePsiLanguageInjectionHost.class);
            }
        };
        stack.handleDirectivesBeforeElement((PsiElement)injectionHost);
    }

    @Nullable
    private static PhpFile getHostPhpFileForInjectedIfExists(@NotNull BladePsiLanguageInjectionHost injectionHost) {
        PsiFile bladeFile;
        if (injectionHost == null) {
            BladeVariableTypeProvider.$$$reportNull$$$0(4);
        }
        if (!((bladeFile = injectionHost.getContainingFile()) instanceof BladeFileImpl)) {
            return null;
        }
        PsiFile psiFile = bladeFile.getViewProvider().getPsi((Language)PhpLanguage.INSTANCE);
        return psiFile instanceof PhpFile ? (PhpFile)psiFile : null;
    }

    @Nullable
    private static BladePsiLanguageInjectionHost getInjectionHost(PsiElement element) {
        PsiFile file = element.getContainingFile();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        boolean injected = injectedLanguageManager.isInjectedFragment(file);
        if (!injected) {
            return null;
        }
        PsiLanguageInjectionHost host = injectedLanguageManager.getInjectionHost(element);
        if (!(host instanceof BladePsiLanguageInjectionHost) || !host.isValidHost()) {
            return null;
        }
        return (BladePsiLanguageInjectionHost)host;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/injection/BladeVariableTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypesFromChildrenInjectionHosts";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypesFromBladeDirectives";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getHostPhpFileForInjectedIfExists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

