/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.custom;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.generators.custom.CustomUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFrameworkDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField myAliasField;
    private JTextField myInvokeField;
    private JLabel myErrorLabel;
    private JTextArea myDescriptionArea;
    private String myErrorMessage;

    public static CustomFrameworkDialog getInstance(@Nullable Component component) {
        return component == null ? new CustomFrameworkDialog() : new CustomFrameworkDialog(component);
    }

    private CustomFrameworkDialog() {
        super(true);
        this.$$$setupUI$$$();
        this.initialize();
    }

    private CustomFrameworkDialog(@NotNull Component component) {
        if (component == null) {
            CustomFrameworkDialog.$$$reportNull$$$0(0);
        }
        super(component, false);
        this.$$$setupUI$$$();
        this.initialize();
    }

    private void initialize() {
        this.myErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.setTitle(FrameworkBundle.message("framework.custom.framework.dialog.title.framework.settings", new Object[0]));
        ValidationDocumentListener validationListener = new ValidationDocumentListener();
        this.myAliasField.getDocument().addDocumentListener((DocumentListener)((Object)validationListener));
        this.myInvokeField.getDocument().addDocumentListener((DocumentListener)((Object)validationListener));
        this.validateData();
        this.notifyValidationResults();
        this.init();
        this.pack();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAliasField;
    }

    protected String getDimensionServiceKey() {
        return CustomFrameworkDialog.class.getName();
    }

    public CustomUtils.CustomFrameworkData getData() {
        String description = this.myDescriptionArea.getText();
        return new CustomUtils.CustomFrameworkData(this.myAliasField.getText(), this.myInvokeField.getText(), description == null ? "" : description);
    }

    private void validateData() {
        this.myErrorMessage = null;
        if (StringUtil.isEmpty((String)this.myInvokeField.getText())) {
            this.myErrorMessage = FrameworkBundle.message("framework.0.not.provided", FrameworkBundle.message("framework.settings.table.tool.path.header", new Object[0]));
            return;
        }
        if (StringUtil.isEmpty((String)this.myAliasField.getText())) {
            this.myErrorMessage = FrameworkBundle.message("framework.0.not.provided", FrameworkBundle.message("framework.settings.table.alias.header", new Object[0]));
        }
    }

    private void notifyValidationResults() {
        if (this.myErrorMessage != null) {
            this.myErrorLabel.setVisible(true);
            this.myErrorLabel.setText(this.myErrorMessage);
        } else {
            this.myErrorLabel.setVisible(false);
        }
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "reference.settings.custom.framework";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/php/framework/generators/custom/CustomFrameworkDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JTextField jTextField;
        JLabel jLabel;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.custom.framework.dialog.command.alias"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAliasField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.custom.framework.dialog.tool.path"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInvokeField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.custom.dialog.description"));
        jLabel4.setVerticalAlignment(0);
        jLabel4.setVerticalTextPosition(0);
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myDescriptionArea = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class ValidationDocumentListener
    extends DocumentAdapter {
        private ValidationDocumentListener() {
        }

        protected void textChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                ValidationDocumentListener.$$$reportNull$$$0(0);
            }
            CustomFrameworkDialog.this.validateData();
            CustomFrameworkDialog.this.notifyValidationResults();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/framework/generators/custom/CustomFrameworkDialog$ValidationDocumentListener", "textChanged"));
        }
    }
}

