/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.b.lb;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.Alarm;
import com.intellij.util.Producer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SearchDialog
extends DialogWrapper {
    protected SearchContext searchContext;
    protected Editor searchCriteriaEdit;
    private ScopeChooserCombo m;
    private JCheckBox n;
    private JCheckBox b;
    private FileTypeSelector g;
    private JLabel i;
    private JLabel r;
    protected Configuration myConfiguration;
    private JCheckBox l;
    private final Alarm q;
    public static final String USER_DEFINED;
    private boolean a;
    @NonNls
    private FileType e;
    private static Language d;
    private static String f;
    private final boolean c;
    private final boolean o;
    private boolean j;
    private String p;
    private JPanel s;
    private JComponent k;
    private JButton h;
    private static final long z;

    public SearchDialog(SearchContext searchContext) {
        this(searchContext, true, true);
    }

    public SearchDialog(SearchContext searchContext, boolean showScope, boolean runFindActionOnClose) {
        long l3 = z ^ 0xECAF2303039L;
        super(searchContext.getProject(), true);
        this.e = StructuralSearchUtil.getDefaultFileType();
        if (showScope) {
            this.setModal(false);
        }
        this.c = showScope;
        this.o = runFindActionOnClose;
        this.searchContext = searchContext;
        this.setTitle(this.getDefaultTitle());
        if (runFindActionOnClose) {
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myConfiguration = this.createConfiguration(null);
        this.init();
        this.q = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(searchContext.getProject(), new ProjectManagerListener(){
            private static final long a = lb.a(2850058911740262164L, 2483094133893333059L, MethodHandles.lookup().lookupClass()).a(22422817125088L);

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.a(0);
                }
                SearchDialog.this.close(1);
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x5E4787055114L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/SearchDialog$1", "projectClosing"));
            }
        });
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.a = useLastConfiguration;
    }

    void setSearchPattern(Configuration config) {
        this.setValuesFromConfig(config);
        this.initiateValidation();
    }

    protected Editor createEditor(SearchContext searchContext, String text) {
        Document document;
        FileTypeInfo fileTypeInfo;
        Editor editor = null;
        if (this.g != null && (fileTypeInfo = this.g.getSelectedItem()) != null) {
            document = fileTypeInfo.getFileType();
            Language language = fileTypeInfo.getDialect();
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType((FileType)document);
            if (structuralSearchProfile != null) {
                editor = structuralSearchProfile.createEditor(searchContext.getProject(), (FileType)document, language, text);
            }
        }
        if (editor == null) {
            fileTypeInfo = EditorFactory.getInstance();
            document = fileTypeInfo.createDocument("");
            editor = fileTypeInfo.createEditor(document, searchContext.getProject());
            editor.getSettings().setFoldingOutlineShown(false);
        }
        editor.getDocument().addDocumentListener(new DocumentListener(){
            private static final long a = lb.a(-165494540737828096L, -4182963050296102402L, MethodHandles.lookup().lookupClass()).a(138096709421110L);

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.a(0);
                }
                SearchDialog.this.initiateValidation();
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x56B4AFE65D24L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/SearchDialog$2", "documentChanged"));
            }
        });
        return editor;
    }

    void initiateValidation() {
        this.q.cancelAllRequests();
        this.q.addRequest(() -> {
            try {
                boolean bl2 = this.isValid();
                boolean bl3 = this.b();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.h.setEnabled(bl3);
                    this.getOKAction().setEnabled(bl2);
                }, ModalityState.stateForComponent((Component)this.getRootPane()));
            }
            catch (ProcessCanceledException processCanceledException) {
                throw processCanceledException;
            }
            catch (RuntimeException runtimeException) {
                Logger.getInstance(SearchDialog.class).error((Throwable)runtimeException);
            }
        }, 250);
    }

    private boolean b() {
        try {
            return PatternCompiler.compilePattern(this.getProject(), this.myConfiguration.getMatchOptions(), false) != null;
        }
        catch (MalformedPatternException malformedPatternException) {
            return false;
        }
    }

    protected void buildOptions(JPanel searchOptions) {
        long l3 = z ^ 0x7252A23A132L;
        this.n = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        if (this.isRecursiveSearchEnabled()) {
            searchOptions.add(UIUtil.createOptionLine(this.n));
        }
        this.b = new JCheckBox(FindBundle.message((String)"find.options.case.sensitive", (Object[])new Object[0]), true);
        searchOptions.add(UIUtil.createOptionLine(this.b));
        ArrayList<FileType> arrayList = new ArrayList<FileType>();
        for (FileType fileType3 : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType3) == null) continue;
            arrayList.add(fileType3);
        }
        Collections.sort(arrayList, (fileType, fileType2) -> fileType.getName().compareToIgnoreCase(fileType2.getName()));
        this.g = new FileTypeSelector(arrayList);
        JLabel jLabel = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        searchOptions.add(UIUtil.createOptionLine(new JComponent[]{jLabel, this.g}));
        jLabel.setLabelFor((Component)((Object)this.g));
        this.c();
        this.g.setSelectedItem(this.e, d, f);
        this.g.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e10) {
                if (e10.getStateChange() == 1) {
                    SearchDialog.this.updateEditor();
                    SearchDialog.this.initiateValidation();
                }
            }
        });
    }

    void updateEditor() {
        long l3 = z ^ 0x162A330C24E6L;
        if (this.s != null) {
            if (this.k != null) {
                this.s.remove(this.k);
            }
            this.disposeEditorContent();
            this.k = this.createEditorContent();
            this.s.add((Component)this.k, "Center");
            this.s.revalidate();
            this.searchCriteriaEdit.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
    }

    private void c() {
        PsiFile psiFile = this.searchContext.getFile();
        if (psiFile != null) {
            FileType fileType;
            PsiFile psiFile2 = null;
            if (this.searchContext.getEditor() != null && (psiFile2 = psiFile.findElementAt(this.searchContext.getEditor().getCaretModel().getOffset())) != null) {
                psiFile2 = psiFile2.getParent();
            }
            if (psiFile2 == null) {
                psiFile2 = psiFile;
            }
            FileType fileType2 = null;
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement((PsiElement)psiFile2);
            if (structuralSearchProfile != null && (fileType = structuralSearchProfile.detectFileType((PsiElement)psiFile2)) != null) {
                fileType2 = fileType;
            }
            if (fileType2 == null) {
                for (FileType fileType3 : StructuralSearchUtil.getSuitableFileTypes()) {
                    if (!(fileType3 instanceof LanguageFileType) || !((LanguageFileType)fileType3).getLanguage().equals(psiFile2.getLanguage())) continue;
                    fileType2 = fileType3;
                    break;
                }
            }
            this.e = fileType2 != null ? fileType2 : StructuralSearchUtil.getDefaultFileType();
        }
    }

    protected boolean isRecursiveSearchEnabled() {
        return this.c;
    }

    public void setValuesFromConfig(Configuration configuration) {
        this.myConfiguration = this.createConfiguration(configuration);
        this.setDialogTitle(this.myConfiguration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        UIUtil.setContent(this.searchCriteriaEdit, matchOptions.getSearchPattern());
        this.n.setSelected(this.isRecursiveSearchEnabled() && matchOptions.isRecursiveSearch());
        this.b.setSelected(matchOptions.isCaseSensitiveMatch());
        this.g.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        this.searchCriteriaEdit.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
    }

    void setDialogTitle(Configuration configuration) {
        long l3 = z ^ 0x5E5DFBE2305AL;
        this.setTitle(this.getDefaultTitle() + " - " + configuration.getName());
    }

    public Configuration createConfiguration(Configuration template) {
        return template == null ? new SearchConfiguration(USER_DEFINED, USER_DEFINED) : new SearchConfiguration(template);
    }

    protected void setText(String text) {
        this.setTextForEditor(text, this.searchCriteriaEdit);
    }

    protected final void setTextForEditor(String selection, Editor editor) {
        Project project = this.searchContext.getProject();
        UIUtil.setContent(editor, selection);
        Document document = editor.getDocument();
        editor.getSelectionModel().setSelection(0, document.getTextLength());
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).run(() -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, new TextRange(0, document.getTextLength())));
    }

    protected void startSearching() {
        new SearchCommand(this.myConfiguration, this.searchContext).startSearching();
    }

    protected String getDefaultTitle() {
        long l3 = z ^ 0x96151D99BF4L;
        return SSRBundle.message("structural.search.title", new Object[0]);
    }

    protected JComponent createEditorContent() {
        long l3 = z ^ 0x15531255B362L;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.searchCriteriaEdit = this.createEditor(this.searchContext, this.p != null ? this.p : "");
        jPanel.add("Center", this.searchCriteriaEdit.getComponent());
        jPanel.setMinimumSize(new Dimension(150, 100));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 2, 0));
        jPanel2.add(new JLabel(SSRBundle.message("search.template", new Object[0])));
        jPanel2.add(UIUtil.createCompleteMatchInfo((Producer<? extends Configuration>)((Producer)() -> this.myConfiguration)));
        jPanel.add("North", jPanel2);
        return jPanel;
    }

    protected int getRowsCount() {
        return 4;
    }

    protected JComponent createCenterPanel() {
        TitledSeparator titledSeparator;
        JPanel jPanel;
        long l3 = z ^ 0x7B34B2E027AEL;
        this.s = new JPanel(new BorderLayout());
        this.k = this.createEditorContent();
        this.s.add("Center", this.k);
        this.s.add("South", Box.createVerticalStrut(8));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", this.s);
        jPanel3.add("South", this.a());
        jPanel2.add("Center", jPanel3);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add("South", jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(this.getRowsCount(), 1, 0, 0));
        jPanel4.setBorder((Border)IdeBorderFactory.createTitledBorder((String)SSRBundle.message("ssdialog.options.group.border", new Object[0]), (boolean)true));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        if (this.c) {
            this.m = new ScopeChooserCombo(this.searchContext.getProject(), true, false, FindSettings.getInstance().getDefaultScopeName());
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.m);
            jPanel = new JPanel(new GridBagLayout());
            titledSeparator = new TitledSeparator(SSRBundle.message("search.dialog.scope.label", new Object[0]), (JComponent)this.m.getComboBox());
            jPanel.add((Component)titledSeparator, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, (Insets)JBUI.insetsTop((int)5), 0, 0));
            jPanel.add((Component)this.m, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
            jPanel5.add((Component)jPanel, "South");
            this.m.getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e10) {
                    SearchDialog.this.initiateValidation();
                }
            });
        } else {
            this.m = null;
        }
        this.buildOptions(jPanel4);
        jPanel5.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel5, "Center");
        if (this.o) {
            jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.l = new JCheckBox(FindBundle.message((String)"find.open.in.new.tab.checkbox", (Object[])new Object[0]));
            this.l.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
            titledSeparator = ToolWindowManager.getInstance((Project)this.searchContext.getProject()).getToolWindow(ToolWindowId.FIND);
            this.l.setEnabled(titledSeparator != null && titledSeparator.isAvailable());
            jPanel.add((Component)this.l, "East");
            jPanel3.add("South", jPanel);
        }
        this.updateEditor();
        return jPanel2;
    }

    protected JComponent createSouthPanel() {
        long l3 = z ^ 0x6B2AC2974E4EL;
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        jPanel.add((Component)super.createSouthPanel(), "North");
        this.r = new JLabel(SSRBundle.message("status.message", new Object[0]));
        jPanel.add((Component)this.r, "West");
        this.i = new JLabel();
        jPanel.add((Component)this.i, "Center");
        this.i.setMinimumSize(new Dimension(0, 0));
        return jPanel;
    }

    private JPanel a() {
        JPanel jPanel = new JPanel(null);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = lb.a(2114851757115592938L, 6427040285393550017L, MethodHandles.lookup().lookupClass()).a(106006191415693L);
            {
                long l3 = a ^ 0x55D2CB05F053L;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("save.template.text.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                Configuration configuration = this.this$0.getConfiguration();
                if (!ConfigurationManager.getInstance(this.this$0.getProject()).showSaveTemplateAsDialog(configuration)) {
                    return;
                }
                this.this$0.setDialogTitle(configuration);
            }
        }));
        jPanel.add(Box.createHorizontalStrut(8));
        this.h = this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = lb.a(6634361641207597964L, 6034881723182672997L, MethodHandles.lookup().lookupClass()).a(162000470566092L);
            {
                long l3 = a ^ 0x7D19EACB9768L;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("edit.variables.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                new EditVarConstraintsDialog(this.this$0.searchContext.getProject(), this.this$0.myConfiguration, this.this$0.getVariablesFromListeners(), this.this$0.g.getSelectedFileType()).show();
                this.this$0.initiateValidation();
            }
        });
        jPanel.add(this.h);
        jPanel.add(Box.createHorizontalStrut(8));
        jPanel.add(this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = lb.a(4077789947454491267L, 5138268156193435849L, MethodHandles.lookup().lookupClass()).a(276338986788479L);
            {
                long l3 = a ^ 0x2E37FFCBE2FBL;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("history.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                SelectTemplateDialog selectTemplateDialog = new SelectTemplateDialog(this.this$0.searchContext.getProject(), true, this.this$0.isReplaceDialog());
                if (!selectTemplateDialog.showAndGet()) {
                    return;
                }
                Configuration[] configurationArray = selectTemplateDialog.getSelectedConfigurations();
                if (configurationArray.length == 1) {
                    this.this$0.setSearchPattern(configurationArray[0]);
                    this.this$0.initiateValidation();
                }
            }
        }));
        jPanel.add(Box.createHorizontalStrut(8));
        jPanel.add(this.createJButtonForAction(new AbstractAction(this){
            final /* synthetic */ SearchDialog this$0;
            private static final long a = lb.a(-3892323104177928063L, 8031475290928279643L, MethodHandles.lookup().lookupClass()).a(81117353786730L);
            {
                long l3 = a ^ 0x38388E9EFE99L;
                this.this$0 = this$0;
                this.putValue("Name", SSRBundle.message("copy.existing.template.button", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e10) {
                SelectTemplateDialog selectTemplateDialog = new SelectTemplateDialog(this.this$0.searchContext.getProject(), false, this.this$0.isReplaceDialog());
                if (!selectTemplateDialog.showAndGet()) {
                    return;
                }
                Configuration[] configurationArray = selectTemplateDialog.getSelectedConfigurations();
                if (configurationArray.length == 1) {
                    this.this$0.setSearchPattern(configurationArray[0]);
                }
            }
        }));
        return jPanel;
    }

    protected List<String> getVariablesFromListeners() {
        return SearchDialog.getVarsFrom(this.searchCriteriaEdit);
    }

    protected static List<String> getVarsFrom(Editor searchCriteriaEdit) {
        SubstitutionShortInfoHandler substitutionShortInfoHandler = SubstitutionShortInfoHandler.retrieve(searchCriteriaEdit);
        return substitutionShortInfoHandler == null ? new ArrayList<String>() : new ArrayList<String>(substitutionShortInfoHandler.getVariables());
    }

    public final Project getProject() {
        return this.searchContext.getProject();
    }

    protected boolean isReplaceDialog() {
        return false;
    }

    public void show() {
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(true);
        if (!this.a) {
            Object object;
            Editor editor = this.searchContext.getEditor();
            boolean bl2 = false;
            if (editor != null && (object = editor.getSelectionModel()).hasSelection()) {
                this.setText(object.getSelectedText());
                bl2 = true;
            }
            if (!bl2 && (object = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration()) != null) {
                this.setValuesFromConfig((Configuration)object);
            }
        }
        this.initiateValidation();
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.searchCriteriaEdit.getContentComponent();
    }

    protected void doOKAction() {
        long l3 = z ^ 0x4AB683BD8352L;
        this.j = true;
        boolean bl2 = this.isValid();
        this.j = false;
        if (!bl2) {
            return;
        }
        this.q.cancelAllRequests();
        super.doOKAction();
        if (!this.o) {
            return;
        }
        SearchScope searchScope = this.m.getSelectedScope();
        if (searchScope == null) {
            return;
        }
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setDefaultScopeName(searchScope.getDisplayName());
        findSettings.setShowResultsInSeparateView(this.l.isSelected());
        try {
            this.a(this.myConfiguration);
            ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
            this.startSearching();
        }
        catch (MalformedPatternException malformedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage()), this.searchCriteriaEdit);
        }
    }

    private void a(Configuration configuration) {
        long l3 = z ^ 0x64EB1AF474C8L;
        List<String> list2 = this.getVariablesFromListeners();
        list2.add("__context__");
        configuration.getMatchOptions().retainVariableConstraints(list2);
    }

    public Configuration getConfiguration() {
        this.a(this.myConfiguration);
        this.setValuesToConfig(this.myConfiguration);
        return this.myConfiguration;
    }

    protected boolean isValid() {
        long l3 = z ^ 0x4A32FA374A75L;
        try {
            Matcher.validate(this.searchContext.getProject(), this.getConfiguration().getMatchOptions());
        }
        catch (MalformedPatternException malformedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage() != null ? malformedPatternException.getMessage() : ""), this.searchCriteriaEdit);
            return false;
        }
        catch (UnsupportedPatternException unsupportedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", unsupportedPatternException.getMessage()), this.searchCriteriaEdit);
            return false;
        }
        catch (NoMatchFoundException noMatchFoundException) {
            this.reportMessage(noMatchFoundException.getMessage(), this.searchCriteriaEdit);
            return false;
        }
        this.reportMessage("", null);
        return true;
    }

    protected void reportMessage(String message, Editor editor) {
        com.intellij.util.ui.UIUtil.invokeLaterIfNeeded(() -> {
            this.i.setText(message);
            this.i.setToolTipText(message);
            this.i.revalidate();
            this.r.setLabelFor(editor != null ? editor.getContentComponent() : null);
        });
    }

    protected void setValuesToConfig(Configuration config) {
        long l3 = z ^ 0x764FE8A735EAL;
        MatchOptions matchOptions = config.getMatchOptions();
        if (this.c) {
            boolean bl2 = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(this.m.getSelectedScopeName());
            matchOptions.setScope((SearchScope)(bl2 && !this.j ? GlobalSearchScope.projectScope((Project)this.getProject()) : this.m.getSelectedScope()));
        }
        matchOptions.setRecursiveSearch(this.isRecursiveSearchEnabled() && this.n.isSelected());
        FileTypeInfo fileTypeInfo = this.g.getSelectedItem();
        this.e = fileTypeInfo != null ? fileTypeInfo.getFileType() : null;
        d = fileTypeInfo != null ? fileTypeInfo.getDialect() : null;
        f = fileTypeInfo != null ? fileTypeInfo.getContext() : null;
        FileType fileType = this.e;
        matchOptions.setFileType(fileType);
        matchOptions.setDialect(d);
        matchOptions.setPatternContext(f);
        matchOptions.setSearchPattern(this.searchCriteriaEdit.getDocument().getText());
        matchOptions.setCaseSensitiveMatch(this.b.isSelected());
    }

    protected String getDimensionServiceKey() {
        long l3 = z ^ 0x7BEE01D81D8FL;
        return "#com.intellij.structuralsearch.plugin.ui.SearchDialog";
    }

    public void dispose() {
        this.disposeEditorContent();
        this.q.cancelAllRequests();
        super.dispose();
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(false);
    }

    protected void disposeEditorContent() {
        this.p = this.searchCriteriaEdit.getDocument().getText();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.searchContext.getProject()).getPsiFile(this.searchCriteriaEdit.getDocument());
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.searchContext.getProject()).setHighlightingEnabled(psiFile, true);
        }
        EditorFactory.getInstance().releaseEditor(this.searchCriteriaEdit);
    }

    protected String getHelpId() {
        long l3 = z ^ 0x16FC7F2DC8DEL;
        return "find.structuredSearch";
    }

    static {
        z = lb.a(3970803203117906743L, 3510158096688370490L, MethodHandles.lookup().lookupClass()).a(216106396870873L);
        long l3 = z ^ 0x6A02FB2B2E4AL;
        USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
        d = null;
        f = null;
    }
}

