/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javascript.JSRunConfigurationBuilder;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonGetDependenciesAction;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.AngularJSIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.angular2.cli.AngularCliConfigLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCliUtil {
    private static final NotificationGroup ANGULAR_CLI_NOTIFICATIONS = new NotificationGroup("Angular CLI", NotificationDisplayType.BALLOON, false, null, AngularJSIcons.Angular2);
    private static final List<String> ANGULAR_JSON_NAMES = ContainerUtil.newArrayList((Object[])new String[]{"angular.json", ".angular-cli.json", "angular-cli.json"});

    @Nullable
    public static VirtualFile findCliJson(@Nullable VirtualFile dir) {
        if (dir == null) {
            return null;
        }
        for (String name : ANGULAR_JSON_NAMES) {
            VirtualFile cliJson = dir.findChild(name);
            if (cliJson == null) continue;
            return cliJson;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findAngularCliFolder(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(0);
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || AngularCliUtil.findCliJson(current) == null) continue;
            return current;
        }
        if (AngularCliUtil.findCliJson(project.getBaseDir()) != null) {
            return project.getBaseDir();
        }
        return null;
    }

    public static boolean hasAngularCLIPackageInstalled(@NotNull Project project, @NotNull VirtualFile cli) {
        NodeJsInterpreter interpreter;
        NodeJsLocalInterpreter node;
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(1);
        }
        if (cli == null) {
            AngularCliUtil.$$$reportNull$$$0(2);
        }
        if ((node = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)(interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter()))) == null) {
            return false;
        }
        ArrayList modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName(modules, (String)"@angular/cli", (VirtualFile)cli, (boolean)false, (NodeJsInterpreter)node);
        return !modules.isEmpty() && ((CompletionModuleInfo)modules.get(0)).getVirtualFile() != null;
    }

    public static boolean isAngularJsonFile(@NotNull String fileName) {
        if (fileName == null) {
            AngularCliUtil.$$$reportNull$$$0(3);
        }
        return ANGULAR_JSON_NAMES.contains(fileName);
    }

    public static void notifyAngularCliNotInstalled(@NotNull Project project, @NotNull VirtualFile cliFolder, @NotNull String message) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(4);
        }
        if (cliFolder == null) {
            AngularCliUtil.$$$reportNull$$$0(5);
        }
        if (message == null) {
            AngularCliUtil.$$$reportNull$$$0(6);
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)cliFolder);
        Notification notification = ANGULAR_CLI_NOTIFICATIONS.createNotification(message, "Required package '@angular/cli' is not installed.", NotificationType.WARNING, null);
        if (packageJson != null) {
            notification.addAction((AnAction)new PackageJsonGetDependenciesAction(project, packageJson, notification));
        }
        notification.notify(project);
    }

    public static void createRunConfigurations(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            AngularCliUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project == null) {
                AngularCliUtil.$$$reportNull$$$0(36);
            }
            if (baseDir == null) {
                AngularCliUtil.$$$reportNull$$$0(37);
            }
            DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                if (project == null) {
                    AngularCliUtil.$$$reportNull$$$0(38);
                }
                if (baseDir == null) {
                    AngularCliUtil.$$$reportNull$$$0(39);
                }
                if (project.isDisposed()) {
                    return;
                }
                String packageJsonPath = AngularCliUtil.getPackageJson(baseDir);
                if (packageJsonPath == null || !AngularCliConfigLoader.load(project, baseDir).exists()) {
                    return;
                }
                String nameSuffix = ModuleManager.getInstance((Project)project).getModules().length > 1 ? " (" + baseDir.getName() + ")" : "";
                AngularCliUtil.createJSDebugConfiguration(project, "Angular Application" + nameSuffix, "http://localhost:4200");
                AngularCliUtil.createKarmaConfiguration(project, baseDir, "Tests" + nameSuffix);
                AngularCliUtil.createProtractorConfiguration(project, baseDir, "E2E Tests" + nameSuffix);
                RunManager.getInstance((Project)project).setSelectedConfiguration(AngularCliUtil.createNpmConfiguration(project, packageJsonPath, "Angular CLI Server" + nameSuffix, "start"));
            });
        });
    }

    @Nullable
    private static String getPackageJson(@NotNull VirtualFile baseDir) {
        VirtualFile pkg;
        if (baseDir == null) {
            AngularCliUtil.$$$reportNull$$$0(9);
        }
        if ((pkg = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)baseDir)) != null) {
            return pkg.getPath();
        }
        return null;
    }

    private static void createJSDebugConfiguration(@NotNull Project project, @NotNull String label, @NotNull String url) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(10);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(11);
        }
        if (url == null) {
            AngularCliUtil.$$$reportNull$$$0(12);
        }
        AngularCliUtil.createIfNoSimilar("jsdebug", project, label, null, null, ContainerUtil.newHashMap((Pair)Pair.pair((Object)"uri", (Object)url), (Pair[])new Pair[0]));
    }

    @Nullable
    private static RunnerAndConfigurationSettings createNpmConfiguration(@NotNull Project project, @NotNull String packageJsonPath, @NotNull String label, @NotNull String scriptName) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(13);
        }
        if (packageJsonPath == null) {
            AngularCliUtil.$$$reportNull$$$0(14);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(15);
        }
        if (scriptName == null) {
            AngularCliUtil.$$$reportNull$$$0(16);
        }
        return AngularCliUtil.createIfNoSimilar("npm", project, label, null, packageJsonPath, ContainerUtil.newHashMap((Pair)Pair.pair((Object)"run-script", (Object)scriptName), (Pair[])new Pair[0]));
    }

    private static void createKarmaConfiguration(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull String label) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(17);
        }
        if (baseDir == null) {
            AngularCliUtil.$$$reportNull$$$0(18);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(19);
        }
        ObjectUtils.doIfNotNull((Object)AngularCliConfigLoader.load(project, baseDir).getKarmaConfigFile(), file -> {
            if (project == null) {
                AngularCliUtil.$$$reportNull$$$0(33);
            }
            if (label == null) {
                AngularCliUtil.$$$reportNull$$$0(34);
            }
            if (baseDir == null) {
                AngularCliUtil.$$$reportNull$$$0(35);
            }
            return AngularCliUtil.createIfNoSimilar("karma", project, label, baseDir, file.getPath(), Collections.emptyMap());
        });
    }

    private static void createProtractorConfiguration(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull String label) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(20);
        }
        if (baseDir == null) {
            AngularCliUtil.$$$reportNull$$$0(21);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(22);
        }
        ObjectUtils.doIfNotNull((Object)AngularCliConfigLoader.load(project, baseDir).getProtractorConfigFile(), file -> {
            if (project == null) {
                AngularCliUtil.$$$reportNull$$$0(31);
            }
            if (label == null) {
                AngularCliUtil.$$$reportNull$$$0(32);
            }
            return AngularCliUtil.createIfNoSimilar("protractor", project, label, null, file.getPath(), Collections.emptyMap());
        });
    }

    @Nullable
    private static RunnerAndConfigurationSettings createIfNoSimilar(@NotNull String rcType, @NotNull Project project, @NotNull String label, VirtualFile baseDir, String configPath, @NotNull Map<String, Object> options) {
        if (rcType == null) {
            AngularCliUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(24);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(25);
        }
        if (options == null) {
            AngularCliUtil.$$$reportNull$$$0(26);
        }
        return (RunnerAndConfigurationSettings)ObjectUtils.doIfNotNull((Object)JSRunConfigurationBuilder.getForName((String)rcType, (Project)project), builder -> {
            if (options == null) {
                AngularCliUtil.$$$reportNull$$$0(27);
            }
            if (label == null) {
                AngularCliUtil.$$$reportNull$$$0(28);
            }
            return (RunnerAndConfigurationSettings)ObjectUtils.notNull((Object)builder.findSimilarRunConfiguration(baseDir, configPath, options), () -> {
                if (label == null) {
                    AngularCliUtil.$$$reportNull$$$0(29);
                }
                if (options == null) {
                    AngularCliUtil.$$$reportNull$$$0(30);
                }
                return builder.createRunConfiguration(label, baseDir, configPath, options);
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cli";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliFolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 21: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rcType";
                break;
            }
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "org/angular2/cli/AngularCliUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findAngularCliFolder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAngularCLIPackageInstalled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAngularJsonFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyAngularCliNotInstalled";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunConfigurations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageJson";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createJSDebugConfiguration";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "createNpmConfiguration";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "createKarmaConfiguration";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "createProtractorConfiguration";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "createIfNoSimilar";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createIfNoSimilar$5";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$4";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createProtractorConfiguration$3";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createKarmaConfiguration$2";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createRunConfigurations$1";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

