/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.machine.DockerMachineUtil;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockerSettings", storages={@Storage(value="docker.xml")})
public class DockerSettings
implements PersistentStateComponent<DockerSettings> {
    private static final String DEFAULT_DOCKER_COMPOSE_EXECUTABLE = "docker-compose";
    private static final String DEFAULT_DOCKER_COMPOSE_EXECUTABLE_ON_MAC_OS_X = "/usr/local/bin/docker-compose";
    private String myDockerMachinePath;
    private String myDockerComposePath;

    @NotNull
    public static DockerSettings getInstance() {
        DockerSettings dockerSettings = (DockerSettings)ServiceManager.getService(DockerSettings.class);
        if (dockerSettings == null) {
            DockerSettings.$$$reportNull$$$0(0);
        }
        return dockerSettings;
    }

    @Nullable
    public DockerSettings getState() {
        return this;
    }

    public void loadState(@NotNull DockerSettings state) {
        if (state == null) {
            DockerSettings.$$$reportNull$$$0(1);
        }
        this.setDockerMachinePath(state.getDockerMachinePath());
        this.setDockerComposePath(state.getDockerComposePath());
    }

    @NotNull
    public String getDockerMachinePath() {
        if (this.myDockerMachinePath == null) {
            this.myDockerMachinePath = DockerMachineUtil.tryFindDockerMachineExecutable().orElse(DockerMachineUtil.getDefaultDockerMachineExecutable());
        }
        String string = this.myDockerMachinePath;
        if (string == null) {
            DockerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setDockerMachinePath(String dockerMachinePath) {
        this.myDockerMachinePath = dockerMachinePath;
    }

    @NotNull
    public String getDockerComposePath() {
        if (this.myDockerComposePath == null) {
            File foundInPath;
            this.myDockerComposePath = SystemInfo.isMac ? DEFAULT_DOCKER_COMPOSE_EXECUTABLE_ON_MAC_OS_X : ((foundInPath = PathEnvironmentVariableUtil.findInPath((String)DEFAULT_DOCKER_COMPOSE_EXECUTABLE)) != null ? foundInPath.getAbsolutePath() : DEFAULT_DOCKER_COMPOSE_EXECUTABLE);
        }
        String string = this.myDockerComposePath;
        if (string == null) {
            DockerSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setDockerComposePath(String dockerComposePath) {
        this.myDockerComposePath = dockerComposePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerMachinePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

