/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverValidator
extends DatabaseConfigValidator<DatabaseDriverImpl> {
    @Override
    public Class<DatabaseDriverImpl> getTargetClass() {
        return DatabaseDriverImpl.class;
    }

    @Override
    public void collectProblems(@NotNull DatabaseDriverImpl driver, @NotNull Consumer<DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(0);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(1);
        }
        if (!driver.getTemplatesErrors().isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (Pair<UrlTemplate, String> pair : driver.getTemplatesErrors()) {
                msg.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                msg.append(StringUtil.escapeXml((String)((UrlTemplate)pair.getFirst()).getName())).append(" &mdash; ").append(StringUtil.escapeXml((String)((String)pair.getSecond())));
            }
            String shortDesc = msg.toString();
            String longDesc = "Driver <a href=\"$ACTION0\">" + StringUtil.escapeXml((String)driver.getFullName()) + "</a> has invalid templates:" + shortDesc;
            problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText("Invalid template", shortDesc, longDesc, new DataSourceProblem.Navigate(driver)), null));
        }
    }

    public static boolean isDriverFilesValid(@NotNull String artifact, @Nullable String version, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifact == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(2);
        }
        DatabaseArtifactManager.DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        if (version == null) {
            return actual != null && !actual.isEmpty() && DatabaseDriverValidator.isFileListExists(DatabaseDriverValidator.getUrls(actual));
        }
        return artifacts.isValid(artifact, version);
    }

    public static boolean isDriverFilesUpToDate(@NotNull String artifact, @Nullable String version, boolean isRolling, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifact == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(3);
        }
        if (version == null) {
            if (actual == null || actual.isEmpty()) {
                return false;
            }
            JBIterable<String> urls = DatabaseDriverValidator.getUrls(actual);
            if (!DatabaseDriverValidator.isFileListExists(urls)) {
                return false;
            }
            if (!isRolling) {
                return true;
            }
            DatabaseArtifactManager.DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
            String actualVersion = artifacts.getActualVersion(artifact);
            return actualVersion == null || artifacts.isFreshFiles(artifact, actualVersion, urls.transform(VfsUtil::extractFileName).toSet());
        }
        DatabaseArtifactManager.DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        if (!isRolling) {
            return artifacts.isValid(artifact, version);
        }
        String actualVersion = "latest".equals(version) ? null : artifacts.getActualVersion(artifact);
        return (actualVersion == null || actualVersion.equals(version)) && artifacts.isValid(artifact, version);
    }

    @NotNull
    protected static JBIterable<String> getUrls(@Nullable Collection<SimpleClasspathElement> actual) {
        JBIterable jBIterable = JBIterable.from(actual).flatten(SimpleClasspathElement::getClassesRootUrls);
        if (jBIterable == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static boolean isFileListExists(@NotNull JBIterable<String> urls) {
        if (urls == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(5);
        }
        return urls.filter(url -> !FileUtil.exists((String)VfsUtilCore.urlToPath((String)url))).isEmpty();
    }

    public static void findDriverFilesProblems(@Nullable DatabaseDriver driver, @NotNull Consumer<DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(6);
        }
        if (driver == null) {
            return;
        }
        DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
        if (artifact != null && artifact.isUsed()) {
            String driverName = StringUtil.escapeXml((String)driver.getName());
            List<SimpleClasspathElement> curClassPath = driver.getClasspathElements();
            boolean needDownload = !DatabaseDriverValidator.isDriverFilesValid(artifact.getName(), artifact.getVersion(), curClassPath);
            DataSourceProblem.Navigate navigate = new DataSourceProblem.Navigate(driver);
            String actualVersion = DatabaseArtifactManager.getArtifacts().getActualVersion(artifact.getName());
            boolean currentUpToDate = DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), artifact.getVersion(), artifact.isRolling(), curClassPath);
            if (needDownload) {
                if (actualVersion == null) {
                    String description = "No provided files for <a href=\"$ACTION0\">" + driverName + "</a>";
                    problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", description, description, navigate), null));
                } else {
                    String expectedVer = (String)ObjectUtils.chooseNotNull((Object)artifact.getVersion(), (Object)"latest");
                    boolean download = !DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), expectedVer, true, null);
                    MyDriverDownloader downloader = new MyDriverDownloader(driver, expectedVer, editor);
                    problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", download ? "<a href=\"$ACTION0\">Download</a> missing driver files" : (curClassPath.isEmpty() ? "No driver files configured" : "Missing essential driver files") + ". <a href=\"$ACTION0\">Switch</a> to " + expectedVer, download ? "Download missing <a href=\"$ACTION1\">" + driverName + "</a> driver files" : "Switch to existing <a href=\"$ACTION1\">" + driverName + "</a> driver", downloader, navigate), downloader));
                }
            } else if (!currentUpToDate) {
                MyDriverDownloader downloader = new MyDriverDownloader(driver, "latest", editor);
                boolean download = !DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), "latest", true, null);
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.HINT, new DataSourceProblem.HyperText("", download ? "<a href=\"$ACTION0\">Update</a> driver files" : "<a href=\"$ACTION0\">Switch</a> to latest", download ? "Update <a href=\"$ACTION1\">" + driverName + "</a> driver files" : "Switch to existing <a href=\"$ACTION1\">" + driverName + "</a> driver", downloader, navigate), downloader));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesUpToDate";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileListExists";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDriverFilesProblems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDriverDownloader
    extends NamedProgressive {
        private final DatabaseDriver myDriver;
        private final String myVersion;
        private final DatabaseConfigEditor myEditor;

        MyDriverDownloader(@NotNull DatabaseDriver driver, @NotNull String version, @Nullable DatabaseConfigEditor editor) {
            if (driver == null) {
                MyDriverDownloader.$$$reportNull$$$0(0);
            }
            if (version == null) {
                MyDriverDownloader.$$$reportNull$$$0(1);
            }
            super(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{"Driver Files"}));
            this.myDriver = driver;
            this.myVersion = version;
            this.myEditor = editor;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            String realVersion;
            DatabaseDriver.ArtifactRef artifact;
            if (indicator == null) {
                MyDriverDownloader.$$$reportNull$$$0(2);
            }
            if ((artifact = this.myDriver.getArtifact()) == null) {
                return;
            }
            DatabaseArtifactManager.DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
            String prevVer = artifact.getVersion();
            String string = realVersion = this.myVersion.equals("latest") ? artifacts.getActualVersion(artifact.getName()) : this.myVersion;
            if (realVersion == null) {
                return;
            }
            indicator.setText(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)artifact.getName()) + " files"}));
            boolean ok = DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), realVersion, true, null);
            ApplicationManager.getApplication().invokeLater(() -> {
                DatabaseDriverConfigurable configurable = this.myEditor == null ? null : this.myEditor.getConfigurable(this.myDriver, true, DatabaseDriverConfigurable.class);
                DatabaseDriverImpl tempDriver = configurable == null ? (DatabaseDriverImpl)this.myDriver : configurable.getTempDriver();
                tempDriver.setArtifact(artifact.getName(), realVersion, artifact.isRolling());
                if (configurable != null) {
                    configurable.resetFromTemp();
                }
                if (ok && this.myEditor != null) {
                    this.myEditor.onDriverDownloaded(this.myDriver);
                }
            });
            if (ok) {
                return;
            }
            while (!indicator.isCanceled()) {
                try {
                    DatabaseArtifactManager.getInstance().downloadArtifact(artifact.getName(), this.myVersion, (Consumer<DownloadableFileSetDescription>)((Consumer)o -> {
                        if (!Comparing.equal((String)prevVer, (String)o.getVersionString()) && this.myEditor != null) {
                            this.myEditor.onDriverDownloaded(this.myDriver);
                        }
                    }));
                }
                catch (IOException e) {
                    String msg = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)artifact.getName()) + " files"});
                    boolean retry = IOExceptionDialog.showErrorDialog((String)msg, (String)e.getMessage());
                    if (retry) continue;
                }
                break;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyDriverDownloader that = (MyDriverDownloader)o;
            if (!this.myDriver.equals(that.myDriver)) {
                return false;
            }
            if (!this.myVersion.equals(that.myVersion)) {
                return false;
            }
            return !(this.myEditor != null ? !this.myEditor.equals(that.myEditor) : that.myEditor != null);
        }

        public int hashCode() {
            int result2 = this.myDriver.hashCode();
            result2 = 31 * result2 + this.myVersion.hashCode();
            result2 = 31 * result2 + (this.myEditor != null ? this.myEditor.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator$MyDriverDownloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

