/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.options;

import com.intellij.application.options.CodeCompletionOptionsCustomSection;
import com.intellij.openapi.options.Configurable;
import com.intellij.sql.completion.options.SqlCodeCompletionOptionPanel;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class SqlCodeCompletionConfigurable
implements Configurable,
CodeCompletionOptionsCustomSection {
    private JBCheckBox myUseAliasInJoinCompletion;
    private JBCheckBox myAutoAliasTable;
    private JBCheckBox myInvertOnClauseOrder;
    private JBCheckBox mySuggestAliasNames;
    private JBTable myCustomMappingsTable;

    @Nullable
    public JComponent createComponent() {
        SqlCodeCompletionOptionPanel panel = new SqlCodeCompletionOptionPanel();
        this.myUseAliasInJoinCompletion = panel.getUseAliasesInCompletionJBCheckBox();
        this.myAutoAliasTable = panel.getAutoAliasTableJBCheckBox();
        this.myCustomMappingsTable = panel.getCustomAliasesJBTable();
        this.myInvertOnClauseOrder = panel.getInvertOrderOfOperandsInJoinOnJBCheckBox();
        this.mySuggestAliasNames = panel.getSuggestTableAliasNamesJBCheckBox();
        return panel.getPanel();
    }

    public boolean isModified() {
        SqlCodeCompletionSettings settings = SqlCodeCompletionSettings.getInstance();
        return settings.isUseAliasInJoinCompletion() != this.myUseAliasInJoinCompletion.isSelected() || settings.isAutoAliasTable() != this.myAutoAliasTable.isSelected() || settings.isInvertOrderInOnClause() != this.myInvertOnClauseOrder.isSelected() || settings.isSuggestAliasNames() != this.mySuggestAliasNames.isSelected() || !SqlCodeCompletionConfigurable.mapsIdentical(settings.getCustomMappings(), this.getMappingsFromUi());
    }

    private static boolean mapsIdentical(Map<String, String> mappings, Map<String, String> fromUi) {
        if (mappings.size() != fromUi.size()) {
            return false;
        }
        HashSet keys11 = ContainerUtil.newHashSet(mappings.keySet());
        HashSet keys12 = ContainerUtil.newHashSet(mappings.keySet());
        HashSet keys2 = ContainerUtil.newHashSet(fromUi.keySet());
        keys11.removeAll(keys2);
        if (keys11.size() != 0) {
            return false;
        }
        keys2.removeAll(keys12);
        if (keys2.size() != 0) {
            return false;
        }
        for (String key2 : keys12) {
            if (Objects.equals(mappings.get(key2), fromUi.get(key2))) continue;
            return false;
        }
        return true;
    }

    public void apply() {
        SqlCodeCompletionSettings settings = SqlCodeCompletionSettings.getInstance();
        settings.setUseAliasInJoinCompletion(this.myUseAliasInJoinCompletion.isSelected());
        settings.setAutoAliasTable(this.myAutoAliasTable.isSelected());
        settings.setInvertOrderInOnClause(this.myInvertOnClauseOrder.isSelected());
        settings.setSuggestAliasNames(this.mySuggestAliasNames.isSelected());
        settings.setCustomMappings(this.getMappingsFromUi());
    }

    private Map<String, String> getMappingsFromUi() {
        return ((SqlCodeCompletionOptionPanel.SqlAliasesTableModel)this.myCustomMappingsTable.getModel()).getMappings();
    }

    public void reset() {
        SqlCodeCompletionSettings settings = SqlCodeCompletionSettings.getInstance();
        this.myUseAliasInJoinCompletion.setSelected(settings.isUseAliasInJoinCompletion());
        this.myAutoAliasTable.setSelected(settings.isAutoAliasTable());
        this.myInvertOnClauseOrder.setSelected(settings.isInvertOrderInOnClause());
        this.mySuggestAliasNames.setSelected(settings.isSuggestAliasNames());
        this.myCustomMappingsTable.setModel((TableModel)new SqlCodeCompletionOptionPanel.SqlAliasesTableModel(settings.getCustomMappings()));
    }

    public void disposeUIResources() {
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return "SQL";
    }
}

