/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.SqlFlowGraphBuilder;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlInstructionVisitor;
import com.intellij.sql.dataFlow.instructions.SqlJumpInstruction;
import com.intellij.sql.dataFlow.instructions.SqlSubroutineDefinitionInstruction;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0006\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0002\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0002\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\r\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\u0002\u00a8\u0006\u000f"}, d2={"accept", "", "Lcom/intellij/sql/dataFlow/instructions/SqlFlowGraph;", "visitor", "Lcom/intellij/sql/dataFlow/instructions/SqlInstructionVisitor;", "buildFlowGraph", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "findExitPoints", "", "Lcom/intellij/sql/dataFlow/instructions/SqlInstruction;", "findUnreachableInstructions", "parentBuilders", "Lkotlin/sequences/Sequence;", "Lcom/intellij/sql/dataFlow/SqlFlowGraphBuilder;", "parentGraphs", "intellij.database.sql.impl"})
public final class FlowUtilKt {
    @NotNull
    public static final SqlFlowGraph buildFlowGraph(@NotNull SqlRoutineDefinition $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        DFABuildingVisitor dFABuildingVisitor = SqlImplUtil.getSqlDialectSafe((PsiElement)$receiver).createDFAVisitor();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dFABuildingVisitor), (String)"SqlImplUtil.getSqlDialec\u2026(this).createDFAVisitor()");
        DFABuildingVisitor visitor2 = dFABuildingVisitor;
        $receiver.accept((SqlVisitor)visitor2);
        return visitor2.getFlowGraph();
    }

    public static final void accept(@NotNull SqlFlowGraph $receiver, @NotNull SqlInstructionVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)visitor2, (String)"visitor");
        Iterable $receiver$iv = $receiver.getInstructions();
        for (Object element$iv : $receiver$iv) {
            SqlInstruction it = (SqlInstruction)element$iv;
            it.accept(visitor2);
        }
    }

    @NotNull
    public static final Collection<SqlInstruction> findUnreachableInstructions(@NotNull SqlFlowGraph $receiver) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        LinkedHashSet unprocessed = new LinkedHashSet($receiver.getInstructions());
        Stack stack = new Stack();
        stack.push((Object)$receiver.getEntryPoint());
        while (!(collection = (Collection)stack).isEmpty()) {
            SqlInstruction instruction2 = (SqlInstruction)stack.pop();
            if (!unprocessed.remove(instruction2)) continue;
            if (instruction2 instanceof SqlSubroutineDefinitionInstruction) {
                Collection collection2 = unprocessed;
                Iterable iterable = ((SqlSubroutineDefinitionInstruction)instruction2).getFlowGraph().getInstructions();
                CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
                stack.push((Object)((SqlSubroutineDefinitionInstruction)instruction2).getFlowGraph().getEntryPoint());
            }
            Iterable $receiver$iv = instruction2.getSuccessors();
            for (Object element$iv : $receiver$iv) {
                SqlInstruction it = (SqlInstruction)element$iv;
                stack.push((Object)it);
            }
        }
        return unprocessed;
    }

    @NotNull
    public static final Collection<SqlInstruction> findExitPoints(@NotNull SqlFlowGraph $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ArrayDeque<SqlInstruction> candidates = new ArrayDeque<SqlInstruction>();
        ArrayList result2 = new ArrayList();
        Collection collection = candidates;
        Iterable iterable = $receiver.getExitPoint().getPredecessors();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = candidates;
        iterable = $receiver.getErrorPoint().getPredecessors();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        while (!(collection = (Collection)candidates).isEmpty()) {
            SqlInstruction candidate = (SqlInstruction)candidates.poll();
            if (candidate instanceof SqlJumpInstruction) {
                Iterable $receiver$iv = candidate.getPredecessors();
                for (Object element$iv : $receiver$iv) {
                    SqlInstruction it = (SqlInstruction)element$iv;
                    candidates.offer(it);
                }
                continue;
            }
            iterable = result2;
            iterable.add(candidate);
        }
        return result2;
    }

    @NotNull
    public static final Sequence<SqlFlowGraphBuilder> parentBuilders(@NotNull SqlFlowGraphBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return SequencesKt.generateSequence((Object)$receiver, (Function1)parentBuilders.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<SqlFlowGraph> parentGraphs(@NotNull SqlFlowGraph $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return SequencesKt.generateSequence((Object)$receiver, (Function1)parentGraphs.1.INSTANCE);
    }
}

