/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.liveTemplates;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStatementContextType
extends TemplateContextType {
    @NotNull
    private final TemplateContextType myBaseContextType;

    protected SqlStatementContextType(@NotNull String dbmsStr, @NotNull TemplateContextType baseContextType) {
        if (dbmsStr == null) {
            SqlStatementContextType.$$$reportNull$$$0(0);
        }
        if (baseContextType == null) {
            SqlStatementContextType.$$$reportNull$$$0(1);
        }
        super("SQL_STATEMENT_" + dbmsStr, "SQL Statements", null);
        this.myBaseContextType = baseContextType;
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlStatementContextType.$$$reportNull$$$0(2);
        }
        return this.myBaseContextType.isInContext(file, offset) && SqlStatementContextType.isAtSqlStatementStart(file, offset);
    }

    @NotNull
    public TemplateContextType getBaseContextType() {
        TemplateContextType templateContextType = this.myBaseContextType;
        if (templateContextType == null) {
            SqlStatementContextType.$$$reportNull$$$0(3);
        }
        return templateContextType;
    }

    static boolean isAtSqlStatementStart(@NotNull PsiFile file, int offset) {
        PsiElement prevSibling;
        PsiElement parentParent;
        PsiElement par;
        PsiElement element2;
        if (file == null) {
            SqlStatementContextType.$$$reportNull$$$0(4);
        }
        if ((element2 = file.findElementAt(offset)) == null) {
            return false;
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
        if (statement != null && statement.getTextOffset() == element2.getTextOffset()) {
            return true;
        }
        PsiElement parent2 = SqlImplUtil.sqlParent(element2);
        if (!(parent2 instanceof PsiErrorElement)) {
            parent2 = element2;
        }
        if (parent2 instanceof LeafPsiElement && SqlImplUtil.getElementType(par = SqlImplUtil.sqlParent(parent2)) == SqlCompositeElementTypes.SQL_IDENTIFIER) {
            parent2 = par;
        }
        PsiElement psiElement = parentParent = parent2 == null ? null : SqlImplUtil.sqlParent(parent2);
        if (!(parentParent instanceof SqlFile || (parentParent instanceof SqlStatement || parentParent instanceof SqlExpression) && parentParent.getLastChild() == parent2)) {
            return false;
        }
        if (parentParent instanceof SqlStatement || parentParent instanceof SqlFile) {
            prevSibling = parent2.getPrevSibling();
            if ((prevSibling = SqlStatementContextType.enterDummyBlockIfNeeded(prevSibling)) == null) {
                return true;
            }
        } else {
            PsiElement par2 = parent2;
            while (par2 != null && par2.getPrevSibling() == null) {
                par2 = SqlImplUtil.sqlParent(par2);
            }
            PsiElement psiElement2 = prevSibling = par2 == null ? null : par2.getPrevSibling();
            if (prevSibling == null) {
                return false;
            }
        }
        while (prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling.getText().contains("\n")) {
                return true;
            }
            prevSibling = SqlStatementContextType.enterDummyBlockIfNeeded(prevSibling.getPrevSibling());
        }
        if (!(prevSibling instanceof LeafPsiElement)) {
            return false;
        }
        Language language = file.getLanguage();
        if (!(language instanceof SqlLanguageDialect)) {
            return false;
        }
        IElementType elementType = ((LeafPsiElement)prevSibling).getElementType();
        return ((SqlLanguageDialect)language).getStatementSeparators().contains(elementType);
    }

    @Nullable
    private static PsiElement enterDummyBlockIfNeeded(@Nullable PsiElement prevSibling) {
        while (SqlStatementContextType.isDummyBlock(prevSibling)) {
            prevSibling = prevSibling.getLastChild();
        }
        return prevSibling;
    }

    @Contract(value="null -> false")
    private static boolean isDummyBlock(@Nullable PsiElement psiElement) {
        return PsiUtilCore.getElementType((PsiElement)psiElement) == SqlElementTypes.SQL_DUMMY_BLOCK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsStr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseContextType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/liveTemplates/SqlStatementContextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/liveTemplates/SqlStatementContextType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseContextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInContext";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAtSqlStatementStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

