/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.intellij.openapi.project.Project;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.pivotal.PivotalTrackerRepository;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class PivotalTrackerRepositoryEditor
extends BaseRepositoryEditor<PivotalTrackerRepository> {
    private JTextField myProjectId;
    private JTextField myAPIKey;
    private JBLabel myProjectIDLabel;
    private JBLabel myAPIKeyLabel;

    public PivotalTrackerRepositoryEditor(Project project, PivotalTrackerRepository repository, Consumer<? super PivotalTrackerRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myUserNameText.setVisible(false);
        this.myUsernameLabel.setVisible(false);
        this.myPasswordText.setVisible(false);
        this.myPasswordLabel.setVisible(false);
        this.myProjectId.setText(repository.getProjectId());
        this.myAPIKey.setText(repository.getAPIKey());
        this.myUseHttpAuthenticationCheckBox.setVisible(false);
    }

    public void apply() {
        super.apply();
        ((PivotalTrackerRepository)this.myRepository).setProjectId(this.myProjectId.getText().trim());
        ((PivotalTrackerRepository)this.myRepository).setAPIKey(this.myAPIKey.getText().trim());
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectIDLabel = new JBLabel("Project ID:", 4);
        this.myProjectId = new JTextField();
        this.installListener(this.myProjectId);
        this.myAPIKeyLabel = new JBLabel("API Token:", 4);
        this.myAPIKey = new JTextField();
        this.installListener(this.myAPIKey);
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myProjectIDLabel, (JComponent)this.myProjectId).addLabeledComponent((JComponent)this.myAPIKeyLabel, (JComponent)this.myAPIKey).getPanel();
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectIDLabel.setAnchor(anchor);
        this.myAPIKeyLabel.setAnchor(anchor);
    }
}

