/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.ElementBase;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFileIconProvider
implements FileIconProvider {
    @Nullable
    public Icon getIcon(@NotNull VirtualFile virtualFile, @Iconable.IconFlags int flags, @Nullable Project project) {
        if (virtualFile == null) {
            PhpFileIconProvider.$$$reportNull$$$0(0);
        }
        if (project == null || virtualFile.getFileType() != PhpFileType.INSTANCE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(psiFile instanceof PhpFile)) {
            return null;
        }
        PhpFile file = (PhpFile)psiFile;
        Icon icon = PhpIcons.PHP_FILE;
        List classes = file.getTopLevelDefs().values().stream().filter(e -> e instanceof PhpClass).collect(Collectors.toList());
        if (classes.size() == 1) {
            PhpClass aClass = (PhpClass)classes.get(0);
            if (StringUtil.containsIgnoreCase((String)file.getName(), (String)aClass.getName())) {
                icon = aClass.getIcon();
            }
        }
        return ElementBase.createLayeredIcon((Iconable)psiFile, (Icon)icon, (int)ElementBase.transformFlags((PsiElement)psiFile, (int)flags));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/php/PhpFileIconProvider", "getIcon"));
    }
}

