/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpMissingBreakStatementInspection
extends PhpInspection {
    public static final String PROBLEM_DESCRIPTION = PhpBundle.message("inspection.missing.break.statement.problem", new Object[0]);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingBreakStatementInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpSwitch(final PhpSwitch switchStatement) {
                PhpCase[] cases;
                PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)switchStatement);
                if (scopeHolder == null) {
                    return;
                }
                final TextRange switchStatementTextRange = switchStatement.getTextRange();
                for (final PhpCase aCase : cases = switchStatement.getCases()) {
                    PhpStatementInstruction firstStatementInstruction;
                    Statement caseGroupStatement = aCase.getStatement();
                    Statement firstStatement = (Statement)PsiTreeUtil.findChildOfType((PsiElement)caseGroupStatement, Statement.class);
                    if (firstStatement == null || (firstStatementInstruction = PhpControlFlowUtil.getStatementInstruction(scopeHolder.getControlFlow(), firstStatement)) == null) continue;
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)firstStatementInstruction, false, new PhpInstructionProcessor(){

                        public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                            Statement curStatement = instruction.getStatement();
                            if (curStatement == switchStatement) {
                                return false;
                            }
                            TextRange curStatementTextRange = curStatement.getTextRange();
                            if (!aCase.getTextRange().contains(curStatementTextRange)) {
                                if (switchStatementTextRange.contains(curStatementTextRange)) {
                                    holder.registerProblem(aCase.getFirstChild(), PROBLEM_DESCRIPTION, new LocalQuickFix[0]);
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpMissingBreakStatementInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpMissingBreakStatementInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

