/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.inspections.exception.PhpExceptionAnalysisService;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpThrownExceptionsAnalyzer {
    private PhpThrownExceptionsAnalyzer() {
    }

    @NotNull
    public static Collection<String> filterNonThrowable(@NotNull PhpType exceptionClass, Project project) {
        if (exceptionClass == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(0);
        }
        Collection<String> collection = PhpThrownExceptionsAnalyzer.filterNonThrowable(exceptionClass.getTypes(), project);
        if (collection == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> filterNonThrowable(@NotNull Set<String> exceptions, @NotNull Project project) {
        if (exceptions == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(3);
        }
        List types = ContainerUtil.newSmartList();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (String type : exceptions) {
            if (!PhpThrownExceptionsAnalyzer.isException(type, index)) continue;
            types.add(type);
        }
        List list = types;
        if (list == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static boolean isException(@NotNull String fqn, @NotNull PhpIndex index) {
        if (fqn == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(5);
        }
        if (index == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(6);
        }
        return !PhpType.isNull((String)fqn) && !PhpType.isPrimitiveType((String)fqn) && (fqn.endsWith("Exception") && !index.getAnyByFQN(fqn).isEmpty() || PhpType.findSuper((String)"\\Throwable", (String)fqn, (PhpIndex)index));
    }

    @NotNull
    public static Set<PhpType> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(7);
        }
        Set<PhpType> set = PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, null);
        if (set == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public static Set<PhpType> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(9);
        }
        Set<PhpType> set = PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, thrownRange, thrownRange, true, false);
        if (set == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public static Set<PhpType> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange, boolean ignoreExceptions) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(11);
        }
        Set<PhpType> set = PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, thrownRange, thrownRange, ignoreExceptions, false);
        if (set == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public static Set<PhpType> getExceptionClasses(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean ignoreExceptions, boolean strictThrownRangeComparison) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(13);
        }
        THashSet results = ContainerUtil.newTroveSet();
        Project project = scopeHolder.getProject();
        PhpAnalysisConfiguration configuration = PhpAnalysisConfiguration.getInstance(project);
        int depth = configuration.getCallTreeAnalysisDepth();
        Set<String> thrownExceptions = PhpExceptionAnalysisService.getThrownExceptions(scopeHolder, depth, thrownRange, coughRange, strictThrownRangeComparison);
        Set<String> uncheckedExceptions = configuration.getUncheckedExceptions();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (String exception : PhpThrownExceptionsAnalyzer.filterNonThrowable(thrownExceptions, project)) {
            if (ignoreExceptions && !uncheckedExceptions.stream().noneMatch(uncheckedException -> PhpType.findSuper((String)uncheckedException, (String)exception, (PhpIndex)index))) continue;
            results.add(new PhpType().add(exception));
        }
        if (results.size() > 1) {
            results.remove(PhpType.EXCEPTION);
        }
        THashSet tHashSet = results;
        if (tHashSet == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(14);
        }
        return tHashSet;
    }

    @NotNull
    public static Set<Pair<TextRange, String>> getExceptionClassesWithRanges(@NotNull PhpScopeHolder scopeHolder, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scopeHolder == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(15);
        }
        Project project = scopeHolder.getProject();
        PhpAnalysisConfiguration configuration = PhpAnalysisConfiguration.getInstance(project);
        int depth = configuration.getCallTreeAnalysisDepth();
        Set<Pair<TextRange, String>> set = PhpExceptionAnalysisService.getThrownExceptionsWithRanges(scopeHolder, depth, thrownRange, coughRange, strictThrownRangeComparison);
        if (set == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(16);
        }
        return set;
    }

    public static Set<String> getDistinctExceptionNames(@NotNull PhpScopeHolder function, @NotNull Project project) {
        if (function == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(17);
        }
        if (project == null) {
            PhpThrownExceptionsAnalyzer.$$$reportNull$$$0(18);
        }
        TreeSet<String> exceptionNames = new TreeSet<String>();
        for (PhpType rawType : PhpThrownExceptionsAnalyzer.getExceptionClasses(function)) {
            for (String typeName : rawType.getTypesSorted()) {
                PhpPsiElement nsScope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)function);
                String exceptionName = PhpDocUtil.getTypePresentation(project, new PhpType().add(typeName), nsScope);
                exceptionNames.add(exceptionName);
            }
        }
        return exceptionNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpThrownExceptionsAnalyzer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpThrownExceptionsAnalyzer";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNonThrowable";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClassesWithRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterNonThrowable";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isException";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionClasses";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionClassesWithRanges";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDistinctExceptionNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

