/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpVariableDocDeclarationInstruction;
import com.jetbrains.php.codeInsight.dataFlow.PhpDFAMap;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUndefinedVariableInspection
extends PhpInspection {
    private static final InitializeVarQuickFix INITIALIZE_FIX = new InitializeVarQuickFix();
    public static final String INITIALIZE_FIX_NAME = INITIALIZE_FIX.getName();
    private static final CreateParameterQuickFix CREATE_PARAMETER_FIX = new CreateParameterQuickFix();
    public static final String CREATE_PARAMETER_FIX_NAME = CREATE_PARAMETER_FIX.getName();
    public static final AddToUseQuickFix ADD_TO_USE_QUICK_FIX = new AddToUseQuickFix();
    public static final String ADD_TO_USE_QUICK_FIX_NAME = ADD_TO_USE_QUICK_FIX.getName();
    public static final LocalQuickFix[] FIXES = new LocalQuickFix[]{INITIALIZE_FIX};
    public static final LocalQuickFix[] FIXES_AND_CREATE_PARAMETER_FIX = (LocalQuickFix[])ArrayUtil.append((Object[])FIXES, (Object)CREATE_PARAMETER_FIX);
    public static final LocalQuickFix[] ALL_FIXES = (LocalQuickFix[])ArrayUtil.append((Object[])FIXES_AND_CREATE_PARAMETER_FIX, (Object)ADD_TO_USE_QUICK_FIX);
    public boolean ENABLE_IN_FILE_SCOPE = true;
    public boolean REPORT_CAN_BE_UNDEFINED = true;
    public boolean IGNORE_INCLUDE = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                Parameter[] parameters;
                PhpUseList useList;
                Set predefined = null;
                if (function.isClosure() && (useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)) != null) {
                    List<Variable> variables = PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF);
                    for (Variable variable : variables) {
                        CharSequence variableName = variable.getNameCS();
                        if (StringUtil.isEmpty((CharSequence)variableName)) continue;
                        if (predefined == null) {
                            predefined = new THashSet();
                        }
                        predefined.add(variableName);
                    }
                }
                if ((parameters = function.getParameters()).length == 0) {
                    if (predefined == null) {
                        predefined = function.getPredefinedVariables();
                    }
                } else {
                    if (predefined == null) {
                        predefined = new THashSet();
                    }
                    for (Parameter parameter : parameters) {
                        predefined.add(parameter.getNameCS());
                    }
                }
                PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)function, predefined, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFile(PhpFile file) {
                if (PhpUndefinedVariableInspection.this.ENABLE_IN_FILE_SCOPE) {
                    PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)file, file.getPredefinedVariables(), holder, isOnTheFly);
                } else {
                    super.visitPhpFile(file);
                }
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)namespace, namespace.getPredefinedVariables(), holder, isOnTheFly);
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private void analyzeScope(final @NotNull PhpScopeHolder scopeHolder, final @NotNull Set<CharSequence> predefinedVariables, final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (scopeHolder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(2);
        }
        if (predefinedVariables == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(4);
        }
        final PhpControlFlow controlFlow = scopeHolder.getControlFlow();
        PhpControlFlowUtil.processPredecessors((PhpInstruction)controlFlow.getExitPoint(), false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (!access.isRead()) {
                    return true;
                }
                final CharSequence variableName = instruction.getVariableName();
                if (PhpLangUtil.equalsVariableNames("this", variableName)) {
                    return true;
                }
                PhpPsiElement anchor = instruction.getAnchor();
                if (PhpWorkaroundUtil.getArrayAccess(instruction).isWrite()) {
                    return true;
                }
                if (PhpUndefinedVariableInspection.isStaticFieldReference((PsiElement)anchor)) {
                    return true;
                }
                Project project = holder.getProject();
                if (scopeHolder instanceof PhpFile && anchor instanceof PhpTypedElement && !((PhpTypedElement)anchor).getType().global(project).filterUnknown().isEmpty()) {
                    return true;
                }
                final PhpDFAMap<PhpReachingDefinitionsDFAnalyzer.Result> dfaMap = PhpDFAMap.create(new MyDFAnalyzer());
                final Ref canBeDefined = new Ref((Object)false);
                final Ref canBeUndefined = new Ref((Object)false);
                PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                        return instruction.getResult();
                    }

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction curInstruction) {
                        if (PhpLangUtil.equalsVariableNames(variableName, curInstruction.getVariableName())) {
                            PhpAccessInstruction.Access curAccess = curInstruction.getAccess();
                            if (curAccess.isUnset()) {
                                canBeUndefined.set((Object)true);
                            } else {
                                if (curAccess.isLightRead()) {
                                    return true;
                                }
                                canBeDefined.set((Object)true);
                            }
                            return false;
                        }
                        return true;
                    }

                    public boolean processVariableDocDeclarationInstruction(PhpVariableDocDeclarationInstruction instruction) {
                        if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                            canBeDefined.set((Object)true);
                            return false;
                        }
                        return true;
                    }

                    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                        if (!PhpUndefinedVariableInspection.isPredefinedVariable(variableName, predefinedVariables)) {
                            canBeUndefined.set((Object)true);
                        } else {
                            canBeDefined.set((Object)true);
                        }
                        return true;
                    }

                    public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
                        if (PhpUndefinedVariableInspection.this.IGNORE_INCLUDE) {
                            return super.processIncludeInstruction(instruction);
                        }
                        canBeDefined.set((Object)true);
                        return false;
                    }

                    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                        PsiElement condition = instruction.getCondition();
                        if (condition == null) {
                            return true;
                        }
                        PhpReachingDefinitionsDFAnalyzer.Result dfaResult = (PhpReachingDefinitionsDFAnalyzer.Result)dfaMap.get(instruction);
                        return dfaResult.apply(variableName, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                    }
                });
                if (!((Boolean)canBeDefined.get()).booleanValue()) {
                    if (!PhpUndefinedVariableInspection.isReachableCode(instruction, controlFlow)) {
                        return true;
                    }
                    LocalQuickFix[] fixes = PhpUndefinedVariableInspection.getUndefinedFixes(scopeHolder, isOnTheFly);
                    ProblemHighlightType highlightType = PhpUndefinedVariableInspection.getUndefinedHighlightType(scopeHolder);
                    holder.registerProblem((PsiElement)anchor, PhpBundle.message("inspection.undefined.variable.problem1", new Object[0]), highlightType, fixes);
                } else if (((Boolean)canBeUndefined.get()).booleanValue() && PhpUndefinedVariableInspection.this.REPORT_CAN_BE_UNDEFINED) {
                    if (!PhpUndefinedVariableInspection.isReachableCode(instruction, controlFlow)) {
                        return true;
                    }
                    holder.registerProblem((PsiElement)anchor, PhpBundle.message("inspection.undefined.variable.problem2", new Object[0]), ProblemHighlightType.WEAK_WARNING, LocalQuickFix.EMPTY_ARRAY);
                }
                return true;
            }
        });
    }

    private static boolean isStaticFieldReference(@Nullable PsiElement element) {
        PsiElement parent;
        if (element instanceof Variable && (parent = element.getParent()) instanceof FieldReference) {
            List children = PhpPsiUtil.getChildren(parent, (Condition<? super PsiElement>)Variable.INSTANCEOF);
            if (children.size() == 2 && children.get(1) == element) {
                return !PhpPsiUtil.isOfType(((PsiElement)children.get(1)).getPrevSibling(), PhpTokenTypes.ARROW);
            }
            return false;
        }
        return false;
    }

    private static boolean isReachableCode(@NotNull PhpAccessVariableInstruction instruction, @NotNull PhpControlFlow controlFlow) {
        if (instruction == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(5);
        }
        if (controlFlow == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(6);
        }
        return PhpControlFlowUtil.isPredecessor((PhpInstruction)instruction, (PhpInstruction)controlFlow.getEntryPoint());
    }

    @NotNull
    private static LocalQuickFix[] getUndefinedFixes(@NotNull PhpScopeHolder scopeHolder, boolean isOnTheFly) {
        if (scopeHolder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(7);
        }
        if (!isOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                PhpUndefinedVariableInspection.$$$reportNull$$$0(8);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (scopeHolder instanceof Function) {
            if (((Function)scopeHolder).isClosure()) {
                if (ALL_FIXES == null) {
                    PhpUndefinedVariableInspection.$$$reportNull$$$0(9);
                }
                return ALL_FIXES;
            }
            if (FIXES_AND_CREATE_PARAMETER_FIX == null) {
                PhpUndefinedVariableInspection.$$$reportNull$$$0(10);
            }
            return FIXES_AND_CREATE_PARAMETER_FIX;
        }
        if (FIXES == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(11);
        }
        return FIXES;
    }

    @NotNull
    private static ProblemHighlightType getUndefinedHighlightType(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(12);
        }
        if (scopeHolder instanceof PhpFile) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (problemHighlightType == null) {
                PhpUndefinedVariableInspection.$$$reportNull$$$0(13);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR;
        if (problemHighlightType == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(14);
        }
        return problemHighlightType;
    }

    private static boolean isPredefinedVariable(@NotNull CharSequence variableName, @NotNull Set<CharSequence> predefinedVariables) {
        if (variableName == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(15);
        }
        if (predefinedVariables == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(16);
        }
        return PhpUndefinedVariableInspection.isPredefinedVariable(variableName) || predefinedVariables.contains(variableName);
    }

    private static boolean isPredefinedVariable(@NotNull CharSequence variableName) {
        if (variableName == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(17);
        }
        return PhpLangUtil.isSuperGlobal(variableName) || PhpLangUtil.isMagicPredefinedVariable(variableName);
    }

    private static boolean isCoalesceVariable(@Nullable PsiElement element) {
        if (element instanceof ArrayAccessExpression || element instanceof FieldReference || element instanceof Variable) {
            PsiElement parent = element.getParent();
            return PhpPsiUtil.isOfType(parent, PhpElementTypes.COALESCE_EXPRESSION) && parent instanceof BinaryExpression && ((BinaryExpression)parent).getLeftOperand() == element;
        }
        return false;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedVariables";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndefinedFixes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndefinedHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReachableCode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUndefinedFixes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUndefinedHighlightType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToUseQuickFix
    extends PhpQuickFixBase {
        private final String NAME = PhpBundle.message("quickfix.add.to.use", new Object[0]);

        private AddToUseQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.NAME;
            if (string == null) {
                AddToUseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddToUseQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddToUseQuickFix.$$$reportNull$$$0(2);
            }
            Variable variable = (Variable)descriptor.getPsiElement();
            PhpUseList parentUseList = (PhpUseList)PsiTreeUtil.getParentOfType((PsiElement)variable, PhpUseList.class, (boolean)true, (Class[])new Class[]{Function.class});
            Function function = parentUseList != null ? (Function)PsiTreeUtil.getParentOfType((PsiElement)parentUseList.getParent(), Function.class) : (Function)PsiTreeUtil.getParentOfType((PsiElement)variable, Function.class);
            assert (function != null);
            assert (function.isClosure());
            PhpUseList useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                PsiElement firstChild = useList.getChildren()[0];
                PsiElement openParen = PhpPsiUtil.getChildOfType((PsiElement)useList, PhpTokenTypes.chLPAREN);
                if (openParen != null && firstChild instanceof Variable) {
                    PsiElement comma = PhpPsiElementFactory.createComma(project);
                    comma = openParen.getParent().addAfter(comma, openParen);
                    Variable newUseParameter = PhpPsiElementFactory.createVariable(project, variable.getName(), true);
                    comma.getParent().addBefore((PsiElement)newUseParameter, comma);
                } else {
                    useList.replace((PsiElement)AddToUseQuickFix.createUseList(project, variable));
                }
            } else {
                PsiElement anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.chRPAREN);
                if (anchor == null) {
                    anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.chLPAREN);
                }
                if (anchor == null) {
                    anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.kwFUNCTION);
                }
                assert (anchor != null);
                PhpUseList phpUseList = AddToUseQuickFix.createUseList(project, variable);
                function.addAfter((PsiElement)phpUseList, anchor);
            }
        }

        @NotNull
        private static PhpUseList createUseList(@NotNull Project project, Variable variable) {
            if (project == null) {
                AddToUseQuickFix.$$$reportNull$$$0(3);
            }
            String useListString = "function() use($" + variable.getName() + ") {}";
            PhpUseList useList = PhpPsiElementFactory.createFromText(project, PhpUseList.class, useListString);
            assert (useList != null);
            PhpUseList phpUseList = useList;
            if (phpUseList == null) {
                AddToUseQuickFix.$$$reportNull$$$0(4);
            }
            return phpUseList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddToUseQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddToUseQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUseList";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createUseList";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CreateParameterQuickFix
    implements LocalQuickFix {
        private static final String NAME = PhpBundle.message("quickfix.create.parameter", new Object[0]);

        private CreateParameterQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = NAME;
            if (string == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            assert (element instanceof Variable);
            Variable variable = (Variable)element;
            if (!CreateParameterQuickFix.isAvailable(variable)) {
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                String title = PhpBundle.message("quickfix.cannot.apply.quick.fix", new Object[0]);
                String error = PhpBundle.message("quickfix.create.parameter.selected.function.method.has.usages", new Object[0]);
                if (editor != null) {
                    String errorHint = title + "\n" + error;
                    HintManager.getInstance().showErrorHint(editor, errorHint);
                } else {
                    Notifications.Bus.notify((Notification)new Notification("Cannot apply quick fix", title, error, NotificationType.WARNING), (Project)project);
                }
                return;
            }
            PhpUseList useList = (PhpUseList)PsiTreeUtil.getParentOfType((PsiElement)variable, PhpUseList.class);
            Function function = (Function)PsiTreeUtil.getParentOfType((PsiElement)variable, Function.class);
            if (useList != null) {
                function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)Function.INSTANCEOF);
            }
            assert (function != null);
            Parameter anchor = null;
            for (Parameter parameter : function.getParameters()) {
                if (parameter.getDefaultValue() != null) break;
                anchor = parameter;
            }
            Parameter newParameter = PhpPsiElementFactory.createParameter(project, variable.getName());
            if (anchor == null) {
                Parameter[] parameters = function.getParameters();
                if (parameters.length > 0) {
                    PsiElement comma = PhpPsiElementFactory.createComma(project);
                    comma = parameters[0].getParent().addBefore(comma, (PsiElement)parameters[0]);
                    comma.getParent().addBefore((PsiElement)newParameter, comma);
                } else {
                    ParameterList parameterList = (ParameterList)PsiTreeUtil.getChildOfType((PsiElement)function, ParameterList.class);
                    assert (parameterList != null);
                    parameterList.add((PsiElement)newParameter);
                }
            } else {
                PsiElement comma = PhpPsiElementFactory.createComma(project);
                if (anchor.isVariadic()) {
                    comma = anchor.getParent().addBefore(comma, (PsiElement)anchor);
                    comma.getParent().addBefore((PsiElement)newParameter, comma);
                } else {
                    comma = anchor.getParent().addAfter(comma, (PsiElement)anchor);
                    comma.getParent().addAfter((PsiElement)newParameter, comma);
                }
            }
        }

        private static boolean isAvailable(@NotNull Variable variable) {
            if (variable == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(3);
            }
            Function function = (Function)PsiTreeUtil.getParentOfType((PsiElement)variable, Function.class, (boolean)true);
            PhpUseList useList = (PhpUseList)PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)Function.INSTANCEOF);
            }
            if (function == null) {
                return false;
            }
            Query query = ReferencesSearch.search((PsiElement)function, (SearchScope)GlobalSearchScope.allScope((Project)function.getProject()));
            PsiReference functionReference = (PsiReference)query.findFirst();
            return functionReference == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$CreateParameterQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$CreateParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InitializeVarQuickFix
    implements LocalQuickFix {
        private InitializeVarQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Initialize with a value" == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(0);
            }
            return "Initialize with a value";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(2);
            }
            Variable variable = (Variable)descriptor.getPsiElement();
            StringBuilder builder = new StringBuilder();
            builder.append("$");
            builder.append(variable.getName());
            builder.append("=;");
            Statement statement = PhpCodeEditUtil.putStatementBefore((PsiElement)variable, PhpPsiElementFactory.createFromText(variable.getProject(), Statement.class, builder.toString()));
            PsiElement semicolon = PhpPsiUtil.getChildOfType((PsiElement)statement, PhpTokenTypes.opSEMICOLON);
            if (semicolon != null) {
                Navigatable openFileDescriptor = PsiNavigationSupport.getInstance().createNavigatable(project, statement.getContainingFile().getVirtualFile(), semicolon.getTextRange().getStartOffset());
                openFileDescriptor.navigate(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$InitializeVarQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$InitializeVarQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myReportCanBeUndefinedCheckBox;
        private JCheckBox myEnableInFileScopeCheckBox;
        private JCheckBox myIgnoreIncludeCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myReportCanBeUndefinedCheckBox.setSelected(PhpUndefinedVariableInspection.this.REPORT_CAN_BE_UNDEFINED);
            this.myReportCanBeUndefinedCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedVariableInspection.this.REPORT_CAN_BE_UNDEFINED = OptionsPanel.this.myReportCanBeUndefinedCheckBox.isSelected();
                }
            });
            this.myEnableInFileScopeCheckBox.setSelected(PhpUndefinedVariableInspection.this.ENABLE_IN_FILE_SCOPE);
            this.myEnableInFileScopeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedVariableInspection.this.ENABLE_IN_FILE_SCOPE = OptionsPanel.this.myEnableInFileScopeCheckBox.isSelected();
                }
            });
            this.myIgnoreIncludeCheckBox.setSelected(PhpUndefinedVariableInspection.this.IGNORE_INCLUDE);
            this.myIgnoreIncludeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUndefinedVariableInspection.this.IGNORE_INCLUDE = OptionsPanel.this.myIgnoreIncludeCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myReportCanBeUndefinedCheckBox = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.variable.option.description.report.can.be.undefined"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myEnableInFileScopeCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.variable.option.description.enable.in.file.scope"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myIgnoreIncludeCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.variable.option.description.ignore.include"));
            jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class MyDFAnalyzer
    extends PhpReachingDefinitionsDFAnalyzer {
        private MyDFAnalyzer() {
        }

        @Override
        @NotNull
        protected PhpReachingDefinitionsDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof PhpIsset) {
                PhpExpression[] variables;
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                for (PhpExpression expression : variables = ((PhpIsset)condition).getVariables()) {
                    if (!(expression instanceof Variable)) continue;
                    Variable variable = (Variable)expression;
                    CharSequence variableName = variable.getNameCS();
                    if (!result || StringUtil.isEmpty((CharSequence)variableName)) continue;
                    dfaResult.addDefined(variableName);
                }
                PhpReachingDefinitionsDFAnalyzer.Result result2 = dfaResult;
                if (result2 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(0);
                }
                return result2;
            }
            if (condition instanceof PhpEmpty) {
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                if (!result) {
                    PhpExpression[] variables;
                    for (PhpExpression expression : variables = ((PhpEmpty)condition).getVariables()) {
                        Variable variable;
                        CharSequence variableName;
                        if (!(expression instanceof Variable) || StringUtil.isEmpty((CharSequence)(variableName = (variable = (Variable)expression).getNameCS()))) continue;
                        dfaResult.addDefined(variableName);
                    }
                }
                PhpReachingDefinitionsDFAnalyzer.Result result3 = dfaResult;
                if (result3 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(1);
                }
                return result3;
            }
            if (result && condition instanceof Variable) {
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                Variable variable = (Variable)condition;
                CharSequence variableName = variable.getNameCS();
                if (!StringUtil.isEmpty((CharSequence)variableName)) {
                    dfaResult.addDefined(variableName);
                }
                PhpReachingDefinitionsDFAnalyzer.Result result4 = dfaResult;
                if (result4 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(2);
                }
                return result4;
            }
            if (result && PhpUndefinedVariableInspection.isCoalesceVariable(condition)) {
                final PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                condition.accept((PsiElementVisitor)new PhpElementVisitor(){

                    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                        PhpPsiElement value = expression.getValue();
                        if (value != null) {
                            value.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitPhpFieldReference(FieldReference fieldReference) {
                        PhpExpression reference = fieldReference.getClassReference();
                        if (reference != null) {
                            reference.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitPhpVariable(Variable variable) {
                        String variableName = variable.getName();
                        if (StringUtil.isNotEmpty((String)variableName)) {
                            dfaResult.addDefined(variableName);
                        }
                    }
                });
                PhpReachingDefinitionsDFAnalyzer.Result result5 = dfaResult;
                if (result5 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(3);
                }
                return result5;
            }
            PhpReachingDefinitionsDFAnalyzer.Result result6 = (PhpReachingDefinitionsDFAnalyzer.Result)super.performDFA(condition, result);
            if (result6 == null) {
                MyDFAnalyzer.$$$reportNull$$$0(4);
            }
            return result6;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$MyDFAnalyzer", "performDFA"));
        }
    }
}

