/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.generators;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAccessorsGenerator {
    public static final String PHP_SETTER_TEMPLATE_NAME = "PHP Setter Method";
    public static final String PHP_GETTER_TEMPLATE_NAME = "PHP Getter Method";
    public static final String PHP_FLUENT_SETTER_TEMPLATE_NAME = "PHP Fluent Setter Method";
    private static final String PHP_SETTER_QUICK_TEMPLATE = "/**\n * @return %TYPE_HINT%\n */\npublic function set%NAME%($%PARAM_NAME%){}";
    private static final String PHP_GETTER_QUICK_TEMPLATE = "/**\n * @param %TYPE_HINT% $%PARAM_NAME%\n */\npublic function %GET_OR_IS%%NAME%(){}";
    @Nullable
    private final PhpClass myTargetClass;
    @NotNull
    private final Field myField;

    public PhpAccessorsGenerator(@NotNull Field field) {
        if (field == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(0);
        }
        this.myField = field;
        this.myTargetClass = field.getContainingClass();
    }

    public PhpAccessorsGenerator(@NotNull PhpClass targetClass, @NotNull Field field) {
        if (targetClass == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(1);
        }
        if (field == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(2);
        }
        this.myTargetClass = targetClass;
        this.myField = field;
    }

    @NotNull
    private static String getQuickModeTemplate(@NotNull String template, @NotNull Properties properties) {
        if (template == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(4);
        }
        String templateText = PHP_SETTER_TEMPLATE_NAME.equals(template) ? PHP_SETTER_QUICK_TEMPLATE : PHP_GETTER_QUICK_TEMPLATE;
        for (Object property : properties.keySet()) {
            String name;
            if (!(property instanceof String) || !templateText.contains(name = (String)property)) continue;
            templateText = templateText.replace("%" + property + "%", properties.getProperty(name));
        }
        String string = templateText;
        if (string == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean namesEqual(@NotNull String original2, @NotNull String expected) {
        if (original2 == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(6);
        }
        if (expected == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(7);
        }
        String adjustedOriginal = original2.indexOf(95) >= 0 ? original2.replace("_", "") : original2;
        String adjustedExpected = expected.indexOf(95) >= 0 ? expected.replace("_", "") : expected;
        return adjustedOriginal.equalsIgnoreCase(adjustedExpected);
    }

    @NotNull
    public PhpAccessorMethodData[] createGetters(boolean quickMode) {
        PhpAccessorMethodData[] phpAccessorMethodDataArray = this.createAccessors(PHP_GETTER_TEMPLATE_NAME, PhpAccessorMethodData.Type.GETTER, quickMode);
        if (phpAccessorMethodDataArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(8);
        }
        return phpAccessorMethodDataArray;
    }

    @NotNull
    public PhpAccessorMethodData[] createSetters(boolean isFluent, boolean quickMode) {
        String templateToUse = !this.myField.getModifier().isStatic() && isFluent ? PHP_FLUENT_SETTER_TEMPLATE_NAME : PHP_SETTER_TEMPLATE_NAME;
        PhpAccessorMethodData[] phpAccessorMethodDataArray = this.createAccessors(templateToUse, isFluent ? PhpAccessorMethodData.Type.FLUENT_SETTER : PhpAccessorMethodData.Type.SETTER, quickMode);
        if (phpAccessorMethodDataArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(9);
        }
        return phpAccessorMethodDataArray;
    }

    @NotNull
    private PhpAccessorMethodData[] createAccessors(@NotNull String templateName, @NotNull PhpAccessorMethodData.Type type, boolean quickMode) {
        if (templateName == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(10);
        }
        if (type == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(11);
        }
        ArrayList<PhpAccessorMethodData> setters = new ArrayList<PhpAccessorMethodData>();
        PhpClass klass = this.myTargetClass;
        if (klass != null) {
            Properties attributes = this.getAccessMethodAttributes(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)this.myField), templateName);
            String methodTemplate = quickMode ? PhpAccessorsGenerator.getQuickModeTemplate(templateName, attributes) : PhpCodeUtil.getCodeTemplate(templateName, attributes, this.myField.getProject());
            PhpClass dummyClass = PhpCodeUtil.createClassFromMethodTemplate(klass, klass.getProject(), methodTemplate);
            if (dummyClass != null) {
                PhpDocComment currDocComment = null;
                for (PsiElement child = dummyClass.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof PhpDocComment) {
                        currDocComment = (PhpDocComment)child;
                        continue;
                    }
                    if (!(child instanceof Method)) continue;
                    setters.add(new PhpAccessorMethodData(this.myField, klass, currDocComment, (Method)child, type));
                    currDocComment = null;
                }
            }
        }
        PhpAccessorMethodData[] phpAccessorMethodDataArray = setters.toArray(new PhpAccessorMethodData[0]);
        if (phpAccessorMethodDataArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(12);
        }
        return phpAccessorMethodDataArray;
    }

    @NotNull
    public PhpAccessorMethodData[] createAccessors(boolean fluentSetters, boolean quickMode) {
        PhpAccessorMethodData[] getters = this.createGetters(quickMode);
        PhpAccessorMethodData[] setters = this.createSetters(fluentSetters, quickMode);
        PhpAccessorMethodData[] result = new PhpAccessorMethodData[getters.length + setters.length];
        System.arraycopy(getters, 0, result, 0, getters.length);
        System.arraycopy(setters, 0, result, getters.length, setters.length);
        if (result == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(13);
        }
        return result;
    }

    private Properties getAccessMethodAttributes(@Nullable PhpPsiElement scopeForUseOperator, String templateName) {
        Properties attributes = new Properties();
        String typeHint = this.fillAttributes(scopeForUseOperator, attributes, templateName);
        this.addTypeHintsAndReturnType(attributes, typeHint);
        return attributes;
    }

    @NotNull
    private String fillAttributes(@Nullable PhpPsiElement scopeForUseOperator, Properties attributes, String templateName) {
        String fieldName = this.myField.getName();
        String typeHint = PhpCodeUtil.getTypeHint(this.myField, scopeForUseOperator);
        String paramName = fieldName;
        paramName = StringUtil.trimStart((String)paramName, (String)"_");
        attributes.setProperty("FIELD_NAME", fieldName);
        attributes.setProperty("PARAM_NAME", paramName);
        String name = PhpCodeUtil.camelCaps(fieldName);
        boolean isBooleanWithIsPrefix = false;
        if (templateName.equals(PHP_GETTER_TEMPLATE_NAME) && name.startsWith("Is") && name.length() > 2 && Character.isUpperCase(name.toCharArray()[2])) {
            name = "i" + name.substring(1);
            isBooleanWithIsPrefix = true;
        }
        attributes.setProperty("NAME", name);
        attributes.setProperty("TYPE_HINT", typeHint);
        attributes.setProperty("STATIC", this.myField.getModifier().isStatic() ? "static" : "");
        PhpClass phpClass = this.myTargetClass;
        attributes.setProperty("CLASS_NAME", phpClass != null ? phpClass.getName() : "");
        attributes.setProperty("GET_OR_IS", "bool".equalsIgnoreCase(typeHint) ? (isBooleanWithIsPrefix ? "" : "is") : "get");
        String string = typeHint;
        if (string == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void addTypeHintsAndReturnType(Properties attributes, String typeHint) {
        boolean hasFeatureVoid;
        Project project = this.myField.getProject();
        if (PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS) && PhpAccessorsGenerator.isDocTypeConvertable(typeHint)) {
            attributes.setProperty("SCALAR_TYPE_HINT", PhpAccessorsGenerator.convertDocTypeToHint(project, typeHint));
        }
        if (hasFeatureVoid = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.RETURN_VOID)) {
            attributes.setProperty("VOID_RETURN_TYPE", "void");
        }
        if (PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.RETURN_TYPES) && PhpAccessorsGenerator.isDocTypeConvertable(typeHint)) {
            attributes.setProperty("RETURN_TYPE", PhpAccessorsGenerator.convertDocTypeToHint(project, typeHint));
        }
    }

    private static boolean isDocTypeConvertable(String typeHint) {
        return !typeHint.equalsIgnoreCase("mixed") && !typeHint.equalsIgnoreCase("static") && !typeHint.equalsIgnoreCase("true") && !typeHint.equalsIgnoreCase("false") && !typeHint.equalsIgnoreCase("null") && (!typeHint.contains("|") || PhpAccessorsGenerator.typeWithNull(typeHint));
    }

    private static boolean typeWithNull(String typeHint) {
        return typeHint.split(Pattern.quote("|")).length == 2 && typeHint.toUpperCase().contains("NULL");
    }

    private static String convertNullableType(Project project, String typeHint) {
        String[] split = typeHint.split(Pattern.quote("|"));
        boolean hasNullableTypeFeature = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.NULLABLES);
        if (split[0].equalsIgnoreCase("null")) {
            return (hasNullableTypeFeature ? "?" : "") + split[1];
        }
        return (hasNullableTypeFeature ? "?" : "") + split[0];
    }

    @NotNull
    private static String convertDocTypeToHint(Project project, String typeHint) {
        String hint = typeHint.contains("[]") ? "array" : typeHint;
        String string = hint = hint.contains("boolean") ? "bool" : hint;
        if (PhpAccessorsGenerator.typeWithNull(typeHint)) {
            hint = PhpAccessorsGenerator.convertNullableType(project, hint);
        }
        String string2 = hint;
        if (string2 == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    private String[] getPossibleAccessorMethodNames(@NotNull String templateName) {
        if (templateName == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(16);
        }
        HashSet<String> allNames = new HashSet<String>();
        String prefix = PHP_GETTER_TEMPLATE_NAME.equals(templateName) ? "get" : "set";
        allNames.add((prefix + this.myField.getName()).toUpperCase());
        FileTemplate currTemplate = FileTemplateManager.getInstance((Project)this.myField.getProject()).getCodeTemplate(templateName);
        if (currTemplate != null) {
            this.collectMethodNamesFromTemplate(currTemplate.getText(), 0, this.myField, allNames, templateName);
        }
        String[] stringArray = ArrayUtil.toStringArray(allNames);
        if (stringArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    private void collectMethodNamesFromTemplate(@NotNull String templateText, int startOffset, Field field, Set<String> result, String templateName) {
        int functionStart;
        if (templateText == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(18);
        }
        if ((functionStart = templateText.indexOf("function", startOffset)) < 0) {
            return;
        }
        int argListStart = templateText.indexOf(40, functionStart += "function".length());
        if (argListStart >= 0) {
            String methodName = templateText.substring(functionStart, argListStart).trim();
            Properties attributes = this.getAccessMethodAttributes(PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)field), templateName);
            for (String property : attributes.stringPropertyNames()) {
                String value = attributes.getProperty(property, "");
                methodName = methodName.replace("${" + property + "}", value);
            }
            methodName = methodName.replace("_", "").toUpperCase();
            result.add(methodName);
        }
        this.collectMethodNamesFromTemplate(templateText, functionStart, field, result, templateName);
    }

    @NotNull
    private Method[] findFieldAccessMethods(String templateName) {
        PhpClass klass = this.myTargetClass;
        ArrayList<Method> accessMethods = new ArrayList<Method>();
        boolean isStatic = this.myField.getModifier().isStatic();
        if (klass != null) {
            Method[] methods;
            String[] expectedNames = this.getPossibleAccessorMethodNames(templateName);
            block0: for (Method m : methods = klass.getOwnMethods()) {
                if (m.getAccess().isPrivate() || m.getModifier().isStatic() != isStatic) continue;
                String methodName = m.getName();
                for (String expectedName : expectedNames) {
                    if (!PhpAccessorsGenerator.namesEqual(methodName, expectedName)) continue;
                    accessMethods.add(m);
                    continue block0;
                }
            }
        }
        Method[] methodArray = accessMethods.toArray(Method.EMPTY);
        if (methodArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(19);
        }
        return methodArray;
    }

    @NotNull
    public Method[] findGetters() {
        Method[] methodArray = this.findFieldAccessMethods(PHP_GETTER_TEMPLATE_NAME);
        if (methodArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(20);
        }
        return methodArray;
    }

    @NotNull
    public Method[] findSetters() {
        Method[] methodArray = this.findFieldAccessMethods(PHP_SETTER_TEMPLATE_NAME);
        if (methodArray == null) {
            PhpAccessorsGenerator.$$$reportNull$$$0(21);
        }
        return methodArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/generators/PhpAccessorsGenerator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/generators/PhpAccessorsGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickModeTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetters";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fillAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDocTypeToHint";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleAccessorMethodNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findFieldAccessMethods";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findGetters";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSetters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQuickModeTemplate";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAccessors";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleAccessorMethodNames";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodNamesFromTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

