/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class ClassConstant {
    private static final ParserPart CONSTANT_PARSER_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            PsiBuilder.Marker classConstant = builder.mark();
            if (!builder.compare(PhpTokenTypes.tsKEYWORDS) && !builder.compare(PhpTokenTypes.IDENTIFIER)) {
                classConstant.drop();
                return PhpElementTypes.EMPTY_INPUT;
            }
            builder.advanceLexer();
            builder.match(PhpTokenTypes.opASGN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected("initializer"));
            }
            classConstant.done(PhpStubElementTypes.CLASS_CONST);
            return PhpStubElementTypes.CLASS_CONST;
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker classConstants = builder.mark();
        ClassMemberModifiers.parseConstantModifiers(builder);
        if (!builder.compareAndEat(PhpTokenTypes.kwCONST)) {
            classConstants.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, CONSTANT_PARSER_PART.parse(builder), CONSTANT_PARSER_PART, false);
        builder.match(PhpTokenTypes.opSEMICOLON);
        classConstants.done(PhpElementTypes.CLASS_CONSTANTS);
        return PhpStubElementTypes.CLASS_CONST;
    }
}

