/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.functions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;

public class ParameterList {
    private static final TokenSet ARRAY_OR_CALLABLE = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwARRAY, PhpTokenTypes.kwCALLABLE});
    private static final Parameter PARAMETER_PART = new Parameter(false);
    private static final Parameter DOC_PARAMETER_PART = new Parameter(true);

    public static IElementType parse(PhpPsiBuilder builder, boolean isDoc) {
        PsiBuilder.Marker parameterList = builder.mark();
        Parameter part = isDoc ? DOC_PARAMETER_PART : PARAMETER_PART;
        int result = ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, part.parse(builder), part, false);
        parameterList.done(PhpElementTypes.PARAMETER_LIST);
        return result > 0 ? PhpElementTypes.PARAMETER_LIST : PhpElementTypes.EMPTY_INPUT;
    }

    private static class Parameter
    implements ParserPart {
        private final boolean myIsDoc;

        Parameter(boolean isDoc) {
            this.myIsDoc = isDoc;
        }

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            if (builder.compare(PhpTokenTypes.chRPAREN)) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            PsiBuilder.Marker parameter = builder.mark();
            do {
                builder.compareAndEat(PhpTokenTypes.opQUEST);
                if (builder.compare(PhpTokenTypes.kwSTATIC)) {
                    PsiBuilder.Marker mark = builder.mark();
                    builder.advanceLexer();
                    mark.error(PhpParserErrors.unexpected(PhpTokenTypes.kwSTATIC));
                }
                if (ClassReference.parse(builder) == PhpElementTypes.EMPTY_INPUT) {
                    builder.compareAndEat(ARRAY_OR_CALLABLE);
                }
                if (!this.myIsDoc || !builder.compareAndEat(PhpTokenTypes.chLBRACKET)) continue;
                builder.match(PhpTokenTypes.chRBRACKET);
            } while (this.myIsDoc && builder.compareAndEat(PhpTokenTypes.opBIT_OR));
            builder.compareAndEat(PhpTokenTypes.opBIT_AND);
            builder.compareAndEat(PhpTokenTypes.opVARIADIC);
            if (builder.compareAndEat(PhpTokenTypes.DOLLAR)) {
                builder.error(PhpParserErrors.expected(PhpTokenTypes.VARIABLE));
            } else if (!builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
                builder.error(PhpParserErrors.expected(PhpTokenTypes.VARIABLE));
                builder.compareAndEat(PhpTokenTypes.IDENTIFIER);
            }
            if (builder.compare(PhpTokenTypes.opASGN)) {
                builder.advanceLexer();
                PsiBuilder.Marker defaultValue = builder.mark();
                if (Expression.parse(builder) == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected("default value"));
                }
                defaultValue.done(PhpElementTypes.PARAMETER_DEFAULT_VALUE);
            }
            parameter.done(PhpStubElementTypes.PARAMETER);
            return PhpStubElementTypes.PARAMETER;
        }
    }
}

