/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolProjectConfiguration<C extends QualityToolConfiguration> {
    public static final String DEFAULT_INTERPRETER_CONFIGURATION_ID = "DEFAULT_INTERPRETER";
    private static final String DEFAULT_INTERPRETER_IS_NOT_FOUND = "quality.tool.configuration.default.interpreter.is.not.found";
    private static final String CONFIGURATION_IS_NOT_FOUND = "quality.tool.configuration.for.interpreter.is.not.found";
    private String mySelectedConfigurationId = "Local";

    public String getSelectedConfigurationId() {
        return this.mySelectedConfigurationId;
    }

    public void setSelectedConfigurationId(String selectedConfigurationId) {
        this.mySelectedConfigurationId = selectedConfigurationId;
    }

    public static boolean isByDefaultInterpreter(@Nullable String configurationId) {
        return DEFAULT_INTERPRETER_CONFIGURATION_ID.equals(configurationId);
    }

    @Nullable
    public C findSelectedConfiguration(@NotNull Project project) throws QualityToolValidationException {
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(0);
        }
        return this.findConfiguration(project, this.getSelectedConfigurationId());
    }

    @Nullable
    public C findConfiguration(@NotNull Project project, @Nullable String configurationId) throws QualityToolValidationException {
        C configuration;
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(1);
        }
        C c = configuration = QualityToolProjectConfiguration.isByDefaultInterpreter(configurationId) ? this.findConfigurationByInterpreter(project) : this.findConfigurationById(configurationId, project);
        if (configuration == null) {
            throw new QualityToolValidationException(PhpBundle.message("quality.tool.configuration.can.not.find.configuration.by.id", this.getQualityToolName(), configurationId));
        }
        String error = this.validate(project, configuration);
        if (StringUtil.isNotEmpty((String)error)) {
            throw new QualityToolValidationException(error);
        }
        return configuration;
    }

    @NotNull
    private C findConfigurationByInterpreter(@NotNull Project project) throws QualityToolValidationException {
        PhpInterpreter interpreter;
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(2);
        }
        if ((interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter()) == null) {
            throw new QualityToolValidationException(PhpBundle.message(DEFAULT_INTERPRETER_IS_NOT_FOUND, this.getQualityToolName()));
        }
        C configuration = this.getConfigurationManager(project).getConfigurationByInterpreter(interpreter);
        if (configuration == null) {
            throw new QualityToolValidationException(PhpBundle.message(CONFIGURATION_IS_NOT_FOUND, this.getQualityToolName(), interpreter.getName()));
        }
        C c = configuration;
        if (c == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(3);
        }
        return c;
    }

    @Nullable
    public C findConfigurationById(@Nullable String configurationId, @NotNull Project project) {
        if (project == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(4);
        }
        return (C)((QualityToolConfiguration)ContainerUtil.find(this.getConfigurationManager(project).getAllSettings(), config -> StringUtil.equals((CharSequence)configurationId, (CharSequence)config.getId())));
    }

    @Nullable
    private String validate(@Nullable Project project, @NotNull C configuration) {
        PhpInterpreter interpreter;
        if (configuration == null) {
            QualityToolProjectConfiguration.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)configuration.getToolPath())) {
            return PhpBundle.message("quality.tool.configuration.tool.path.is.empty", this.getQualityToolName());
        }
        String interpreterId = configuration.getInterpreterId();
        if (StringUtil.isNotEmpty((String)interpreterId) && (interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId)) == null) {
            return PhpBundle.message("quality.tool.configuration.interpreter.is.undefined", this.getQualityToolName());
        }
        return null;
    }

    @NotNull
    protected abstract String getQualityToolName();

    @NotNull
    protected abstract QualityToolConfigurationManager<C> getConfigurationManager(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolProjectConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolProjectConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationByInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSelectedConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationByInterpreter";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationById";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

