/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.ui.PhpDebuggerLabel;
import com.jetbrains.php.ui.PhpMutableDebuggerComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class PhpCompositeDebuggerComponent
extends JComponent {
    private String myPreviousSelectedDebugger;
    private PhpDebuggerLabel mySingleDebuggerLabel;
    private PhpMutableDebuggerComboBox myMultipleDebuggersComboBox;
    private JPanel myMainPanel;

    public PhpCompositeDebuggerComponent() {
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.mySingleDebuggerLabel = new PhpDebuggerLabel();
        this.mySingleDebuggerLabel.setDebugger(null, null);
        this.myMultipleDebuggersComboBox = new PhpMutableDebuggerComboBox();
        Font font = this.myMultipleDebuggersComboBox.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.myMultipleDebuggersComboBox.getFontMetrics(font);
            int width = fontMetrics.charWidth('a') * 18;
            this.myMultipleDebuggersComboBox.setMinimumSize(new Dimension(width, this.myMultipleDebuggersComboBox.getHeight()));
        }
        this.myMultipleDebuggersComboBox.setVisible(false);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void reset(@Nullable PhpInfo info) {
        if (info == null || info.getDebuggers().isEmpty()) {
            this.setSingleDebugger(null, null);
        } else if (info.getDebuggers().size() == 1) {
            PhpDebuggerInfo debugger = info.getDebuggers().get(0);
            this.setSingleDebugger(debugger.getDebugger(), debugger.getDebuggerVersion());
            this.myPreviousSelectedDebugger = this.mySingleDebuggerLabel.getDebuggerId();
        } else {
            this.myMultipleDebuggersComboBox.updateAvailableItems(info, this.myPreviousSelectedDebugger);
            this.myMultipleDebuggersComboBox.setVisible(true);
            this.mySingleDebuggerLabel.setVisible(false);
        }
    }

    private void setSingleDebugger(@Nullable String debuggerName, @Nullable String version) {
        this.mySingleDebuggerLabel.setDebugger(debuggerName, version);
        this.mySingleDebuggerLabel.setVisible(true);
        this.myMultipleDebuggersComboBox.setVisible(false);
    }

    public String getSelectedDebuggerId() {
        this.myPreviousSelectedDebugger = this.findSelectedDebuggerId();
        return this.myPreviousSelectedDebugger;
    }

    private String findSelectedDebuggerId() {
        if (this.myMultipleDebuggersComboBox.isVisible()) {
            return this.myMultipleDebuggersComboBox.getSelectedDebuggerId();
        }
        return this.mySingleDebuggerLabel.getDebuggerId();
    }

    public void setPreviouslySelectedDebugger(@Nullable String debuggerId) {
        this.myPreviousSelectedDebugger = debuggerId;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        PhpDebuggerLabel phpDebuggerLabel = this.mySingleDebuggerLabel;
        jPanel.add((Component)((Object)phpDebuggerLabel), new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        PhpMutableDebuggerComboBox phpMutableDebuggerComboBox = this.myMultipleDebuggersComboBox;
        jPanel.add((Component)phpMutableDebuggerComboBox, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

