/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeCounter
implements ChangeList.Listener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ChangeCounter");
    private static final Key<ChangeCounter> ourKey = Key.create((String)"ChangeCounter");
    private final MergeList myMergeList;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myChangeCounter = 0;
    private int myConflictCounter = 0;

    private ChangeCounter(MergeList mergeList) {
        this.myMergeList = mergeList;
        this.myMergeList.addListener(this);
        this.updateCounters();
    }

    @Override
    public void onChangeApplied(@NotNull ChangeList source) {
        if (source == null) {
            ChangeCounter.$$$reportNull$$$0(0);
        }
        this.updateCounters();
    }

    @Override
    public void onChangeRemoved(@NotNull ChangeList source) {
        if (source == null) {
            ChangeCounter.$$$reportNull$$$0(1);
        }
        this.updateCounters();
    }

    public void addListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(Listener listener2) {
        this.myListeners.remove(listener2);
    }

    private void updateCounters() {
        int conflictCounter = 0;
        int changeCounter = 0;
        Iterator<Change> allChanges = this.myMergeList.getAllChanges();
        while (allChanges.hasNext()) {
            Change change = allChanges.next();
            if (MergeList.NOT_CONFLICTS.value((Object)change)) {
                ++changeCounter;
                continue;
            }
            ++conflictCounter;
        }
        if (this.myChangeCounter != changeCounter || this.myConflictCounter != conflictCounter) {
            this.myChangeCounter = changeCounter;
            this.myConflictCounter = conflictCounter;
            this.fireCountersChanged();
        }
    }

    private void fireCountersChanged() {
        for (Listener listener2 : this.myListeners) {
            listener2.onCountersChanged(this);
        }
    }

    public int getChangeCounter() {
        return this.myChangeCounter;
    }

    public int getConflictCounter() {
        return this.myConflictCounter;
    }

    public static ChangeCounter getOrCreate(MergeList mergeList) {
        ChangeCounter data = mergeList.getUserData(ourKey);
        if (data == null) {
            data = new ChangeCounter(mergeList);
            mergeList.putUserData(ourKey, data);
        }
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "source";
        objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/ChangeCounter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onChangeApplied";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onChangeRemoved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void onCountersChanged(@NotNull ChangeCounter var1);
    }
}

