/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNodeDescriptor
extends NodeDescriptor {
    private FileElement myFileElement;
    private final Icon myOriginalIcon;
    private final String myComment;

    public FileNodeDescriptor(Project project, @NotNull FileElement element, NodeDescriptor parentDescriptor, Icon closedIcon, String name, String comment) {
        if (element == null) {
            FileNodeDescriptor.$$$reportNull$$$0(0);
        }
        super(project, parentDescriptor);
        this.myOriginalIcon = closedIcon;
        this.myComment = comment;
        this.myFileElement = element;
        this.myName = name;
    }

    public boolean update() {
        VirtualFile file2;
        boolean changed = false;
        if (this.myName == null || this.myComment == null) {
            String newName = this.myFileElement.toString();
            if (!newName.equals(this.myName)) {
                changed = true;
            }
            this.myName = newName;
        }
        if ((file2 = this.myFileElement.getFile()) == null) {
            return true;
        }
        this.setIcon(this.myOriginalIcon);
        if (this.myFileElement.isHidden()) {
            this.setIcon(IconLoader.getTransparentIcon((Icon)this.getIcon()));
        }
        this.myColor = this.myFileElement.isHidden() ? SimpleTextAttributes.DARK_TEXT.getFgColor() : null;
        return changed;
    }

    @NotNull
    public final FileElement getElement() {
        FileElement fileElement = this.myFileElement;
        if (fileElement == null) {
            FileNodeDescriptor.$$$reportNull$$$0(1);
        }
        return fileElement;
    }

    protected final void setElement(FileElement descriptor) {
        this.myFileElement = descriptor;
    }

    public String getComment() {
        return this.myComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileNodeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileNodeDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

