/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxIncludePathReferenceProvider
extends PsiReferenceProvider
implements CustomizableReferenceProvider {
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)element;
            String valueString = attributeValue.getValue();
            if (valueString.indexOf(63) >= 0) {
                PsiReference[] psiReferenceArray = this.getReferencesByString(valueString.substring(0, valueString.indexOf(63)), (PsiElement)attributeValue, 1);
                if (psiReferenceArray == null) {
                    JspxIncludePathReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
            PsiReference[] psiReferenceArray = this.getReferencesByString(valueString, (PsiElement)attributeValue, 1);
            if (psiReferenceArray == null) {
                JspxIncludePathReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlTagValue value = tag.getValue();
            String text = value.getText();
            String trimmedText = text.trim();
            PsiReference[] psiReferenceArray = this.getReferencesByString(trimmedText, (PsiElement)tag, value.getTextRange().getStartOffset() + text.indexOf(trimmedText) - element.getTextOffset());
            if (psiReferenceArray == null) {
                JspxIncludePathReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    private PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(6);
        }
        PsiReference[] psiReferenceArray = JspxIncludePathReferenceProvider.getFileReferencesFromString(str, position, offsetInPosition, this);
        if (psiReferenceArray == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getFileReferencesFromString(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        if (position == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(8);
        }
        return JspxIncludePathReferenceProvider.getFileReferenceSet(str, position, offsetInPosition, provider).getAllReferences();
    }

    public static FileReferenceSet getFileReferenceSet(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        if (position == null) {
            JspxIncludePathReferenceProvider.$$$reportNull$$$0(9);
        }
        return new FileReferenceSet(str, position, offsetInPosition, provider, true){

            @Override
            protected boolean useIncludingFileAsContext() {
                return false;
            }
        };
    }

    @Override
    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Override
    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileReferencesFromString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileReferenceSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

