/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilterDescendantVirtualFileConvertible;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.AbstractP4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionMapper;

public class SingletonConnection
extends AbstractP4Connection
implements PerforceConnectionMapper {
    private static final Key<SingletonConnection> KEY_IN_PROJECT = new Key("Connection per project");
    public static final ConnectionId SINGLETON_CONNECTION_ID = new ConnectionId();
    public static final File CURR_DIR = new File(".");
    private final PerforceSettings mySettings;
    private final Project myProject;

    private SingletonConnection(Project project) {
        this(project, PerforceSettings.getSettings(project));
    }

    public SingletonConnection(Project project, PerforceSettings settings) {
        this.myProject = project;
        this.mySettings = settings;
    }

    public static SingletonConnection getInstance(Project project) {
        SingletonConnection result = (SingletonConnection)project.getUserData(KEY_IN_PROJECT);
        if (result == null) {
            result = new SingletonConnection(project);
            project.putUserData(KEY_IN_PROJECT, (Object)result);
        }
        return result;
    }

    @Override
    public void runP4Command(PerforcePhysicalConnectionParametersI parameters, String[] p4args, ExecResult retVal, @Nullable StringBuffer inputStream) {
        this.runP4CommandImpl(parameters, this.mySettings.getConnectArgs(), p4args, retVal, inputStream);
    }

    @Override
    @NotNull
    public File getWorkingDirectory() {
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)PerforceVcs.getInstance(this.myProject));
        File file = roots.length > 0 ? VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]) : CURR_DIR;
        if (file == null) {
            SingletonConnection.$$$reportNull$$$0(0);
        }
        return file;
    }

    @Override
    @NotNull
    public ConnectionKey getConnectionKey() {
        ConnectionKey connectionKey = new ConnectionKey(this.mySettings.port, this.mySettings.client, this.mySettings.user);
        if (connectionKey == null) {
            SingletonConnection.$$$reportNull$$$0(1);
        }
        return connectionKey;
    }

    @Override
    public ConnectionId getId() {
        return SINGLETON_CONNECTION_ID;
    }

    @Override
    public boolean handlesFile(File file) {
        return true;
    }

    @Override
    public P4Connection getConnection(@NotNull VirtualFile file) {
        if (file == null) {
            SingletonConnection.$$$reportNull$$$0(2);
        }
        return this;
    }

    @Override
    public Map<VirtualFile, P4Connection> getAllConnections() {
        Project project = this.mySettings.getProject();
        List files = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcsWithoutFiltering((AbstractVcs)PerforceVcs.getInstance(project));
        new FilterDescendantVirtualFileConvertible(Function.identity(), (Comparator)FilePathComparator.getInstance()).doFilter(files);
        HashMap<VirtualFile, P4Connection> map = new HashMap<VirtualFile, P4Connection>();
        for (VirtualFile file : files) {
            map.put(file, this);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/SingletonConnection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/SingletonConnection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

