/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;

public class GeneralCucumberParamsEditor
implements PanelWithAnchor {
    private JRadioButton myAllInFolderRB;
    private JBLabel myCucumberJBLabel;
    private JRadioButton myTestScriptRB;
    private LabeledComponent myFeaturesFolderComponent;
    private LabeledComponent myFeatureFileComponent;
    private LabeledComponent myFilterElementNameComponent;
    private JBLabel myFakeLabel1;
    private LabeledComponent myFilterTagsComponent;
    private JBLabel myFakeLabel2;
    private LabeledComponent myRunnerOptionsComponent;
    private JPanel myContentPane;
    private TextFieldWithBrowseButton myFeaturesFolderTextField;
    private TextFieldWithBrowseButton myFeatureFileTextField;
    private JTextField myFilterElementNameTextField;
    private JTextField myFilterTagsTextField;
    private RawCommandLineEditor myRunnerOptionsEditor;
    private JComponent myAnchor;
    private final Project myProject;

    public GeneralCucumberParamsEditor(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initComponents();
        this.setAnchor((JComponent)this.myFilterElementNameComponent.getLabel());
    }

    public JPanel getMainPanel() {
        return this.myContentPane;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myCucumberJBLabel.setAnchor(anchor);
        this.myFeatureFileComponent.setAnchor(anchor);
        this.myFeaturesFolderComponent.setAnchor(anchor);
        this.myFilterElementNameComponent.setAnchor(anchor);
        this.myFilterTagsComponent.setAnchor(anchor);
        this.myRunnerOptionsComponent.setAnchor(anchor);
        this.myFakeLabel1.setAnchor(anchor);
        this.myFakeLabel2.setAnchor(anchor);
    }

    private void createUIComponents() {
        Ref runnerOptionsEditorRef = new Ref();
        this.myRunnerOptionsComponent = RunConfigurationUIUtil.createRunnerOptionsComponent((Ref)runnerOptionsEditorRef);
        this.myRunnerOptionsEditor = (RawCommandLineEditor)runnerOptionsEditorRef.get();
        Ref testsFolderTextFieldWrapper = new Ref();
        this.myFeaturesFolderComponent = RunConfigurationUIUtil.createTestFolderComponent((Ref)testsFolderTextFieldWrapper);
        this.myFeaturesFolderTextField = (TextFieldWithBrowseButton)testsFolderTextFieldWrapper.get();
        Ref testScriptTextFieldWrapper = new Ref();
        String specFileTitle = RBundle.message((String)"rspec.run.configuration.messages.script.path");
        this.myFeatureFileComponent = RunConfigurationUIUtil.createScriptPathComponent((Ref)testScriptTextFieldWrapper, (String)specFileTitle);
        this.myFeatureFileTextField = (TextFieldWithBrowseButton)testScriptTextFieldWrapper.get();
        Ref filterElementNameTextFieldRef = new Ref();
        String filterElementNameLabel = RBundle.message((String)"cucumber.run.configuration.tests.dialog.components.filter.elements");
        this.myFilterElementNameComponent = RunConfigurationUIUtil.createTextFieldLabeledComponent((Ref)filterElementNameTextFieldRef, (String)filterElementNameLabel);
        this.myFilterElementNameTextField = (JTextField)filterElementNameTextFieldRef.get();
        Ref filterTagsNameTextFieldWrapper = new Ref();
        String filterTagsNameLabel = RBundle.message((String)"cucumber.run.configuration.tests.dialog.components.filter.tags");
        this.myFilterTagsComponent = RunConfigurationUIUtil.createTextFieldLabeledComponent((Ref)filterTagsNameTextFieldWrapper, (String)filterTagsNameLabel);
        this.myFilterTagsTextField = (JTextField)filterTagsNameTextFieldWrapper.get();
    }

    public String getFeaturesFolderPath() {
        return FileUtil.toSystemIndependentName((String)this.myFeaturesFolderTextField.getText().trim());
    }

    public void setFeaturesFolderPath(String path) {
        this.myFeaturesFolderTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path)));
    }

    public String getFeaturesFilePath() {
        return FileUtil.toSystemIndependentName((String)this.myFeatureFileTextField.getText().trim());
    }

    public void setFeatureFilePath(String path) {
        this.myFeatureFileTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path)));
    }

    public String getTagsFilters() {
        return this.myFilterTagsTextField.getText().trim();
    }

    public void setTagsFilter(String tagsLine) {
        this.myFilterTagsTextField.setText(tagsLine);
    }

    public String getFeatureElementNameFilter() {
        return this.myFilterElementNameTextField.getText().trim();
    }

    public void setFeatureElementNameFilter(String namePart) {
        this.myFilterElementNameTextField.setText(namePart);
    }

    public String getRunnerOptions() {
        return this.myRunnerOptionsEditor.getText().trim();
    }

    public void setRunnerOptions(String specArgs) {
        this.myRunnerOptionsEditor.setText(specArgs);
    }

    public AbstractRubyTestsRunConfigurationParams.TestType getTestType() {
        if (this.myAllInFolderRB.isSelected()) {
            return AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER;
        }
        return AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT;
    }

    public void setTestType(@NotNull AbstractRubyTestsRunConfigurationParams.TestType testType) {
        if (testType == null) {
            GeneralCucumberParamsEditor.$$$reportNull$$$0(0);
        }
        this.myFeatureFileComponent.setEnabled(true);
        switch (testType) {
            case ALL_IN_FOLDER: {
                this.myAllInFolderRB.setSelected(true);
                this.myFeaturesFolderComponent.setEnabled(true);
                this.myFeatureFileComponent.setEnabled(false);
                break;
            }
            case TEST_SCRIPT: {
                this.myTestScriptRB.setSelected(true);
                this.myFeaturesFolderComponent.setEnabled(false);
                this.myFeatureFileComponent.setEnabled(true);
            }
        }
    }

    private void initComponents() {
        String title = RBundle.message((String)"run.configuration.messages.select.folder.path");
        RunConfigurationUIUtil.addFolderChooser((String)title, (TextFieldWithBrowseButton)this.myFeaturesFolderTextField, (Project)this.myProject);
        title = RBundle.message((String)"run.configuration.messages.select.ruby.script.path");
        RunConfigurationUIUtil.addFileChooser((String)title, (TextFieldWithBrowseButton)this.myFeatureFileTextField, (Project)this.myProject);
        ActionListener testTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralCucumberParamsEditor.this.setTestType(GeneralCucumberParamsEditor.this.getTestType());
            }
        };
        this.myAllInFolderRB.addActionListener(testTypeListener);
        this.myTestScriptRB.addActionListener(testTypeListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testType", "org/jetbrains/plugins/ruby/cucumber/run/GeneralCucumberParamsEditor", "setTestType"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JRadioButton jRadioButton;
        JBLabel jBLabel3;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAllInFolderRB = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.run.configuration.tests.dialog.rb.allInFolder"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCucumberJBLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.run.configuration.tests.form.testtype.title"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestScriptRB = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.run.configuration.messages.feature.path"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        LabeledComponent labeledComponent = this.myFeaturesFolderComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.run.configuration.tests.dialog.components.folder"));
        jPanel.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent2 = this.myFeatureFileComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.run.configuration.messages.script.path"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent labeledComponent3 = this.myFilterElementNameComponent;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.run.configuration.tests.dialog.components.filter.elements"));
        jPanel3.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel4.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel4.setText("Only execute the feature elements which match part of the given name.");
        jPanel3.add((Component)jBLabel4, new GridConstraints(1, 1, 1, 1, 9, 0, 4, 0, null, null, null, 1));
        this.myFakeLabel1 = jBLabel2 = new JBLabel();
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent labeledComponent4 = this.myFilterTagsComponent;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("cucumber.run.configuration.tests.dialog.components.filter.tags"));
        jPanel4.add((Component)labeledComponent4, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel5.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel5.setText("E.g.: '@tag1,@tag2,~@excluded_tag'");
        jPanel4.add((Component)jBLabel5, new GridConstraints(1, 1, 1, 1, 9, 0, 4, 0, null, null, null, 1));
        this.myFakeLabel2 = jBLabel = new JBLabel();
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        LabeledComponent labeledComponent5 = this.myRunnerOptionsComponent;
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText(ResourceBundle.getBundle("org/jetbrains/plugins/ruby/RBundle").getString("run.configuration.messages.runner.options"));
        jPanel.add((Component)labeledComponent5, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

