/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.Topic;
import icons.RubyIcons;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurableUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkLoadPathInitializer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemData;
import org.jetbrains.plugins.ruby.version.management.system.RubySystemVersionManagerHandler;

public class RubySdkType
extends SdkType {
    public static final Topic<SdkPathsInitializedListener> SDK_PATHS_INITIALIZED_TOPIC;
    @NonNls
    public static final String GEMS_SUBDIR = "/gems";
    @NonNls
    public static final String IRON_RUBY_DEFAULT_INTERPRETER_NAME = "ir";
    @NonNls
    public static final String MAGLEV_INTERPRETER_NAME = "maglev-ruby";
    protected static final Logger LOG;
    public static final NullableConsumer<String> DEFAULT_SDK_VALIDATION_CALLBACK;
    @NonNls
    private static final String[] h;
    @NonNls
    private static final String[] d;
    @NonNls
    private static final String n = "puts $:";
    @NonNls
    private static final String l = "print RUBY_VERSION";
    @NonNls
    private static final String c = ".jar";
    @NonNls
    private static final String m = "RUBY_SDK";
    @NonNls
    private static final String g = "ruby";
    @NonNls
    private static final String b = "ruby";
    @NonNls
    private static final String a = "ruby.exe";
    @NonNls
    private static final String f = "ruby";
    @NonNls
    private static final String j = "ir";
    @NonNls
    private static final String k = "macruby";
    @NonNls
    private static final String e = "rbx";
    @NonNls
    private static String i;
    private static final long w;

    protected RubySdkType() {
        long l2 = w ^ 0x61DBE48483CDL;
        super(m);
    }

    protected RubySdkType(@NotNull String type) {
        if (type == null) {
            RubySdkType.a(0);
        }
        super(type);
    }

    @NotNull
    public String getRubyExecutable() {
        String string = i;
        if (string == null) {
            RubySdkType.a(1);
        }
        return string;
    }

    protected String getSdkNamePrefix() {
        long l2 = w ^ 0x6AE6798E56F1L;
        return "ruby";
    }

    protected String expectedExecutableName() {
        long l2 = w ^ 0x7D908666DBCDL;
        return "ruby";
    }

    @NonNls
    public String getBuiltinsName() {
        long l2 = w ^ 0x564543FB7F49L;
        return "builtin.rb";
    }

    public boolean isValidInterpreter(@NotNull File existingCandidate, boolean isWindows) {
        if (existingCandidate == null) {
            RubySdkType.a(2);
        }
        return RubySdkType.isValidRubySdkInterpreter(existingCandidate, isWindows);
    }

    @NonNls
    @NotNull
    public String getGetVersionScript() {
        long l2 = w ^ 0x29E0B0ACDE0EL;
        if (l == null) {
            RubySdkType.a(3);
        }
        return l;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        Collection<String> collection = this.suggestHomePaths();
        if (!collection.isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        Collection<String> collection = RubySdkUtil.suggestRubyHomePaths(RubySdkType.getInstance(), d, h);
        if (collection == null) {
            RubySdkType.a(4);
        }
        return collection;
    }

    @NotNull
    public Comparator<Sdk> getComparator() {
        SdkComparator sdkComparator = SdkComparator.SDK_COMPARATOR;
        if (sdkComparator == null) {
            RubySdkType.a(5);
        }
        return sdkComparator;
    }

    public final boolean isValidSdkHome(@Nullable String path) {
        return this.isValidSdkHome(path, SystemInfo.isWindows);
    }

    public final boolean isValidSdkHome(@Nullable String path, boolean isWindows) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(path)) {
            return this.isValidInterpreter(file, false);
        }
        return file.exists() && this.isValidInterpreter(file, isWindows);
    }

    public final boolean supportsCustomCreateUI() {
        return true;
    }

    public final void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            RubySdkType.a(6);
        }
        if (parentComponent == null) {
            RubySdkType.a(7);
        }
        if (sdkCreatedCallback == null) {
            RubySdkType.a(8);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        RelativePoint relativePoint = RelativePoint.getNorthWestOf((JComponent)parentComponent);
        Consumer consumer = sdkCreatedCallback;
        if (parentComponent instanceof JComboBox) {
            relativePoint = RelativePoint.getSouthEastOf((JComponent)parentComponent);
            consumer = sdk -> {
                if (sdkModel == null) {
                    RubySdkType.a(49);
                }
                if (sdkCreatedCallback == null) {
                    RubySdkType.a(50);
                }
                String string = RVMSupportUtil.getGemsetName(sdk);
                if (RVMSupportUtil.isRVMInterpreter(sdk) && string != null) {
                    Sdk sdk2 = RVMSupportUtil.findRootRVMSdk(sdk, (Collection<? extends Sdk>)ContainerUtil.immutableList((Object[])sdkModel.getSdks()));
                    if (sdk2 != null) {
                        RvmSdkRefresher.createRVMGemset(project, sdk2, string, (NullableConsumer<? super Sdk>)((NullableConsumer)arg_0 -> ((Consumer)sdkCreatedCallback).consume(arg_0)));
                    }
                } else {
                    sdkCreatedCallback.consume(sdk);
                }
            };
        }
        Consumer consumer2 = consumer;
        RubySdkConfigurableUtil.suggestAndAddSdk(project, sdkModel.getSdks(), relativePoint, (NullableConsumer<Sdk>)((NullableConsumer)sdk -> {
            if (sdk != null) {
                consumer2.consume(sdk);
            }
        }), selectedSdk, this);
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.a(9);
        }
        return RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk) || super.sdkHasValidPath(sdk);
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.a(10);
        }
        return RubyVersionUtil.createFakeVersionStringFromSdkName(sdk.getName());
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String string;
        String string2;
        RubyLocalRunner rubyLocalRunner = RubyLocalRunner.getRunner(null);
        try {
            string2 = this.getShortVersion(rubyLocalRunner, sdkHome);
        }
        catch (Exception exception) {
            string2 = null;
        }
        try {
            string = RubyVersionUtil.getPatchLevel(rubyLocalRunner, sdkHome);
        }
        catch (Exception exception) {
            string = null;
        }
        String string3 = this.createSuggestedSdkName(string2, string);
        if (string3 == null) {
            RubySdkType.a(11);
        }
        return string3;
    }

    @NotNull
    public final String createSuggestedSdkName(@Nullable String version, @Nullable String patchLevel) {
        long l2 = w ^ 0x1FDA61CB004DL;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSdkNamePrefix());
        if (!StringUtil.isEmpty((String)version)) {
            stringBuilder.append("-").append(version);
            if (!StringUtil.isEmpty((String)patchLevel)) {
                stringBuilder.append("-p").append(patchLevel);
            }
        }
        String string = stringBuilder.toString();
        if (string == null) {
            RubySdkType.a(12);
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.a(13);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkType.b(sdk);
        if (rubySdkAdditionalData.myIsInitialized) {
            return;
        }
        rubySdkAdditionalData.myIsInitialized = true;
        RubySdkConfigurator.from((SdkAdditionalData)rubySdkAdditionalData).initSdk(sdk);
        rubySdkAdditionalData.myInitializedPaths = false;
        rubySdkAdditionalData.setLanguageLevel(RubyVersionUtil.extractLanguageLevelFromSdkName(sdk.getName()));
        Runnable runnable = () -> {
            long l2 = w ^ 0x1068D9E9FF70L;
            if (sdk == null) {
                RubySdkType.a(48);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting init for " + sdk);
            }
            String string2 = RubyVersionUtil.getFullVersion(sdk, (NullableConsumer<String>)((NullableConsumer)string -> {
                if (string == null) {
                    return;
                }
                throw new RuntimeException((String)string);
            }));
            LanguageLevel languageLevel = RubyVersionUtil.extractLanguageLevelFromVersion(string2);
            rubySdkAdditionalData.setLanguageLevel(languageLevel);
            DataManager.getInstance();
            VirtualFileManager.getInstance();
            RubySdkType.a(sdk, string2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ending init for " + sdk);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            RubySdkLoadPathInitializer.INSTANCE.scheduleInitialization(sdk, runnable);
        }
    }

    @NotNull
    private static RubySdkAdditionalData b(@NotNull Sdk sdk) {
        Object object;
        long l2 = w ^ 0x37A9203BCFB3L;
        if (sdk == null) {
            RubySdkType.a(14);
        }
        if ((object = sdk.getSdkAdditionalData()) == null) {
            SdkModificator sdkModificator = sdk.getSdkModificator();
            RubySystemData rubySystemData = RubySystemVersionManagerHandler.getInstance().createAdditionalData();
            object = new RubySdkAdditionalData().withVersionManagerSdkAdditionalData(rubySystemData);
            sdkModificator.setSdkAdditionalData(object);
            sdkModificator.commitChanges();
        }
        assert (object instanceof RubySdkAdditionalData) : "RubySdkAdditionalData expected, got " + object;
        RubySdkAdditionalData rubySdkAdditionalData = (RubySdkAdditionalData)object;
        if (rubySdkAdditionalData == null) {
            RubySdkType.a(15);
        }
        return rubySdkAdditionalData;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            RubySdkType.a(16);
        }
        if (sdkModificator == null) {
            RubySdkType.a(17);
        }
        return new RubySdkConfigurable();
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            RubySdkType.a(18);
        }
        if (additional == null) {
            RubySdkType.a(19);
        }
        if (additionalData instanceof RubySdkAdditionalData) {
            ((RubySdkAdditionalData)additionalData).save(additional);
        }
    }

    @NotNull
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk sdk, @NotNull Element additional) {
        if (sdk == null) {
            RubySdkType.a(20);
        }
        if (additional == null) {
            RubySdkType.a(21);
        }
        if (additional.getAttributes().size() == 0 && additional.getContent().size() == 0) {
            RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.getEmpty();
            if (rubySdkAdditionalData == null) {
                RubySdkType.a(22);
            }
            return rubySdkAdditionalData;
        }
        String string = sdk.getHomePath();
        assert (string != null);
        if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(string)) {
            RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = RubyRemoteSdkAdditionalData.loadRemote(string, sdk, additional);
            if (rubyRemoteSdkAdditionalData == null) {
                RubySdkType.a(23);
            }
            return rubyRemoteSdkAdditionalData;
        }
        String string2 = RubySdkUtil.getStubsFolder(sdk);
        for (VirtualFile virtualFile : RubySdkUtil.getSdkRoots(sdk)) {
            if (!virtualFile.getName().equals(string2)) continue;
            virtualFile.refresh(true, true);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.load(new RubySdkAdditionalData(), string, sdk, additional);
        if (rubySdkAdditionalData == null) {
            RubySdkType.a(24);
        }
        return rubySdkAdditionalData;
    }

    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    @NotNull
    public String getPresentableName() {
        long l2 = w ^ 0x644F2C978F8FL;
        String string = RBundle.message((String)"sdk.ruby.title");
        if (string == null) {
            RubySdkType.a(25);
        }
        return string;
    }

    public Icon getIcon() {
        return RubyIcons.Ruby.Ruby_module_closed;
    }

    @NotNull
    public String getHelpTopic() {
        long l2 = w ^ 0x137F5B1A6288L;
        if ("reference.project.structure.sdk.ruby" == null) {
            RubySdkType.a(26);
        }
        return "reference.project.structure.sdk.ruby";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = RubyIcons.Ruby.Ruby;
        if (icon == null) {
            RubySdkType.a(27);
        }
        return icon;
    }

    @Nullable
    public String getShortVersion(@NotNull RubyRunner runner, @NotNull String sdkHome) throws ExecutionException {
        if (runner == null) {
            RubySdkType.a(28);
        }
        if (sdkHome == null) {
            RubySdkType.a(29);
        }
        ProcessOutput processOutput = runner.executeInSameThread(RubyRunnerExecutionContext.create(RunnerUtil.collectCommands(sdkHome, this.getGetVersionScript())));
        return RubyVersionUtil.getSDKVersionByOutput(processOutput, true, DEFAULT_SDK_VALIDATION_CALLBACK);
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        long l2 = w ^ 0x641EF2DA075DL;
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){
            private static final long a = la.a(-2982706949565806183L, 3590207650647891846L, MethodHandles.lookup().lookupClass()).a(244106556630847L);

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                boolean bl2;
                long l2 = a ^ 0x412D2DEF8C08L;
                if (files.length != 0 && !(bl2 = RubySdkType.this.isValidSdkHome(files[0].getPath()))) {
                    throw new Exception(RBundle.message((String)"sdk.error.invalid.interpreter.name", (Object[])new Object[]{files[0].getName(), RubySdkType.this.expectedExecutableName(), RubySdkType.this.getRubyExecutable()}));
                }
            }
        }.withTitle("Select Ruby Interpreter Path").withShowHiddenFiles(SystemInfo.isUnix);
        if (fileChooserDescriptor == null) {
            RubySdkType.a(30);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public String getHomeFieldLabel() {
        long l2 = w ^ 0x6D0D8F2E85C3L;
        if ("Ruby interpreter path:" == null) {
            RubySdkType.a(31);
        }
        return "Ruby interpreter path:";
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            RubySdkType.a(32);
        }
        return type == OrderRootType.CLASSES;
    }

    public void createAndAddLocalSdk(@NotNull VirtualFile rubyInterpreter, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        String string;
        long l2 = w ^ 0x1BC7B54985AL;
        if (rubyInterpreter == null) {
            RubySdkType.a(33);
        }
        if (versionManagerSdkAdditionalData == null) {
            RubySdkType.a(34);
        }
        if (!new File(FileUtil.toSystemDependentName((String)(string = rubyInterpreter.getPath()))).exists()) {
            LOG.warn("Cannot create sdk:\n  ruby interpreter: " + rubyInterpreter);
            return;
        }
        RubySdkAdditionalData rubySdkAdditionalData = new RubySdkAdditionalData().withVersionManagerSdkAdditionalData(versionManagerSdkAdditionalData);
        VirtualFile virtualFile = rubyInterpreter.getParent();
        VirtualFile virtualFile2 = virtualFile.getParent();
        String string2 = this.createSdkName(string, virtualFile2, versionManagerSdkAdditionalData);
        Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
        Sdk sdk = SdkConfigurationUtil.setupSdk((Sdk[])sdkArray, (VirtualFile)rubyInterpreter, (SdkType)this, (boolean)true, (SdkAdditionalData)rubySdkAdditionalData, (String)string2);
        if (sdk == null) {
            LOG.warn("Sdk creation failed for " + rubyInterpreter);
            return;
        }
        Runnable runnable = () -> SdkConfigurationUtil.addSdk((Sdk)sdk);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    @NotNull
    public String createSdkName(String interpreterPath, VirtualFile sdkHomeFolder, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        if (versionManagerSdkAdditionalData == null) {
            RubySdkType.a(35);
        }
        for (SdkRefresher sdkRefresher : (SdkRefresher[])SdkRefresher.EP_NAME.getExtensions()) {
            String string = sdkRefresher.suggestSdkName(interpreterPath, sdkHomeFolder.getName(), versionManagerSdkAdditionalData);
            if (string == null) continue;
            String string2 = string;
            if (string2 == null) {
                RubySdkType.a(36);
            }
            return string2;
        }
        String string = this.suggestSdkName(null, interpreterPath);
        if (string == null) {
            RubySdkType.a(37);
        }
        return string;
    }

    public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkType.a(38);
        }
        return !RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk);
    }

    public static RubySdkType getInstance() {
        return (RubySdkType)SdkType.findInstance(RubySdkType.class);
    }

    @Nullable
    public static String getBinPath(@Nullable Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        SdkTypeId sdkTypeId = sdk.getSdkType();
        if (sdkTypeId instanceof RubySdkType) {
            return RubySdkAdditionalData.notNullFrom(sdk).getGemsBinDirectory();
        }
        return null;
    }

    @Nullable
    public static String getPlatform(@NotNull Sdk sdk) {
        SdkTypeId sdkTypeId;
        if (sdk == null) {
            RubySdkType.a(39);
        }
        return (sdkTypeId = sdk.getSdkType()) instanceof RubySdkType ? RubySdkAdditionalData.notNullFrom(sdk).getPlatform() : null;
    }

    @NotNull
    static List<String> findGemsRoots(@NotNull SdkModificator sdkModificator) {
        VirtualFile[] virtualFileArray;
        if (sdkModificator == null) {
            RubySdkType.a(40);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (VirtualFile virtualFile : virtualFileArray = sdkModificator.getRoots(OrderRootType.SOURCES)) {
            String string = virtualFile.getUrl();
            if (!GemUtil.isGemsRootUrl(string)) continue;
            linkedList.add(string);
            sdkModificator.removeRoot(virtualFile, OrderRootType.CLASSES);
            sdkModificator.removeRoot(virtualFile, OrderRootType.SOURCES);
        }
        LinkedList<String> linkedList2 = linkedList;
        if (linkedList2 == null) {
            RubySdkType.a(41);
        }
        return linkedList2;
    }

    public static boolean isValidRubySdkInterpreter(@NotNull File existingCandidate, boolean isWindows) {
        long l2 = w ^ 0x26EBE39A5E50L;
        if (existingCandidate == null) {
            RubySdkType.a(42);
        }
        String string = FileUtil.getNameWithoutExtension((File)existingCandidate).toLowerCase(Locale.US);
        String string2 = existingCandidate.getName().toLowerCase(Locale.US);
        if (isWindows && !string2.endsWith(".exe") && !string2.endsWith(".bat") && !string2.endsWith(".cmd")) {
            return false;
        }
        return (string.startsWith("ruby") || string.startsWith("ir") || string.startsWith(e) || string.startsWith(k) || string.startsWith(MAGLEV_INTERPRETER_NAME)) && !JRubySdkType.isValidJrubySdkInterpreter(existingCandidate, isWindows);
    }

    private static void a(@NotNull Sdk sdk, String string) {
        if (sdk == null) {
            RubySdkType.a(43);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        Set<String> set = RubySdkType.buildSdkLoadpath(sdk);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        List list2 = set.stream().map(arg_0 -> ((VirtualFileManager)virtualFileManager).findFileByUrl(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        rubySdkAdditionalData.myTemporaryRoots = list2;
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> {
            long l2 = w ^ 0x6EB80E590822L;
            if (sdk == null) {
                RubySdkType.a(47);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enter transaction for " + sdk);
            }
            if (RubySdkUtil.isRubySdkDisposed(sdk)) {
                return;
            }
            SdkModificator sdkModificator = sdk.getSdkModificator();
            for (VirtualFile virtualFile : list2) {
                RubySdkUtil.addToSourceAndClasses(sdkModificator, virtualFile);
            }
            sdkModificator.setVersionString(string);
            LOG.debug("Request write action");
            ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
            rubySdkAdditionalData.myInitializedPaths = true;
            rubySdkAdditionalData.myTemporaryRoots = null;
            ((SdkPathsInitializedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SDK_PATHS_INITIALIZED_TOPIC)).sdkPathsInitialized(sdk);
            if (LOG.isDebugEnabled()) {
                LOG.debug("End of write action and flush for " + sdkModificator);
            }
        });
    }

    public static Set<String> buildSdkLoadpath(@NotNull Sdk sdk) {
        long l2 = w ^ 0x1E82AB10527BL;
        if (sdk == null) {
            RubySdkType.a(44);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk)) {
            linkedHashSet.addAll(rubySdkAdditionalData.getGemsRootUrls());
        } else {
            try {
                String[] stringArray;
                String string = sdk.getHomePath();
                assert (string != null);
                List<String> list2 = RunnerUtil.collectCommands(string, n);
                list2.set(0, RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(list2.get(0)));
                ProcessOutput processOutput = rubySdkAdditionalData.getRunner(null).executeInSameThread(RubyRunnerExecutionContext.create(sdk, list2));
                for (String string2 : stringArray = StringUtil.splitByLines((String)processOutput.getStdout())) {
                    String string3 = string2.trim();
                    if (string3.equals(".")) continue;
                    linkedHashSet.add(VirtualFileUtil.constructLocalUrl(RubySdkUtil.unCygwinizePath(sdk, string3)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (JRubySdkUtil.isJRubySDK(sdk)) {
                linkedHashSet.add(JRubySdkUtil.getSourcesPathInJRubyJarFile(sdk));
            }
        }
        RubySdkType.addRubyStubsUrls(linkedHashSet, sdk);
        return linkedHashSet;
    }

    public static void addRubyStubsUrls(Set<String> urls, @NotNull Sdk sdk) {
        long l2 = w ^ 0x57AEB561D1A4L;
        if (sdk == null) {
            RubySdkType.a(45);
        }
        String string = PathUtil.getJarPathForClass(RubySdkType.class);
        String string2 = RubySdkUtil.getStubsFolder(sdk);
        if (string.endsWith(c)) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
            LOG.assertTrue(virtualFile != null, (Object)"jar file cannot be null");
            RubySdkType.a(urls, virtualFile, string2);
        }
        RubySdkType.a(urls, string2);
    }

    private static void a(Set<String> set, VirtualFile virtualFile, String string) {
        long l2 = w ^ 0x7492AB7D7502L;
        VirtualFile virtualFile2 = virtualFile.getParent().getParent();
        LOG.assertTrue(virtualFile2 != null, (Object)"Home folder cannot be null");
        VirtualFile virtualFile3 = virtualFile2.findChild("rubystubs");
        virtualFile3 = virtualFile3 != null ? virtualFile3.findChild(string) : virtualFile2.findChild(string);
        LOG.assertTrue(virtualFile3 != null, (Object)("Installation seems to be corrupted: " + string + " directory cannot be null"));
        set.add(virtualFile3.getUrl());
    }

    private static void a(Set<String> set, String string) {
        long l2 = w ^ 0x198C96E1F969L;
        URL uRL = RubySdkType.class.getClassLoader().getResource(string + "/kernel.rb");
        if (uRL != null) {
            String string2 = uRL.getProtocol();
            String string3 = uRL.getPath();
            string3 = string3.substring(0, string3.lastIndexOf(47));
            String string4 = VfsUtilCore.fixURLforIDEA((String)(string2 + ":" + string3));
            set.add(URLUtil.unescapePercentSequences((String)string4));
        }
    }

    @NotNull
    public static ArrayList<Sdk> getAllValidRubySdks() {
        Sdk[] sdkArray;
        ArrayList<Sdk> arrayList = new ArrayList<Sdk>();
        for (Sdk sdk : sdkArray = ProjectJdkTable.getInstance().getAllJdks()) {
            if (!RubySdkUtil.isSDKValid(sdk)) continue;
            arrayList.add(sdk);
        }
        ArrayList<Sdk> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RubySdkType.a(46);
        }
        return arrayList2;
    }

    public static boolean hasValidRubySdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!RubySdkUtil.isSDKValid(sdk)) continue;
            return true;
        }
        return false;
    }

    static {
        w = la.a(4958128442141567815L, -3744126789223472432L, MethodHandles.lookup().lookupClass()).a(52540611413109L);
        long l2 = w ^ 0x4A0F4BD83B03L;
        SDK_PATHS_INITIALIZED_TOPIC = Topic.create((String)"SDK_PATHS_INITIALIZED", SdkPathsInitializedListener.class);
        LOG = Logger.getInstance(RubySdkType.class);
        DEFAULT_SDK_VALIDATION_CALLBACK = arg_0 -> ((Logger)LOG).warn(arg_0);
        h = new String[]{"/usr/bin/ruby"};
        d = new String[]{"C:\\ruby\\bin\\ruby.exe"};
        if (SystemInfo.isWindows) {
            i = a;
        } else if (SystemInfo.isUnix) {
            i = "ruby";
        } else {
            LOG.error(RBundle.message((String)"os.not.supported"));
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = w ^ 0x72C3CD0873FFL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 41: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 41: 
            case 46: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkType";
                break;
            }
            case 2: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingCandidate";
                break;
            }
            case 6: 
            case 16: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 8: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 17: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyInterpreter";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyExecutable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetVersionScript";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuggestedSdkName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDataWithLazyInitialization";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAdditionalData";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeFieldLabel";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findGemsRoots";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidRubySdks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 41: 
            case 46: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidInterpreter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 13: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalDataWithLazyInitialization";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getShortVersion";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddLocalSdk";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createSdkName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findGemsRoots";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isValidRubySdkInterpreter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkLoadpath";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addRubyStubsUrls";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setupSdkPaths$5";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setupSdkPaths$3";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showCustomCreateUI$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 41: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface SdkPathsInitializedListener {
        public void sdkPathsInitialized(@NotNull Sdk var1);
    }
}

