/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramCreateNewElementAction<T, Result>
extends DiagramActionWithPreparation<Result> {
    public static final DiagramCreateNewElementAction[] EMPTY = new DiagramCreateNewElementAction[0];

    protected DiagramCreateNewElementAction(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    @Nullable
    public abstract T createElement(DiagramDataModel<T> var1, Result var2, AnActionEvent var3);

    @Override
    public final void execute(DiagramBuilder builder, Result result, AnActionEvent e) {
        DiagramDataModel model = builder.getDataModel();
        T element = this.createElement(model, result, e);
        if (element != null) {
            Node n;
            DiagramNode<T> node = model.addElement(element);
            if (node != null) {
                model.refreshDataModel();
                builder.update(true, false);
                IdeFocusManager.getInstance((Project)builder.getProject()).requestFocus((Component)builder.getView().getCanvasComponent(), true);
            }
            if ((n = builder.getNode(node)) != null) {
                builder.getGraph().selectAllNodesAndBends(false);
                builder.getGraph().setSelected(n, true);
            }
        }
    }
}

