/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeElementComponent
extends CellRendererPanel {
    private final SimpleColoredComponent myLeft = new SimpleColoredComponent();
    private final SimpleColoredComponent myRight = new SimpleColoredComponent();

    public DiagramNodeElementComponent() {
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)1, (int)2));
        this.add((Component)this.myLeft, "West");
        this.add((Component)this.myRight, "East");
        if (GraphViewUtil.isPrintMode()) {
            this.setBackground(Color.WHITE);
        }
    }

    public void setUp(DiagramBuilder builder, DiagramNode node, Object element, boolean selected, Color color) {
        this.myLeft.clear();
        this.myRight.clear();
        DiagramProvider provider = builder.getProvider();
        DiagramElementManager mgr = provider.getElementManager();
        Color fgColor = selected ? provider.getColorManager().getNodeForegroundColor(selected) : color;
        this.myLeft.setIcon(mgr.getItemIcon(element, builder.getPresentation()));
        this.myLeft.setForeground(fgColor);
        Color anchorColor = DiagramNodeElementComponent.getAnchorColor(builder, node, element);
        SimpleColoredText text = mgr.getItemName(element, builder.getPresentation());
        if (text != null) {
            if (selected) {
                text = DiagramNodeElementComponent.changeForegroundColor(fgColor, text);
            }
            if (anchorColor != null) {
                text = DiagramNodeElementComponent.setAnchor(selected, text, anchorColor);
            }
            if (GraphViewUtil.isPrintMode()) {
                text = DiagramNodeElementComponent.changeForegroundColor(Color.black, text);
                this.myLeft.setOpaque(false);
                this.myLeft.setIconOpaque(false);
            }
            text.appendToComponent((ColoredTextContainer)this.myLeft);
        }
        SimpleColoredText typeText = mgr.getItemType(element);
        this.myRight.setForeground(fgColor);
        this.myRight.setOpaque(false);
        this.myRight.setIconOpaque(false);
        if (typeText != null) {
            if (selected) {
                typeText = DiagramNodeElementComponent.changeForegroundColor(fgColor, typeText);
            }
            if (anchorColor != null) {
                typeText = DiagramNodeElementComponent.setAnchor(selected, typeText, anchorColor);
            }
            if (GraphViewUtil.isPrintMode()) {
                typeText = DiagramNodeElementComponent.changeForegroundColor(Color.black, typeText);
                this.myRight.setBackground(Color.WHITE);
            }
            typeText.appendToComponent((ColoredTextContainer)this.myRight);
        }
        this.init(selected, builder, element);
    }

    @Nullable
    private static Color getAnchorColor(DiagramBuilder builder, DiagramNode node, Object element) {
        DiagramEdge e;
        Object anchor;
        Edge edge;
        Node yNode = builder.getNode(node);
        if (yNode == null) {
            return null;
        }
        EdgeCursor in = yNode.inEdges();
        EdgeCursor out = yNode.outEdges();
        while ((edge = in.edge()) != null) {
            if (builder.getGraph().isSelected(edge) && (anchor = (e = builder.getEdgeObject(edge)).getTargetAnchor()) != null && element.equals(anchor)) {
                Color color = e.getAnchorColor();
                return color == null ? JBColor.foreground() : color;
            }
            in.next();
        }
        while ((edge = out.edge()) != null) {
            if (builder.getGraph().isSelected(edge) && (anchor = (e = builder.getEdgeObject(edge)).getSourceAnchor()) != null && element.equals(anchor)) {
                Color color = e.getAnchorColor();
                return color == null ? JBColor.foreground() : color;
            }
            out.next();
        }
        return null;
    }

    private static SimpleColoredText changeForegroundColor(Color fgColor, SimpleColoredText text) {
        SimpleColoredText txt = new SimpleColoredText();
        ArrayList attrs = text.getAttributes();
        ArrayList texts = text.getTexts();
        for (int i = 0; i < texts.size(); ++i) {
            SimpleTextAttributes attr = (SimpleTextAttributes)attrs.get(i);
            txt.append((String)texts.get(i), new SimpleTextAttributes(GraphViewUtil.isPrintMode() ? Color.white : attr.getBgColor(), fgColor, attr.getWaveColor(), attr.getStyle()));
        }
        return txt;
    }

    private static SimpleColoredText setAnchor(boolean selected, SimpleColoredText text, Color anchorColor) {
        SimpleColoredText txt = new SimpleColoredText();
        ArrayList attrs = text.getAttributes();
        ArrayList texts = text.getTexts();
        for (int i = 0; i < texts.size(); ++i) {
            SimpleTextAttributes attr = (SimpleTextAttributes)attrs.get(i);
            txt.append((String)texts.get(i), new SimpleTextAttributes(attr.getBgColor(), selected ? attr.getFgColor() : anchorColor, attr.getWaveColor(), attr.getStyle() | 1));
        }
        return txt;
    }

    private void init(boolean selected, DiagramBuilder builder, Object element) {
        this.setPreferredSize(null);
        Dimension preferredSize = this.getPreferredSize();
        this.setPreferredSize(new Dimension((int)preferredSize.getWidth() + 20, (int)preferredSize.getHeight()));
        if (!GraphViewUtil.isPrintMode()) {
            DiagramColorManager colorManager = builder.getProvider().getColorManager();
            this.setBackground(colorManager.getNodeBackground(builder.getProject(), element, selected));
            this.myLeft.setForeground(colorManager.getNodeForegroundColor(selected));
            this.myRight.setForeground(colorManager.getNodeForegroundColor(selected));
        } else {
            this.myLeft.setForeground((Color)JBColor.BLACK);
            this.myRight.setForeground((Color)JBColor.BLACK);
            this.myLeft.setBackground((Color)JBColor.WHITE);
            this.myRight.setBackground((Color)JBColor.WHITE);
            this.setBackground((Color)JBColor.WHITE);
            this.setForeground((Color)JBColor.BLACK);
        }
    }
}

